/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PropertySet {
    private Hashtable<String, String> properties = new Hashtable();
    private String sName = "";

    public int getSize() {
        return this.properties.size();
    }

    public String getProperty(String sPropName) {
        if (sPropName != null) {
            String sValue = this.properties.get(sPropName);
            if (sValue != null && sValue.endsWith("inch")) {
                return sValue.substring(0, sValue.length() - 2);
            }
            return sValue;
        }
        return null;
    }

    public String getName() {
        return this.sName;
    }

    public void loadFromDOM(Node node) {
        if (node != null) {
            this.sName = node.getNodeName();
            NamedNodeMap attrNodes = node.getAttributes();
            if (attrNodes != null) {
                int nLen = attrNodes.getLength();
                for (int i = 0; i < nLen; ++i) {
                    Node attr = attrNodes.item(i);
                    this.properties.put(attr.getNodeName(), attr.getNodeValue());
                }
            }
        }
    }

    public boolean containsProperty(String sProperty) {
        return sProperty != null && this.properties.containsKey(sProperty);
    }

    public void setProperty(String sProperty, String sValue) {
        this.properties.put(sProperty, sValue);
    }

    public String toString() {
        String s = "";
        Enumeration<String> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String sKey = keys.nextElement();
            String sValue = this.properties.get(sKey);
            s = s + sKey + "=" + sValue + " ";
        }
        return s;
    }
}

