/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import org.videolan.io.ConnectorImpl;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;

    public static Connection open(String name) throws IOException {
        return Connector.open(name, 3);
    }

    public static Connection open(String name, int mode) throws IOException {
        return Connector.open(name, mode, false);
    }

    public static Connection open(String name, int mode, boolean timeouts) throws IOException {
        if (mode != 1 && mode != 2 && mode != 3) {
            throw new IllegalArgumentException("invalid mode");
        }
        if (name == null) {
            throw new IllegalArgumentException("null URL");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("empty URL");
        }
        return ConnectorImpl.open(name, mode, timeouts);
    }

    public static DataInputStream openDataInputStream(String name) throws IOException {
        InputConnection ic = null;
        try {
            ic = (InputConnection)Connector.open(name, 1);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(name);
        }
        try {
            DataInputStream dataInputStream = ic.openDataInputStream();
            return dataInputStream;
        }
        finally {
            ic.close();
        }
    }

    public static DataOutputStream openDataOutputStream(String name) throws IOException {
        OutputConnection oc = null;
        try {
            oc = (OutputConnection)Connector.open(name, 2);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(name);
        }
        try {
            DataOutputStream dataOutputStream = oc.openDataOutputStream();
            return dataOutputStream;
        }
        finally {
            oc.close();
        }
    }

    public static InputStream openInputStream(String name) throws IOException {
        return Connector.openDataInputStream(name);
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        return Connector.openDataOutputStream(name);
    }
}

