/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.app.event.implement;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.Info;

public class PrintExceptions
implements MethodExceptionEventHandler,
RuntimeServicesAware {
    private static String SHOW_TEMPLATE_INFO = "eventhandler.methodexception.templateinfo";
    private static String SHOW_STACK_TRACE = "eventhandler.methodexception.stacktrace";
    private RuntimeServices rs = null;

    @Override
    public Object methodException(Context context, Class clazz, String string, Exception exception, Info info) {
        boolean bl = this.rs.getBoolean(SHOW_TEMPLATE_INFO, false);
        boolean bl2 = this.rs.getBoolean(SHOW_STACK_TRACE, false);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Exception while executing method ").append(clazz.toString()).append(".").append(string);
        stringBuilder.append(": ").append(exception.getClass().getName()).append(": ").append(exception.getMessage());
        if (bl) {
            stringBuilder.append(" at ").append(info.getTemplateName()).append(" (line ").append(info.getLine()).append(", column ").append(info.getColumn()).append(")");
        }
        if (bl2) {
            stringBuilder.append(System.lineSeparator()).append(PrintExceptions.getStackTrace(exception));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStackTrace(Throwable throwable) {
        try (PrintWriter printWriter = null;){
            StringWriter stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            String string = stringWriter.toString();
            return string;
        }
    }

    @Override
    public void setRuntimeServices(RuntimeServices runtimeServices) {
        this.rs = runtimeServices;
    }
}

