/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common;

import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaWriterImpl
implements WSDLWriter {
    public static final int DEFAULT_INDENT_LEVEL = 0;

    public Element getElement(Definition wsdlDef) throws WSDLException {
        Types types = wsdlDef.getTypes();
        if (types != null) {
            List l = CastUtils.cast((List)types.getExtensibilityElements());
            if (l == null) {
                return null;
            }
            for (ExtensibilityElement e : l) {
                if (!(e instanceof Schema)) continue;
                Schema sc = (Schema)e;
                return sc.getElement();
            }
        }
        return null;
    }

    public Document getDocument(Definition wsdlDef) throws WSDLException {
        Element el = this.getElement(wsdlDef);
        Document doc = DOMUtils.createDocument();
        doc.appendChild(doc.importNode(el, true));
        return doc;
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
    }

    public boolean getFeature(String name) throws IllegalArgumentException {
        return false;
    }

    public void writeWSDL(Definition wsdlDef, Writer sink) throws WSDLException {
        try {
            StaxUtils.writeTo((Node)this.getDocument(wsdlDef), (Writer)sink, (int)2);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeWSDL(Definition wsdlDef, OutputStream sink) throws WSDLException {
        try {
            StaxUtils.writeTo((Node)this.getDocument(wsdlDef), (OutputStream)sink, (int)2);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }
}

