/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.group.impl;

import org.apache.activemq.artemis.api.core.SimpleString;

public class Response {
    private final boolean accepted;
    private final SimpleString clusterName;
    private final SimpleString alternativeClusterName;
    private final SimpleString groupId;
    private volatile long timeUsed;

    public Response(SimpleString groupId, SimpleString clusterName) {
        this(groupId, clusterName, null);
    }

    public Response(SimpleString groupId, SimpleString clusterName, SimpleString alternativeClusterName) {
        this.groupId = groupId;
        this.accepted = alternativeClusterName == null;
        this.clusterName = clusterName;
        this.alternativeClusterName = alternativeClusterName;
        this.use();
    }

    public void use() {
        this.timeUsed = System.currentTimeMillis();
    }

    public long getTimeUsed() {
        return this.timeUsed;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public SimpleString getClusterName() {
        return this.clusterName;
    }

    public SimpleString getAlternativeClusterName() {
        return this.alternativeClusterName;
    }

    public SimpleString getChosenClusterName() {
        return this.alternativeClusterName != null ? this.alternativeClusterName : this.clusterName;
    }

    public String toString() {
        return "accepted = " + this.accepted + " groupid = " + String.valueOf(this.groupId) + " clusterName = " + String.valueOf(this.clusterName) + " alternativeClusterName = " + String.valueOf(this.alternativeClusterName);
    }

    public SimpleString getGroupId() {
        return this.groupId;
    }
}

