/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.activemq.artemis.core.security.Role;

public class SecurityFormatter {
    public static Set<Role> createSecurity(String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles, String browseRoles, String createAddressRoles, String deleteAddressRoles) {
        List<String> createDurableQueue = SecurityFormatter.toList(createDurableQueueRoles);
        List<String> deleteDurableQueue = SecurityFormatter.toList(deleteDurableQueueRoles);
        List<String> createNonDurableQueue = SecurityFormatter.toList(createNonDurableQueueRoles);
        List<String> deleteNonDurableQueue = SecurityFormatter.toList(deleteNonDurableQueueRoles);
        List<String> send = SecurityFormatter.toList(sendRoles);
        List<String> consume = SecurityFormatter.toList(consumeRoles);
        List<String> manage = SecurityFormatter.toList(manageRoles);
        List<String> browse = SecurityFormatter.toList(browseRoles);
        List<String> createAddress = SecurityFormatter.toList(createAddressRoles);
        List<String> deleteAddress = SecurityFormatter.toList(deleteAddressRoles);
        HashSet<String> allRoles = new HashSet<String>();
        allRoles.addAll(createDurableQueue);
        allRoles.addAll(deleteDurableQueue);
        allRoles.addAll(createNonDurableQueue);
        allRoles.addAll(deleteNonDurableQueue);
        allRoles.addAll(send);
        allRoles.addAll(consume);
        allRoles.addAll(manage);
        allRoles.addAll(browse);
        allRoles.addAll(createAddress);
        allRoles.addAll(deleteAddress);
        HashSet<Role> roles = new HashSet<Role>(allRoles.size());
        for (String role : allRoles) {
            roles.add(new Role(role, send.contains(role), consume.contains(role), createDurableQueue.contains(role), deleteDurableQueue.contains(role), createNonDurableQueue.contains(role), deleteNonDurableQueue.contains(role), manageRoles.contains(role), browse.contains(role), createAddressRoles.contains(role), deleteAddressRoles.contains(role), false, false));
        }
        return roles;
    }

    private static List<String> toList(String commaSeparatedString) {
        if (commaSeparatedString == null || commaSeparatedString.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return (List)List.class.cast(Collections.list(new StringTokenizer(commaSeparatedString, ", ")));
    }
}

