/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.services.AbstractTokenService;

@Path(value="/revoke")
public class TokenRevocationService
extends AbstractTokenService {
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response handleTokenRevocation(MultivaluedMap<String, String> params) {
        Client client = this.authenticateClientIfNeeded(params);
        String token = (String)params.getFirst((Object)"token");
        if (token == null) {
            return this.createErrorResponse(params, "unsupported_token_type");
        }
        String tokenTypeHint = (String)params.getFirst((Object)"token_type_hint");
        if (tokenTypeHint != null && !"access_token".equals(tokenTypeHint) && !"refresh_token".equals(tokenTypeHint)) {
            return this.createErrorResponseFromErrorCode("unsupported_token_type");
        }
        try {
            this.getDataProvider().revokeToken(client, token, tokenTypeHint);
        }
        catch (OAuthServiceException oAuthServiceException) {
            // empty catch block
        }
        return Response.ok().build();
    }
}

