/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.json.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.commons.shaded.json.JsonNumber;
import org.apache.activemq.artemis.commons.shaded.json.JsonString;
import org.apache.activemq.artemis.commons.shaded.json.JsonValue;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.json.impl.JsonArrayImpl;
import org.apache.activemq.artemis.json.impl.JsonNumberImpl;
import org.apache.activemq.artemis.json.impl.JsonObjectImpl;
import org.apache.activemq.artemis.json.impl.JsonStringImpl;

public class JsonValueImpl
implements JsonValue {
    private Map<org.apache.activemq.artemis.commons.shaded.json.JsonValue, JsonValue> cache = new HashMap<org.apache.activemq.artemis.commons.shaded.json.JsonValue, JsonValue>();
    private final org.apache.activemq.artemis.commons.shaded.json.JsonValue rawValue;

    public JsonValue wrap(org.apache.activemq.artemis.commons.shaded.json.JsonValue rawValue) {
        if (rawValue == null) {
            return null;
        }
        JsonValue cacheValue = this.cache.get(rawValue);
        if (cacheValue != null) {
            return cacheValue;
        }
        if (rawValue == org.apache.activemq.artemis.commons.shaded.json.JsonValue.EMPTY_JSON_OBJECT) {
            return JsonValue.EMPTY_JSON_OBJECT;
        }
        if (rawValue == org.apache.activemq.artemis.commons.shaded.json.JsonValue.EMPTY_JSON_ARRAY) {
            return JsonValue.EMPTY_JSON_ARRAY;
        }
        if (rawValue == org.apache.activemq.artemis.commons.shaded.json.JsonValue.TRUE) {
            return JsonValue.TRUE;
        }
        if (rawValue == org.apache.activemq.artemis.commons.shaded.json.JsonValue.FALSE) {
            return JsonValue.FALSE;
        }
        if (rawValue == org.apache.activemq.artemis.commons.shaded.json.JsonValue.NULL) {
            return JsonValue.NULL;
        }
        if (rawValue.getValueType() == JsonValue.ValueType.ARRAY) {
            cacheValue = new JsonArrayImpl((org.apache.activemq.artemis.commons.shaded.json.JsonArray)rawValue);
        } else if (rawValue.getValueType() == JsonValue.ValueType.OBJECT) {
            cacheValue = new JsonObjectImpl((org.apache.activemq.artemis.commons.shaded.json.JsonObject)rawValue);
        } else if (rawValue.getValueType() == JsonValue.ValueType.STRING) {
            cacheValue = new JsonStringImpl((JsonString)rawValue);
        } else if (rawValue.getValueType() == JsonValue.ValueType.NUMBER) {
            cacheValue = new JsonNumberImpl((JsonNumber)rawValue);
        } else if (rawValue.getValueType() == JsonValue.ValueType.TRUE) {
            cacheValue = new JsonValueImpl(rawValue);
        } else if (rawValue.getValueType() == JsonValue.ValueType.FALSE) {
            cacheValue = new JsonValueImpl(rawValue);
        } else if (rawValue.getValueType() == JsonValue.ValueType.NULL) {
            cacheValue = new JsonValueImpl(rawValue);
        } else {
            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)rawValue.getValueType()));
        }
        this.cache.put(rawValue, cacheValue);
        return cacheValue;
    }

    public org.apache.activemq.artemis.commons.shaded.json.JsonValue getRawValue() {
        return this.rawValue;
    }

    public JsonValueImpl(org.apache.activemq.artemis.commons.shaded.json.JsonValue rawValue) {
        this.rawValue = Objects.requireNonNull(rawValue);
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.valueOf(this.rawValue.getValueType().name());
    }

    @Override
    public JsonObject asJsonObject() {
        return JsonValue.super.asJsonObject();
    }

    @Override
    public JsonArray asJsonArray() {
        return JsonValue.super.asJsonArray();
    }

    @Override
    public String toString() {
        return this.rawValue.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonValueImpl)) {
            return false;
        }
        JsonValueImpl other = (JsonValueImpl)obj;
        return Objects.equals(this.rawValue, other.getRawValue());
    }

    public int hashCode() {
        return Objects.hashCode(this.rawValue);
    }
}

