/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.src.util.MutableRecordAndPosition;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.connector.file.src.util.RecyclableIterator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.columnar.ColumnarRowData;

@Internal
public class ColumnarRowIterator
extends RecyclableIterator<RowData> {
    private final ColumnarRowData rowData;
    private final MutableRecordAndPosition<RowData> recordAndPosition;
    private int num;
    private int pos;

    public ColumnarRowIterator(ColumnarRowData rowData, @Nullable Runnable recycler) {
        super(recycler);
        this.rowData = rowData;
        this.recordAndPosition = new MutableRecordAndPosition();
    }

    public void set(int num, long recordSkipCount) {
        this.set(num, -1L, recordSkipCount);
    }

    public void set(int num, long offset, long recordSkipCount) {
        this.num = num;
        this.pos = 0;
        this.recordAndPosition.set(null, offset, recordSkipCount);
    }

    @Override
    @Nullable
    public RecordAndPosition<RowData> next() {
        if (this.pos < this.num) {
            this.rowData.setRowId(this.pos++);
            this.recordAndPosition.setNext((RowData)this.rowData);
            return this.recordAndPosition;
        }
        return null;
    }
}

