/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableSet;
import org.apache.flink.table.api.config.ExecutionConfigOptions;

@Internal
public class LookupJoinHintOptions {
    public static final ConfigOption<String> LOOKUP_TABLE = ConfigOptions.key((String)"table").stringType().noDefaultValue().withDescription("The table name of the lookup source.");
    public static final ConfigOption<Boolean> ASYNC_LOOKUP = ConfigOptions.key((String)"async").booleanType().noDefaultValue().withDescription("Value can be 'true' or 'false' to suggest the planner choose the corresponding lookup function. If the backend lookup source does not support the suggested lookup mode, it will take no effect.");
    public static final ConfigOption<ExecutionConfigOptions.AsyncOutputMode> ASYNC_OUTPUT_MODE = ConfigOptions.key((String)"output-mode").enumType(ExecutionConfigOptions.AsyncOutputMode.class).noDefaultValue().withDescription("Output mode for asynchronous operations which will convert to {@see AsyncDataStream.OutputMode}, ORDERED by default. If set to ALLOW_UNORDERED, will attempt to use {@see AsyncDataStream.OutputMode.UNORDERED} when it does not affect the correctness of the result, otherwise ORDERED will be still used.");
    public static final ConfigOption<Integer> ASYNC_CAPACITY = ConfigOptions.key((String)"capacity").intType().noDefaultValue().withDescription("The max number of async i/o operation that the async lookup join can trigger.");
    public static final ConfigOption<Duration> ASYNC_TIMEOUT = ConfigOptions.key((String)"timeout").durationType().noDefaultValue().withDescription("Timeout from first invoke to final completion of asynchronous operation, may include multiple retries, and will be reset in case of failover.");
    public static final ConfigOption<String> RETRY_PREDICATE = ConfigOptions.key((String)"retry-predicate").stringType().noDefaultValue().withDescription("A predicate expresses the retry condition, can be 'lookup-miss' which will enable retry if lookup result is empty.");
    public static final ConfigOption<RetryStrategy> RETRY_STRATEGY = ConfigOptions.key((String)"retry-strategy").enumType(RetryStrategy.class).noDefaultValue().withDescription("The retry strategy name, can be 'fixed-delay' for now.");
    public static final ConfigOption<Duration> FIXED_DELAY = ConfigOptions.key((String)"fixed-delay").durationType().noDefaultValue().withDescription("Delay time for the 'fixed-delay' retry strategy.");
    public static final ConfigOption<Integer> MAX_ATTEMPTS = ConfigOptions.key((String)"max-attempts").intType().noDefaultValue().withDescription("Max attempt number of the 'fixed-delay' retry strategy.");
    public static final String LOOKUP_MISS_PREDICATE = "lookup_miss";
    private static Set<ConfigOption> requiredKeys = new HashSet<ConfigOption>();
    private static Set<ConfigOption> supportedKeys = new HashSet<ConfigOption>();

    private LookupJoinHintOptions() {
    }

    public static ImmutableSet<ConfigOption> getRequiredOptions() {
        return ImmutableSet.copyOf(requiredKeys);
    }

    public static ImmutableSet<ConfigOption> getSupportedOptions() {
        return ImmutableSet.copyOf(supportedKeys);
    }

    static {
        requiredKeys.add(LOOKUP_TABLE);
        supportedKeys.add(LOOKUP_TABLE);
        supportedKeys.add(ASYNC_LOOKUP);
        supportedKeys.add(ASYNC_CAPACITY);
        supportedKeys.add(ASYNC_TIMEOUT);
        supportedKeys.add(ASYNC_OUTPUT_MODE);
        supportedKeys.add(RETRY_PREDICATE);
        supportedKeys.add(RETRY_STRATEGY);
        supportedKeys.add(FIXED_DELAY);
        supportedKeys.add(MAX_ATTEMPTS);
    }

    public static enum RetryStrategy {
        FIXED_DELAY;

    }
}

