/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class ExecNodeContext {
    private static final Pattern transformationNamePattern = Pattern.compile("[a-z\\-]+");
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    private final Integer id;
    private final String name;
    private final Integer version;

    public static int newNodeId() {
        return idCounter.incrementAndGet();
    }

    @VisibleForTesting
    public static void resetIdCounter() {
        idCounter.set(0);
    }

    private ExecNodeContext() {
        this(null, null, null);
    }

    private ExecNodeContext(String name, Integer version) {
        this(null, name, version);
    }

    private ExecNodeContext(@Nullable Integer id, String name, Integer version) {
        this.id = id;
        this.name = name;
        this.version = version;
    }

    @JsonCreator
    public ExecNodeContext(String value) {
        this.id = null;
        String[] split = value.split("_");
        this.name = split[0];
        this.version = Integer.valueOf(split[1]);
    }

    int getId() {
        return (Integer)Preconditions.checkNotNull((Object)this.id);
    }

    public String getName() {
        return this.name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String generateUid(String transformationName, ExecNodeConfig config) {
        if (!transformationNamePattern.matcher(transformationName).matches()) {
            throw new TableException("Invalid transformation name '" + transformationName + "'. This is a bug, please file an issue.");
        }
        String uidPattern = (String)config.get(ExecutionConfigOptions.TABLE_EXEC_UID_FORMAT);
        return StringUtils.replaceEach((String)uidPattern, (String[])new String[]{"<id>", "<type>", "<version>", "<transformation>"}, (String[])new String[]{String.valueOf(this.id), this.name, String.valueOf(this.version), transformationName});
    }

    public ExecNodeContext withId(int id) {
        return new ExecNodeContext(id, this.name, this.version);
    }

    @JsonValue
    public String getTypeAsString() {
        return this.name + "_" + this.version;
    }

    public String toString() {
        return this.getId() + "_" + this.getTypeAsString();
    }

    public static <T extends ExecNode<?>> ExecNodeContext newContext(Class<T> execNodeClass) {
        ExecNodeMetadata metadata = ExecNodeMetadataUtil.latestAnnotation(execNodeClass);
        if (metadata == null) {
            if (!ExecNodeMetadataUtil.isUnsupported(execNodeClass)) {
                throw new IllegalStateException(String.format("ExecNode: %s is not listed in the unsupported classes since it is not annotated with: %s.", execNodeClass.getCanonicalName(), ExecNodeMetadata.class.getSimpleName()));
            }
            return new ExecNodeContext();
        }
        if (!ExecNodeMetadataUtil.execNodes().contains(execNodeClass)) {
            throw new IllegalStateException(String.format("ExecNode: %s is not listed in the supported classes and yet is annotated with: %s.", execNodeClass.getCanonicalName(), ExecNodeMetadata.class.getSimpleName()));
        }
        return new ExecNodeContext(metadata.name(), metadata.version());
    }

    public static <T extends ExecNode<?>> ReadableConfig newPersistedConfig(Class<T> execNodeClass, ReadableConfig tableConfig) {
        return ExecNodeMetadataUtil.newPersistedConfig(execNodeClass, tableConfig, Stream.concat(ExecNodeMetadataUtil.TABLE_CONFIG_OPTIONS.stream(), ExecNodeMetadataUtil.EXECUTION_CONFIG_OPTIONS.stream()));
    }
}

