/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;

@BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
public class ApiMessageOperationTransformers {
    private ApiMessageOperationTransformers() {
    }

    private static <T extends ApiMessage> T transformEntityFromOperationSnapshot(OperationSnapshot operationSnapshot, Class<T> clazz, Object operationEntity, String entityName) {
        if (!clazz.isAssignableFrom(operationEntity.getClass())) {
            throw ApiExceptionFactory.createException(new Throwable(String.format("Operation with name \"%s\" succeeded, but its %s type %s cannot be cast to %s.", operationSnapshot.getName(), entityName, operationEntity.getClass().getCanonicalName(), clazz.getCanonicalName())), operationSnapshot.getErrorCode(), false);
        }
        ApiMessage typedEntity = (ApiMessage)operationEntity;
        return (T)typedEntity;
    }

    public static class MetadataTransformer<MetadataT extends ApiMessage>
    implements ApiFunction<OperationSnapshot, MetadataT> {
        private final Class<MetadataT> metadataTClass;

        private MetadataTransformer(Class<MetadataT> metadataTClass) {
            this.metadataTClass = metadataTClass;
        }

        @Override
        public MetadataT apply(OperationSnapshot operationSnapshot) {
            return (MetadataT)ApiMessageOperationTransformers.transformEntityFromOperationSnapshot(operationSnapshot, this.metadataTClass, operationSnapshot.getMetadata(), "metadata");
        }

        public static <MetadataT extends ApiMessage> MetadataTransformer<MetadataT> create(Class<MetadataT> packedClass) {
            return new MetadataTransformer<MetadataT>(packedClass);
        }
    }

    public static class ResponseTransformer<ResponseT extends ApiMessage>
    implements ApiFunction<OperationSnapshot, ResponseT> {
        private final Class<ResponseT> responseTClass;

        private ResponseTransformer(Class<ResponseT> responseTClass) {
            this.responseTClass = responseTClass;
        }

        @Override
        public ResponseT apply(OperationSnapshot operationSnapshot) {
            if (!operationSnapshot.getErrorCode().getCode().equals((Object)StatusCode.Code.OK)) {
                throw ApiExceptionFactory.createException(String.format("Operation with name \"%s\" failed with status = %s and message = %s", operationSnapshot.getName(), operationSnapshot.getErrorCode(), operationSnapshot.getErrorMessage()), null, operationSnapshot.getErrorCode(), false);
            }
            return (ResponseT)ApiMessageOperationTransformers.transformEntityFromOperationSnapshot(operationSnapshot, this.responseTClass, operationSnapshot.getResponse(), "response");
        }

        public static <ResponseT extends ApiMessage> ResponseTransformer<ResponseT> create(Class<ResponseT> packedClass) {
            return new ResponseTransformer<ResponseT>(packedClass);
        }
    }
}

