/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class FsBenchmark
extends Configured
implements Tool {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run(new FsBenchmark(), args);
        System.exit(result);
    }

    private FsBenchmark() {
        super(new Configuration());
    }

    @Override
    public int run(String[] args) throws IOException {
        String cmd = args[0];
        Map cmdArgs = ImmutableList.copyOf(args).subList(1, args.length).stream().collect(Collectors.toMap(arg -> arg.split("=")[0], arg -> arg.contains("=") ? arg.split("=")[1] : "", (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, HashMap::new));
        URI testUri = new Path((String)cmdArgs.getOrDefault("--file", cmdArgs.get("--bucket"))).toUri();
        FileSystem fs = FileSystem.get(testUri, this.getConf());
        int res = 0;
        try {
            res = this.runWithInstrumentation(fs, cmd, cmdArgs);
        }
        catch (Throwable e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Failed to execute '%s' command with arguments: %s", (Object)cmd, (Object)cmdArgs);
        }
        System.out.println(res == 0 ? "Success!" : "Failure!");
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runWithInstrumentation(FileSystem fs, String cmd, Map<String, String> cmdArgs) {
        int n;
        FileSystem.Statistics statistics = FileSystem.getStatistics().get(fs.getScheme());
        Optional<Object> progressReporter = Optional.empty();
        Future<Object> statsFuture = Futures.immediateVoidFuture();
        if (cmdArgs.containsKey("--verbose")) {
            progressReporter = Optional.of(Executors.newSingleThreadScheduledExecutor());
            statsFuture = ((ScheduledExecutorService)progressReporter.get()).scheduleWithFixedDelay(() -> System.out.printf("Progress stats: %s%n", statistics), Long.parseLong(cmdArgs.getOrDefault("--verbose-delay-seconds", "5")), Long.parseLong(cmdArgs.getOrDefault("--verbose-interval-seconds", "15")), TimeUnit.SECONDS);
        }
        try {
            n = this.runInternal(fs, cmd, cmdArgs);
            statsFuture.cancel(true);
        }
        catch (Throwable throwable) {
            statsFuture.cancel(true);
            progressReporter.ifPresent(ExecutorService::shutdownNow);
            System.out.printf("Final stats: %s%n", statistics);
            throw throwable;
        }
        progressReporter.ifPresent(ExecutorService::shutdownNow);
        System.out.printf("Final stats: %s%n", statistics);
        return n;
    }

    private int runInternal(FileSystem fs, String cmd, Map<String, String> cmdArgs) {
        switch (cmd) {
            case "read": {
                return this.benchmarkRead(fs, cmdArgs);
            }
            case "random-read": {
                return this.benchmarkRandomRead(fs, cmdArgs);
            }
        }
        throw new IllegalArgumentException("Unknown command: " + cmd);
    }

    private int benchmarkRead(FileSystem fs, Map<String, String> args) {
        if (args.size() < 1) {
            System.err.println("Usage: read --file=gs://${BUCKET}/path/to/test/object [--read-size=<read buffer size in bytes>] [--num-reads=<number of times to fully read test file>] [--num-threads=<number of threads to run test>]");
            return 1;
        }
        Path testFile = new Path(args.get("--file"));
        FsBenchmark.warmup(args, () -> this.benchmarkRead(fs, testFile, 1024, 1, 2));
        this.benchmarkRead(fs, testFile, Integer.parseInt(args.getOrDefault("--read-size", String.valueOf(1024))), Integer.parseInt(args.getOrDefault("--num-reads", String.valueOf(1))), Integer.parseInt(args.getOrDefault("--num-threads", String.valueOf(1))));
        return 0;
    }

    private void benchmarkRead(FileSystem fs, Path testFile, int readSize, int numReads, int numThreads) {
        System.out.printf("Running read test using %d bytes reads to fully read '%s' file %d times in %d threads%n", readSize, testFile, numReads, numThreads);
        Set<LongSummaryStatistics> readFileBytesList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readFileTimeNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readCallBytesList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readCallTimeNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        CountDownLatch initLatch = new CountDownLatch(numThreads);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(numThreads);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            futures.add(executor.submit(() -> {
                LongSummaryStatistics readFileBytes = FsBenchmark.newLongSummaryStatistics(readFileBytesList);
                LongSummaryStatistics readFileTimeNs = FsBenchmark.newLongSummaryStatistics(readFileTimeNsList);
                LongSummaryStatistics readCallBytes = FsBenchmark.newLongSummaryStatistics(readCallBytesList);
                LongSummaryStatistics readCallTimeNs = FsBenchmark.newLongSummaryStatistics(readCallTimeNsList);
                byte[] readBuffer = new byte[readSize];
                initLatch.countDown();
                startLatch.await();
                try {
                    for (int j = 0; j < numReads; ++j) {
                        try (FSDataInputStream input = fs.open(testFile);){
                            int bytesRead;
                            long readStart = System.nanoTime();
                            long fileBytesRead = 0L;
                            do {
                                long readCallStart = System.nanoTime();
                                bytesRead = input.read(readBuffer);
                                if (bytesRead > 0) {
                                    fileBytesRead += (long)bytesRead;
                                    readCallBytes.accept(bytesRead);
                                }
                                readCallTimeNs.accept(System.nanoTime() - readCallStart);
                            } while (bytesRead >= 0);
                            readFileBytes.accept(fileBytesRead);
                            readFileTimeNs.accept(System.nanoTime() - readStart);
                            continue;
                        }
                    }
                }
                finally {
                    stopLatch.countDown();
                }
                return null;
            }));
        }
        executor.shutdown();
        FsBenchmark.awaitUnchecked(initLatch);
        long startTimeNs = System.nanoTime();
        startLatch.countDown();
        FsBenchmark.awaitUnchecked(stopLatch);
        long runtimeNs = System.nanoTime() - startTimeNs;
        futures.forEach(Futures::getUnchecked);
        FsBenchmark.printTimeStats("Read call time", readCallTimeNsList);
        FsBenchmark.printSizeStats("Read call data", readCallBytesList);
        FsBenchmark.printThroughputStats("Read call throughput", readCallTimeNsList, readCallBytesList);
        FsBenchmark.printTimeStats("Read file time", readFileTimeNsList);
        FsBenchmark.printSizeStats("Read file data", readFileBytesList);
        FsBenchmark.printThroughputStats("Read file throughput", readFileTimeNsList, readFileBytesList);
        System.out.printf("Read average throughput (MiB/s): %.3f%n", FsBenchmark.bytesToMebibytes(FsBenchmark.combineStats(readFileBytesList).getSum()) / FsBenchmark.nanosToSeconds(runtimeNs));
    }

    private int benchmarkRandomRead(FileSystem fs, Map<String, String> args) {
        if (args.size() < 1) {
            System.err.println("Usage: random-read --file=gs://${BUCKET}/path/to/test/object [--num-open=<number of file open>] [--read-size=<read buffer size in bytes>] [--num-reads=<number of random reads per file open>] [--num-threads=<number of threads to run test>]");
            return 1;
        }
        Path testFile = new Path(args.get("--file"));
        FsBenchmark.warmup(args, () -> this.benchmarkRandomRead(fs, testFile, 5, 1024, 20, 5));
        this.benchmarkRandomRead(fs, testFile, Integer.parseInt(args.getOrDefault("--num-open", String.valueOf(1))), Integer.parseInt(args.getOrDefault("--read-size", String.valueOf(1024))), Integer.parseInt(args.getOrDefault("--num-reads", String.valueOf(100))), Integer.parseInt(args.getOrDefault("--num-threads", String.valueOf(1))));
        return 0;
    }

    private void benchmarkRandomRead(FileSystem fs, Path testFile, int numOpen, int readSize, int numReads, int numThreads) {
        System.out.printf("Running random read test that reads %d bytes from '%s' file %d times per %d open operations in %d threads%n", readSize, testFile, numReads, numOpen, numThreads);
        Set<LongSummaryStatistics> openLatencyNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> seekLatencyNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readLatencyNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> closeLatencyNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        CountDownLatch initLatch = new CountDownLatch(numThreads);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(numThreads);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            futures.add(executor.submit(() -> {
                FileStatus fileStatus = fs.getFileStatus(testFile);
                long fileSize = fileStatus.getLen();
                long maxReadPositionExclusive = fileSize - (long)readSize + 1L;
                LongSummaryStatistics openLatencyNs = FsBenchmark.newLongSummaryStatistics(openLatencyNsList);
                LongSummaryStatistics seekLatencyNs = FsBenchmark.newLongSummaryStatistics(seekLatencyNsList);
                LongSummaryStatistics readLatencyNs = FsBenchmark.newLongSummaryStatistics(readLatencyNsList);
                LongSummaryStatistics closeLatencyNs = FsBenchmark.newLongSummaryStatistics(closeLatencyNsList);
                ThreadLocalRandom random = ThreadLocalRandom.current();
                byte[] readBuffer = new byte[readSize];
                initLatch.countDown();
                startLatch.await();
                try {
                    for (int j = 0; j < numOpen; ++j) {
                        try {
                            long seekPos = random.nextLong(maxReadPositionExclusive);
                            long openStart = System.nanoTime();
                            FSDataInputStream input = fs.open(testFile);
                            openLatencyNs.accept(System.nanoTime() - openStart);
                            try {
                                for (int k = 0; k < numReads; ++k) {
                                    long seekStart = System.nanoTime();
                                    input.seek(seekPos);
                                    seekLatencyNs.accept(System.nanoTime() - seekStart);
                                    long readStart = System.nanoTime();
                                    int numRead = input.read(readBuffer);
                                    readLatencyNs.accept(System.nanoTime() - readStart);
                                    if (numRead == readSize) continue;
                                    System.err.printf("Read %d bytes from %d bytes at offset %d!%n", numRead, readSize, seekPos);
                                }
                                continue;
                            }
                            finally {
                                long closeStart = System.nanoTime();
                                input.close();
                                closeLatencyNs.accept(System.nanoTime() - closeStart);
                            }
                        }
                        catch (Throwable e) {
                            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Failed random read from '%s'", testFile);
                        }
                    }
                }
                finally {
                    stopLatch.countDown();
                }
                return null;
            }));
        }
        executor.shutdown();
        FsBenchmark.awaitUnchecked(initLatch);
        long startTime = System.nanoTime();
        startLatch.countDown();
        FsBenchmark.awaitUnchecked(stopLatch);
        double runtimeSeconds = FsBenchmark.nanosToSeconds(System.nanoTime() - startTime);
        long operations = FsBenchmark.combineStats(readLatencyNsList).getCount();
        futures.forEach(Futures::getUnchecked);
        FsBenchmark.printTimeStats("Open latency ", FsBenchmark.combineStats(openLatencyNsList));
        FsBenchmark.printTimeStats("Seek latency ", FsBenchmark.combineStats(seekLatencyNsList));
        FsBenchmark.printTimeStats("Read latency ", FsBenchmark.combineStats(readLatencyNsList));
        FsBenchmark.printTimeStats("Close latency", FsBenchmark.combineStats(closeLatencyNsList));
        System.out.printf("Average QPS: %.3f (%d in total %.3fs)%n", (double)operations / runtimeSeconds, operations, runtimeSeconds);
    }

    private static void warmup(Map<String, String> args, Runnable warmupFn) {
        if (args.containsKey("--no-warmup")) {
            System.out.println("=== Skipping warmup ===");
            return;
        }
        System.out.println("=== Running warmup ===");
        ExecutorService warmupExecutor = Executors.newSingleThreadExecutor();
        try {
            warmupExecutor.submit(warmupFn).get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("Benchmark warmup failed", e);
        }
        finally {
            warmupExecutor.shutdownNow();
        }
        System.out.println("=== Finished warmup ===\n");
    }

    private static LongSummaryStatistics newLongSummaryStatistics(Collection<LongSummaryStatistics> openLatencyNsList) {
        LongSummaryStatistics openLatencyNs = new LongSummaryStatistics();
        openLatencyNsList.add(openLatencyNs);
        return openLatencyNs;
    }

    private static void awaitUnchecked(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("CountDownLatch.await interrupted", e);
        }
    }

    private static void printTimeStats(String name, Collection<LongSummaryStatistics> timeStats) {
        FsBenchmark.printTimeStats(name, FsBenchmark.combineStats(timeStats));
    }

    private static void printTimeStats(String name, LongSummaryStatistics timeStats) {
        System.out.printf("%s (ms): min=%.5f, average=%.5f, max=%.5f (count=%d)%n", name, FsBenchmark.nanosToMillis(timeStats.getMin()), FsBenchmark.nanosToMillis(timeStats.getAverage()), FsBenchmark.nanosToMillis(timeStats.getMax()), timeStats.getCount());
    }

    private static void printSizeStats(String name, Collection<LongSummaryStatistics> sizeStats) {
        FsBenchmark.printSizeStats(name, FsBenchmark.combineStats(sizeStats));
    }

    private static void printSizeStats(String name, LongSummaryStatistics sizeStats) {
        System.out.printf("%s (MiB): min=%.5f, average=%.5f, max=%.5f (count=%d)%n", name, FsBenchmark.bytesToMebibytes(sizeStats.getMin()), FsBenchmark.bytesToMebibytes(sizeStats.getAverage()), FsBenchmark.bytesToMebibytes(sizeStats.getMax()), sizeStats.getCount());
    }

    private static void printThroughputStats(String name, Collection<LongSummaryStatistics> timeStats, Collection<LongSummaryStatistics> sizeStats) {
        FsBenchmark.printThroughputStats(name, FsBenchmark.combineStats(timeStats), FsBenchmark.combineStats(sizeStats).getAverage());
    }

    private static void printThroughputStats(String name, LongSummaryStatistics timeStats, double bytesProcessed) {
        System.out.printf("%s (MiB/s): min=%.3f, average=%.3f, max=%.3f (count=%d)%n", name, FsBenchmark.bytesToMebibytes(bytesProcessed) / FsBenchmark.nanosToSeconds(timeStats.getMax()), FsBenchmark.bytesToMebibytes(bytesProcessed) / FsBenchmark.nanosToSeconds(timeStats.getAverage()), FsBenchmark.bytesToMebibytes(bytesProcessed) / FsBenchmark.nanosToSeconds(timeStats.getMin()), timeStats.getCount());
    }

    private static LongSummaryStatistics combineStats(Collection<LongSummaryStatistics> stats) {
        return stats.stream().collect(LongSummaryStatistics::new, LongSummaryStatistics::combine, LongSummaryStatistics::combine);
    }

    private static double nanosToMillis(double nanos) {
        return nanos / 1000000.0;
    }

    private static double nanosToSeconds(double nanos) {
        return nanos / 1.0E9;
    }

    private static double bytesToMebibytes(double bytes) {
        return bytes / 1024.0 / 1024.0;
    }
}

