/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RetryHttpInitializer
implements HttpRequestInitializer {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final int HTTP_SC_TOO_MANY_REQUESTS = 429;
    private static final HttpBackOffUnsuccessfulResponseHandler.BackOffRequired BASE_HTTP_BACKOFF_REQUIRED = HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ON_SERVER_ERROR;
    private final Credential credential;
    private final RetryHttpInitializerOptions options;
    private Sleeper sleeperOverride;

    public RetryHttpInitializer(Credential credential, String defaultUserAgent) {
        this(credential, RetryHttpInitializerOptions.DEFAULT.toBuilder().setDefaultUserAgent(defaultUserAgent).build());
    }

    public RetryHttpInitializer(Credential credential, RetryHttpInitializerOptions options) {
        this.credential = credential;
        this.options = options;
        this.sleeperOverride = null;
    }

    @Override
    public void initialize(HttpRequest request) {
        request.setInterceptor(this.credential);
        request.setNumberOfRetries(this.options.getMaxRequestRetries());
        request.setConnectTimeout(Math.toIntExact(this.options.getConnectTimeout().toMillis()));
        request.setReadTimeout(Math.toIntExact(this.options.getReadTimeout().toMillis()));
        HttpBackOffIOExceptionHandler exceptionHandler = new HttpBackOffIOExceptionHandler(RetryHttpInitializer.getDefaultBackOff());
        if (this.sleeperOverride != null) {
            exceptionHandler.setSleeper(this.sleeperOverride);
        }
        LoggingResponseHandler loggingResponseHandler = new LoggingResponseHandler(new CredentialOrBackoffResponseHandler(), exceptionHandler, ImmutableSet.of(Integer.valueOf(410), Integer.valueOf(503)), ImmutableSet.of(Integer.valueOf(429)));
        request.setUnsuccessfulResponseHandler(loggingResponseHandler);
        request.setIOExceptionHandler(loggingResponseHandler);
        if (Strings.isNullOrEmpty(request.getHeaders().getUserAgent()) && !Strings.isNullOrEmpty(this.options.getDefaultUserAgent())) {
            ((GoogleLogger.Api)logger.atFiner()).log("Request is missing a user-agent, adding default value of '%s'", this.options.getDefaultUserAgent());
            request.getHeaders().setUserAgent(this.options.getDefaultUserAgent());
        }
        request.getHeaders().putAll((Map<? extends String, ?>)this.options.getHttpHeaders());
    }

    public Credential getCredential() {
        return this.credential;
    }

    private static BackOff getDefaultBackOff() {
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(1250).setMultiplier(1.6).setRandomizationFactor(0.2).setMaxIntervalMillis(20000).setMaxElapsedTimeMillis(1800000).build();
    }

    @VisibleForTesting
    void setSleeperOverride(Sleeper sleeper) {
        this.sleeperOverride = sleeper;
    }

    private class CredentialOrBackoffResponseHandler
    implements HttpUnsuccessfulResponseHandler {
        private final HttpUnsuccessfulResponseHandler delegateHandler;

        public CredentialOrBackoffResponseHandler() {
            HttpBackOffUnsuccessfulResponseHandler errorCodeHandler = new HttpBackOffUnsuccessfulResponseHandler(RetryHttpInitializer.getDefaultBackOff());
            errorCodeHandler.setBackOffRequired(response -> BASE_HTTP_BACKOFF_REQUIRED.isRequired(response) || response.getStatusCode() == 429);
            if (RetryHttpInitializer.this.sleeperOverride != null) {
                errorCodeHandler.setSleeper(RetryHttpInitializer.this.sleeperOverride);
            }
            this.delegateHandler = errorCodeHandler;
        }

        @Override
        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
            String redirectLocation;
            if (RetryHttpInitializer.this.credential != null && RetryHttpInitializer.this.credential.handleResponse(request, response, supportsRetry)) {
                return true;
            }
            if (this.delegateHandler.handleResponse(request, response, supportsRetry)) {
                return true;
            }
            if (HttpStatusCodes.isRedirect(response.getStatusCode()) && request.getFollowRedirects() && response.getHeaders() != null && response.getHeaders().getLocation() != null && (redirectLocation = response.getHeaders().getLocation()).contains("+")) {
                String escapedLocation = redirectLocation.replace("+", "%2B");
                ((GoogleLogger.Api)logger.atFine()).log("Redirect path '%s' contains unescaped '+', replacing with '%%2B': '%s'", (Object)redirectLocation, (Object)escapedLocation);
                response.getHeaders().setLocation(escapedLocation);
            }
            return false;
        }
    }

    private static class LoggingResponseHandler
    implements HttpUnsuccessfulResponseHandler,
    HttpIOExceptionHandler {
        private static final String LOG_MESSAGE_FORMAT = "Encountered status code %d when sending %s request to URL '%s'. Delegating to response handler for possible retry.";
        private final HttpUnsuccessfulResponseHandler delegateResponseHandler;
        private final HttpIOExceptionHandler delegateIOExceptionHandler;
        private final ImmutableSet<Integer> responseCodesToLog;
        private final ImmutableSet<Integer> responseCodesToLogWithRateLimit;

        public LoggingResponseHandler(HttpUnsuccessfulResponseHandler delegateResponseHandler, HttpIOExceptionHandler delegateIOExceptionHandler, Set<Integer> responseCodesToLog, Set<Integer> responseCodesToLogWithRateLimit) {
            this.delegateResponseHandler = delegateResponseHandler;
            this.delegateIOExceptionHandler = delegateIOExceptionHandler;
            this.responseCodesToLog = ImmutableSet.copyOf(responseCodesToLog);
            this.responseCodesToLogWithRateLimit = ImmutableSet.copyOf(responseCodesToLogWithRateLimit);
        }

        @Override
        public boolean handleResponse(HttpRequest httpRequest, HttpResponse httpResponse, boolean supportsRetry) throws IOException {
            if (this.responseCodesToLogWithRateLimit.contains(httpResponse.getStatusCode())) {
                switch (httpResponse.getStatusCode()) {
                    case 429: {
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).atMostEvery(10, TimeUnit.SECONDS)).log(LOG_MESSAGE_FORMAT, httpResponse.getStatusCode(), httpRequest.getRequestMethod(), httpRequest.getUrl());
                        break;
                    }
                    default: {
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).atMostEvery(10, TimeUnit.SECONDS)).log("Encountered status code %d (and maybe others) when sending %s request to URL '%s'. Delegating to response handler for possible retry.", httpResponse.getStatusCode(), httpRequest.getRequestMethod(), httpRequest.getUrl());
                        break;
                    }
                }
            } else if (this.responseCodesToLog.contains(httpResponse.getStatusCode())) {
                ((GoogleLogger.Api)logger.atInfo()).log(LOG_MESSAGE_FORMAT, httpResponse.getStatusCode(), httpRequest.getRequestMethod(), httpRequest.getUrl());
            }
            return this.delegateResponseHandler.handleResponse(httpRequest, httpResponse, supportsRetry);
        }

        @Override
        public boolean handleIOException(HttpRequest httpRequest, boolean supportsRetry) throws IOException {
            ((GoogleLogger.Api)logger.atFine()).log("Encountered an IOException when accessing URL %s", httpRequest.getUrl());
            return this.delegateIOExceptionHandler.handleIOException(httpRequest, supportsRetry);
        }
    }
}

