/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.BaseWriteChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.RetryHelper;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

class BlobWriteChannel
extends BaseWriteChannel<StorageOptions, BlobInfo> {
    private final ResultRetryAlgorithm<?> algorithmForWrite;
    private boolean retrying = false;
    private boolean checkingForLastChunk = false;
    private StorageObject storageObject;

    BlobWriteChannel(StorageOptions storageOptions, BlobInfo blobInfo, String uploadId, ResultRetryAlgorithm<?> algorithmForWrite) {
        super(storageOptions, blobInfo, uploadId);
        this.algorithmForWrite = algorithmForWrite;
    }

    boolean isRetrying() {
        return this.retrying;
    }

    StorageObject getStorageObject() {
        return this.storageObject;
    }

    private StorageObject transmitChunk(int chunkOffset, int chunkLength, long position, boolean last) {
        return ((StorageOptions)this.getOptions()).getStorageRpcV1().writeWithResponse(this.getUploadId(), this.getBuffer(), chunkOffset, position, chunkLength, last);
    }

    private long getRemotePosition() {
        return ((StorageOptions)this.getOptions()).getStorageRpcV1().getCurrentUploadOffset(this.getUploadId());
    }

    private static StorageException unrecoverableState(String uploadId, int chunkOffset, int chunkLength, long localPosition, long remotePosition, boolean last) {
        return BlobWriteChannel.unrecoverableState(uploadId, chunkOffset, chunkLength, localPosition, remotePosition, last, "Unable to recover in upload.\nThis may be a symptom of multiple clients uploading to the same upload session.");
    }

    private static StorageException errorResolvingMetadataLastChunk(String uploadId, int chunkOffset, int chunkLength, long localPosition, long remotePosition, boolean last) {
        return BlobWriteChannel.unrecoverableState(uploadId, chunkOffset, chunkLength, localPosition, remotePosition, last, "Unable to load object metadata to determine if last chunk was successfully written");
    }

    private static StorageException unrecoverableState(String uploadId, int chunkOffset, int chunkLength, long localPosition, long remotePosition, boolean last, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(message).append("\n\n");
        sb.append("For debugging purposes:\n");
        sb.append("uploadId: ").append(uploadId).append('\n');
        sb.append("chunkOffset: ").append(chunkOffset).append('\n');
        sb.append("chunkLength: ").append(chunkLength).append('\n');
        sb.append("localOffset: ").append(localPosition).append('\n');
        sb.append("remoteOffset: ").append(remotePosition).append('\n');
        sb.append("lastChunk: ").append(last).append("\n\n");
        return new StorageException(0, sb.toString());
    }

    @Override
    protected void flushBuffer(final int length, final boolean lastChunk) {
        try {
            RetryHelper.runWithRetries(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    boolean uploadAlreadyComplete;
                    long localPosition = BlobWriteChannel.this.getPosition();
                    long remotePosition = BlobWriteChannel.this.isRetrying() ? BlobWriteChannel.this.getRemotePosition() : localPosition;
                    int chunkOffset = (int)(remotePosition - localPosition);
                    int chunkLength = length - chunkOffset;
                    boolean bl = uploadAlreadyComplete = remotePosition == -1L;
                    if (!BlobWriteChannel.this.isRetrying()) {
                        BlobWriteChannel.this.retrying = true;
                    }
                    if (uploadAlreadyComplete && lastChunk) {
                        long totalBytes = BlobWriteChannel.this.getPosition() + (long)length;
                        if (BlobWriteChannel.this.storageObject == null) {
                            BlobWriteChannel.this.storageObject = ((StorageOptions)BlobWriteChannel.this.getOptions()).getStorageRpcV1().queryCompletedResumableUpload(BlobWriteChannel.this.getUploadId(), totalBytes);
                        }
                        if (BlobWriteChannel.this.storageObject == null) {
                            throw BlobWriteChannel.errorResolvingMetadataLastChunk(BlobWriteChannel.this.getUploadId(), chunkOffset, chunkLength, localPosition, remotePosition, lastChunk);
                        }
                        BigInteger size = BlobWriteChannel.this.storageObject.getSize();
                        if (size == null) {
                            throw BlobWriteChannel.errorResolvingMetadataLastChunk(BlobWriteChannel.this.getUploadId(), chunkOffset, chunkLength, localPosition, remotePosition, lastChunk);
                        }
                        if (size.longValue() != totalBytes) {
                            throw BlobWriteChannel.unrecoverableState(BlobWriteChannel.this.getUploadId(), chunkOffset, chunkLength, localPosition, remotePosition, lastChunk);
                        }
                        BlobWriteChannel.this.retrying = false;
                    } else if (uploadAlreadyComplete && !lastChunk && !BlobWriteChannel.this.checkingForLastChunk) {
                        BlobWriteChannel.this.checkingForLastChunk = true;
                    } else if (localPosition <= remotePosition && chunkOffset < BlobWriteChannel.this.getChunkSize()) {
                        BlobWriteChannel.this.storageObject = BlobWriteChannel.this.transmitChunk(chunkOffset, chunkLength, remotePosition, lastChunk);
                        BlobWriteChannel.this.retrying = false;
                    } else if (localPosition < remotePosition && chunkOffset == BlobWriteChannel.this.getChunkSize()) {
                        BlobWriteChannel.this.retrying = false;
                    } else {
                        throw BlobWriteChannel.unrecoverableState(BlobWriteChannel.this.getUploadId(), chunkOffset, chunkLength, localPosition, remotePosition, lastChunk);
                    }
                }
            }), ((StorageOptions)this.getOptions()).getRetrySettings(), this.algorithmForWrite, ((StorageOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    protected StateImpl.Builder stateBuilder() {
        return StateImpl.builder((StorageOptions)this.getOptions(), (BlobInfo)this.getEntity(), this.getUploadId()).setResultRetryAlgorithm(this.algorithmForWrite);
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static class StateImpl
    extends BaseWriteChannel.BaseState<StorageOptions, BlobInfo> {
        private static final long serialVersionUID = -9028324143780151286L;
        private final ResultRetryAlgorithm<?> algorithmForWrite;

        StateImpl(Builder builder) {
            super(builder);
            this.algorithmForWrite = builder.algorithmForWrite;
        }

        static Builder builder(StorageOptions options, BlobInfo blobInfo, String uploadId) {
            return new Builder(options, blobInfo, uploadId);
        }

        @Override
        public WriteChannel restore() {
            try {
                BlobWriteChannel channel = BlobWriteChannel.newBuilder().setStorageOptions((StorageOptions)this.serviceOptions).setBlobInfo((BlobInfo)this.entity).setUploadIdSupplier(() -> this.uploadId).setAlgorithmForWrite(this.algorithmForWrite).build();
                channel.restore(this);
                return channel;
            }
            catch (Exception e) {
                throw StorageException.coalesce(e);
            }
        }

        static class Builder
        extends BaseWriteChannel.BaseState.Builder<StorageOptions, BlobInfo> {
            private ResultRetryAlgorithm<?> algorithmForWrite;

            private Builder(StorageOptions options, BlobInfo blobInfo, String uploadId) {
                super(options, blobInfo, uploadId);
            }

            public Builder setResultRetryAlgorithm(ResultRetryAlgorithm<?> algorithmForWrite) {
                this.algorithmForWrite = algorithmForWrite;
                return this;
            }

            @Override
            public RestorableState<WriteChannel> build() {
                return new StateImpl(this);
            }
        }
    }

    static final class Builder {
        private StorageOptions storageOptions;
        private BlobInfo blobInfo;
        private Supplier<@NonNull String> uploadIdSupplier;
        private ResultRetryAlgorithm<?> algorithmForWrite;

        Builder() {
        }

        public Builder setStorageOptions(StorageOptions storageOptions) {
            this.storageOptions = storageOptions;
            return this;
        }

        public Builder setBlobInfo(BlobInfo blobInfo) {
            this.blobInfo = blobInfo;
            return this;
        }

        public Builder setUploadIdSupplier(Supplier<String> uploadIdSupplier) {
            this.uploadIdSupplier = uploadIdSupplier;
            return this;
        }

        public Builder setAlgorithmForWrite(ResultRetryAlgorithm<?> algorithmForWrite) {
            this.algorithmForWrite = algorithmForWrite;
            return this;
        }

        BlobWriteChannel build() {
            String uploadId = Objects.requireNonNull(this.uploadIdSupplier, "uploadId must be non null").get();
            return new BlobWriteChannel(Objects.requireNonNull(this.storageOptions, "storageOptions must be non null"), this.blobInfo, Objects.requireNonNull(uploadId, "uploadId must be non null"), Objects.requireNonNull(this.algorithmForWrite, "algorithmForWrite must be non null"));
        }
    }
}

