/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine.generator;

import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.examples.statemachine.event.Event;
import org.apache.flink.streaming.examples.statemachine.generator.EventsGenerator;
import org.apache.flink.util.Preconditions;

public class EventsGeneratorSource
extends RichParallelSourceFunction<Event> {
    private final double errorProbability;
    private final int delayPerRecordMillis;
    private volatile boolean running = true;

    public EventsGeneratorSource(double errorProbability, int delayPerRecordMillis) {
        Preconditions.checkArgument((errorProbability >= 0.0 && errorProbability <= 1.0 ? 1 : 0) != 0, (Object)"error probability must be in [0.0, 1.0]");
        Preconditions.checkArgument((delayPerRecordMillis >= 0 ? 1 : 0) != 0, (Object)"delay must be >= 0");
        this.errorProbability = errorProbability;
        this.delayPerRecordMillis = delayPerRecordMillis;
    }

    public void run(SourceFunction.SourceContext<Event> sourceContext) throws Exception {
        EventsGenerator generator = new EventsGenerator(this.errorProbability);
        int range = Integer.MAX_VALUE / this.getRuntimeContext().getNumberOfParallelSubtasks();
        int min = range * this.getRuntimeContext().getIndexOfThisSubtask();
        int max = min + range;
        while (this.running) {
            sourceContext.collect((Object)generator.next(min, max));
            if (this.delayPerRecordMillis <= 0) continue;
            Thread.sleep(this.delayPerRecordMillis);
        }
    }

    public void cancel() {
        this.running = false;
    }
}

