/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class EnterListDialog
extends Dialog {
    private static final Class<?> PKG = EnterListDialog.class;
    private final PropsUi props = PropsUi.getInstance();
    private final String[] input;
    private String[] returnValues;
    private final Hashtable<Integer, String> selection;
    private Shell shell;
    private List wListSource;
    private List wListDest;
    private boolean opened;

    public EnterListDialog(Shell parent, int style, String[] input) {
        super(parent, style);
        this.input = input;
        this.returnValues = null;
        this.selection = new Hashtable();
        this.opened = false;
    }

    public String[] open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImagePipeline());
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterListDialog.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)new FormLayout());
        int margin = this.props.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wCancel}, margin, null);
        Composite top = new Composite((Composite)this.shell, 0);
        FormLayout topLayout = new FormLayout();
        topLayout.marginHeight = margin;
        topLayout.marginWidth = margin;
        top.setLayout((Layout)topLayout);
        FormData fdTop = new FormData();
        fdTop.left = new FormAttachment(0, 0);
        fdTop.top = new FormAttachment(0, 0);
        fdTop.right = new FormAttachment(100, 0);
        fdTop.bottom = new FormAttachment((Control)wOk, -2 * margin);
        top.setLayoutData((Object)fdTop);
        this.props.setLook((Control)top);
        Composite bottom = new Composite((Composite)this.shell, 0);
        bottom.setLayout((Layout)new FormLayout());
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(0, 0);
        fdBottom.top = new FormAttachment((Control)top, 0);
        fdBottom.right = new FormAttachment(100, 0);
        fdBottom.bottom = new FormAttachment(100, 0);
        bottom.setLayoutData((Object)fdBottom);
        this.props.setLook((Control)bottom);
        SashForm sashform = new SashForm(top, 256);
        sashform.setLayout((Layout)new FormLayout());
        FormData fdSashform = new FormData();
        fdSashform.left = new FormAttachment(0, 0);
        fdSashform.top = new FormAttachment(0, 0);
        fdSashform.right = new FormAttachment(100, 0);
        fdSashform.bottom = new FormAttachment(100, 0);
        sashform.setLayoutData((Object)fdSashform);
        Composite leftsplit = new Composite((Composite)sashform, 0);
        leftsplit.setLayout((Layout)new FormLayout());
        FormData fdLeftsplit = new FormData();
        fdLeftsplit.left = new FormAttachment(0, 0);
        fdLeftsplit.top = new FormAttachment(0, 0);
        fdLeftsplit.right = new FormAttachment(100, 0);
        fdLeftsplit.bottom = new FormAttachment(100, 0);
        leftsplit.setLayoutData((Object)fdLeftsplit);
        this.props.setLook((Control)leftsplit);
        Label wlListSource = new Label(leftsplit, 0);
        wlListSource.setText(BaseMessages.getString(PKG, (String)"EnterListDialog.AvailableItems.Label", (String[])new String[0]));
        this.props.setLook((Control)wlListSource);
        FormData fdlListSource = new FormData();
        fdlListSource.left = new FormAttachment(0, 0);
        fdlListSource.top = new FormAttachment(0, 0);
        wlListSource.setLayoutData((Object)fdlListSource);
        this.wListSource = new List(leftsplit, 2818);
        this.props.setLook((Control)this.wListSource);
        FormData fdListSource = new FormData();
        fdListSource.left = new FormAttachment(0, 0);
        fdListSource.top = new FormAttachment((Control)wlListSource, 0);
        fdListSource.right = new FormAttachment(100, 0);
        fdListSource.bottom = new FormAttachment(100, 0);
        this.wListSource.setLayoutData((Object)fdListSource);
        this.wListSource.addListener(14, e -> this.addToSelection(this.wListSource.getSelection()));
        this.wListSource.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    EnterListDialog.this.addToSelection(EnterListDialog.this.wListSource.getSelection());
                }
            }
        });
        Composite compMiddle = new Composite((Composite)sashform, 0);
        compMiddle.setLayout((Layout)new FormLayout());
        FormData fdCompMiddle = new FormData();
        fdCompMiddle.left = new FormAttachment(0, 0);
        fdCompMiddle.top = new FormAttachment(0, 0);
        fdCompMiddle.right = new FormAttachment(100, 0);
        fdCompMiddle.bottom = new FormAttachment(100, 0);
        compMiddle.setLayoutData((Object)fdCompMiddle);
        this.props.setLook((Control)compMiddle);
        Composite gButtonGroup = new Composite(compMiddle, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gButtonGroup.setLayout((Layout)gridLayout);
        Button wAddOne = new Button(gButtonGroup, 8);
        wAddOne.setText(" > ");
        wAddOne.setToolTipText(BaseMessages.getString(PKG, (String)"EnterListDialog.AddOne.Tooltip", (String[])new String[0]));
        wAddOne.addListener(13, e -> this.addToSelection(this.wListSource.getSelection()));
        Button wAddAll = new Button(gButtonGroup, 8);
        wAddAll.setText(" >> ");
        wAddAll.setToolTipText(BaseMessages.getString(PKG, (String)"EnterListDialog.AddAll.Tooltip", (String[])new String[0]));
        wAddAll.addListener(13, e -> this.addToSelection(this.wListSource.getItems()));
        Button wRemoveOne = new Button(gButtonGroup, 8);
        wRemoveOne.setText(" < ");
        wRemoveOne.setToolTipText(BaseMessages.getString(PKG, (String)"EnterListDialog.RemoveOne.Tooltip", (String[])new String[0]));
        wRemoveOne.addListener(13, e -> this.delFromSelection(this.wListDest.getSelection()));
        Button wRemoveAll = new Button(gButtonGroup, 8);
        wRemoveAll.setText(" << ");
        wRemoveAll.setToolTipText(BaseMessages.getString(PKG, (String)"EnterListDialog.RemoveAll.Tooltip", (String[])new String[0]));
        wRemoveAll.addListener(13, e -> this.delFromSelection(this.wListDest.getItems()));
        GridData gdAddOne = new GridData(1808);
        wAddOne.setLayoutData((Object)gdAddOne);
        GridData gdAddAll = new GridData(1808);
        wAddAll.setLayoutData((Object)gdAddAll);
        GridData gdRemoveAll = new GridData(1808);
        wRemoveAll.setLayoutData((Object)gdRemoveAll);
        GridData gdRemoveOne = new GridData(1808);
        wRemoveOne.setLayoutData((Object)gdRemoveOne);
        FormData fdButtonGroup = new FormData();
        wAddAll.pack();
        fdButtonGroup.left = new FormAttachment(50, -(wAddAll.getSize().x / 2) - 5);
        fdButtonGroup.top = new FormAttachment(30, 0);
        gButtonGroup.setBackground(this.shell.getBackground());
        gButtonGroup.setLayoutData((Object)fdButtonGroup);
        Composite rightSplit = new Composite((Composite)sashform, 0);
        rightSplit.setLayout((Layout)new FormLayout());
        FormData fdRightSplit = new FormData();
        fdRightSplit.left = new FormAttachment(0, 0);
        fdRightSplit.top = new FormAttachment(0, 0);
        fdRightSplit.right = new FormAttachment(100, 0);
        fdRightSplit.bottom = new FormAttachment(100, 0);
        rightSplit.setLayoutData((Object)fdRightSplit);
        this.props.setLook((Control)rightSplit);
        Label wlListDest = new Label(rightSplit, 0);
        wlListDest.setText(BaseMessages.getString(PKG, (String)"EnterListDialog.Selection.Label", (String[])new String[0]));
        this.props.setLook((Control)wlListDest);
        FormData fdlListDest = new FormData();
        fdlListDest.left = new FormAttachment(0, 0);
        fdlListDest.top = new FormAttachment(0, 0);
        wlListDest.setLayoutData((Object)fdlListDest);
        this.wListDest = new List(rightSplit, 2818);
        this.props.setLook((Control)this.wListDest);
        FormData fdListDest = new FormData();
        fdListDest.left = new FormAttachment(0, 0);
        fdListDest.top = new FormAttachment((Control)wlListDest, 0);
        fdListDest.right = new FormAttachment(100, 0);
        fdListDest.bottom = new FormAttachment(100, 0);
        this.wListDest.setLayoutData((Object)fdListDest);
        this.wListDest.addListener(14, e -> this.delFromSelection(this.wListDest.getSelection()));
        this.wListDest.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    EnterListDialog.this.delFromSelection(EnterListDialog.this.wListDest.getSelection());
                }
            }
        });
        sashform.setWeights(new int[]{40, 16, 40});
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        DragSource ddSource = new DragSource((Control)this.wListSource, 3);
        ddSource.setTransfer(transfers);
        ddSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                String[] ti = EnterListDialog.this.wListSource.getSelection();
                StringBuilder data = new StringBuilder();
                for (String s : ti) {
                    data.append(s).append(Const.CR);
                }
                event.data = data.toString();
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget ddTarget = new DropTarget((Control)this.wListDest, 3);
        ddTarget.setTransfer(transfers);
        ddTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                StringTokenizer strtok = new StringTokenizer((String)event.data, Const.CR);
                while (strtok.hasMoreTokens()) {
                    String source = strtok.nextToken();
                    EnterListDialog.this.addToDestination(source);
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.shell.addListener(21, e -> this.cancel());
        this.opened = true;
        this.getData();
        BaseTransformDialog.setSize(this.shell);
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.returnValues;
    }

    public void getData() {
        if (!this.opened) {
            return;
        }
        this.wListSource.removeAll();
        this.wListDest.removeAll();
        for (int i = 0; i < this.input.length; ++i) {
            Integer idx = i;
            String str = this.selection.get(idx);
            if (str == null) {
                this.wListSource.add(this.input[i]);
                continue;
            }
            this.wListDest.add(this.input[i]);
        }
    }

    public void addToSelection(String[] string) {
        for (int i = 0; i < string.length; ++i) {
            this.addToDestination(string[i]);
        }
    }

    public void delFromSelection(String[] string) {
        for (int i = 0; i < string.length; ++i) {
            this.delFromDestination(string[i]);
        }
    }

    public void addToDestination(String string) {
        int idxInput = Const.indexOfString((String)string, (String[])this.input);
        this.selection.put(idxInput, string);
        this.getData();
    }

    public void delFromDestination(String string) {
        int idxInput = Const.indexOfString((String)string, (String[])this.input);
        this.selection.remove(idxInput);
        this.getData();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void ok() {
        this.returnValues = this.wListDest.getItems();
        this.dispose();
    }

    public void cancel() {
        this.returnValues = null;
        this.dispose();
    }
}

