/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.execution;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.plugin.ExecutionInfoLocationPluginType;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiCompositeWidgetsAdapter;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

@GuiPlugin(description="Editor for execution information location metadata")
public class ExecutionInfoLocationEditor
extends MetadataEditor<ExecutionInfoLocation> {
    private static final Class<?> PKG = ExecutionInfoLocationEditor.class;
    private ExecutionInfoLocation executionInfoLocation;
    private ExecutionInfoLocation workingLocation;
    private Text wName;
    private Text wDescription;
    private Text wDataLoggingDelay;
    private Text wDataLoggingInterval;
    private ComboVar wPluginType;
    private Composite wPluginSpecificComp;
    private GuiCompositeWidgets guiCompositeWidgets;
    private Map<String, IExecutionInfoLocation> metaMap;
    private final AtomicBoolean busyChangingPluginType = new AtomicBoolean(false);

    public ExecutionInfoLocationEditor(HopGui hopGui, MetadataManager<ExecutionInfoLocation> manager, ExecutionInfoLocation location) {
        super(hopGui, manager, location);
        this.executionInfoLocation = location;
        this.workingLocation = new ExecutionInfoLocation(location);
        this.metaMap = this.populateMetaMap();
        if (this.workingLocation.getExecutionInfoLocation() != null) {
            this.metaMap.put(this.workingLocation.getExecutionInfoLocation().getPluginName(), this.workingLocation.getExecutionInfoLocation());
        }
    }

    private Map<String, IExecutionInfoLocation> populateMetaMap() {
        this.metaMap = new HashMap<String, IExecutionInfoLocation>();
        List plugins = PluginRegistry.getInstance().getPlugins(ExecutionInfoLocationPluginType.class);
        for (IPlugin plugin : plugins) {
            try {
                IExecutionInfoLocation location = (IExecutionInfoLocation)PluginRegistry.getInstance().loadClass(plugin, IExecutionInfoLocation.class);
                location.setPluginId(plugin.getIds()[0]);
                location.setPluginName(plugin.getName());
                this.metaMap.put(plugin.getName(), location);
            }
            catch (Exception e) {
                HopGui.getInstance().getLog().logError("Error instantiating execution information location plugin", (Throwable)e);
            }
        }
        return this.metaMap;
    }

    @Override
    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = props.getMargin();
        ScrolledComposite wMainSComp = new ScrolledComposite(parent, 768);
        wMainSComp.setLayout((Layout)new FillLayout());
        Composite wMainComp = new Composite((Composite)wMainSComp, 0);
        props.setLook((Control)wMainComp);
        FormLayout mainLayout = new FormLayout();
        mainLayout.marginWidth = 3;
        mainLayout.marginHeight = 3;
        wMainComp.setLayout((Layout)mainLayout);
        Label wlName = new Label(wMainComp, 131072);
        props.setLook((Control)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"ExecutionInfoLocationEditor.label.name", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin * 2);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(wMainComp, 18436);
        props.setLook((Control)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Object lastControl = this.wName;
        Label wlDescription = new Label(wMainComp, 131072);
        props.setLook((Control)wlDescription);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"ExecutionInfoLocationEditor.label.description", (String[])new String[0]));
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(middle, 0);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(wMainComp, 18436);
        props.setLook((Control)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.top = new FormAttachment((Control)wlDescription, 0, 0x1000000);
        fdDescription.left = new FormAttachment(middle, margin);
        fdDescription.right = new FormAttachment(100, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        lastControl = this.wDescription;
        Label wlDataLoggingDelay = new Label(wMainComp, 131072);
        props.setLook((Control)wlDataLoggingDelay);
        wlDataLoggingDelay.setText(BaseMessages.getString(PKG, (String)"ExecutionInfoLocationEditor.label.DataLoggingDelay", (String[])new String[0]));
        FormData fdlDataLoggingDelay = new FormData();
        fdlDataLoggingDelay.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlDataLoggingDelay.left = new FormAttachment(0, 0);
        fdlDataLoggingDelay.right = new FormAttachment(middle, 0);
        wlDataLoggingDelay.setLayoutData((Object)fdlDataLoggingDelay);
        this.wDataLoggingDelay = new Text(wMainComp, 18436);
        props.setLook((Control)this.wDataLoggingDelay);
        FormData fdDataLoggingDelay = new FormData();
        fdDataLoggingDelay.top = new FormAttachment((Control)wlDataLoggingDelay, 0, 0x1000000);
        fdDataLoggingDelay.left = new FormAttachment(middle, margin);
        fdDataLoggingDelay.right = new FormAttachment(100, 0);
        this.wDataLoggingDelay.setLayoutData((Object)fdDataLoggingDelay);
        lastControl = this.wDataLoggingDelay;
        Label wlDataLoggingInterval = new Label(wMainComp, 131072);
        props.setLook((Control)wlDataLoggingInterval);
        wlDataLoggingInterval.setText(BaseMessages.getString(PKG, (String)"ExecutionInfoLocationEditor.label.DataLoggingInterval", (String[])new String[0]));
        FormData fdlDataLoggingInterval = new FormData();
        fdlDataLoggingInterval.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlDataLoggingInterval.left = new FormAttachment(0, 0);
        fdlDataLoggingInterval.right = new FormAttachment(middle, 0);
        wlDataLoggingInterval.setLayoutData((Object)fdlDataLoggingInterval);
        this.wDataLoggingInterval = new Text(wMainComp, 18436);
        props.setLook((Control)this.wDataLoggingInterval);
        FormData fdDataLoggingInterval = new FormData();
        fdDataLoggingInterval.top = new FormAttachment((Control)wlDataLoggingInterval, 0, 0x1000000);
        fdDataLoggingInterval.left = new FormAttachment(middle, margin);
        fdDataLoggingInterval.right = new FormAttachment(100, 0);
        this.wDataLoggingInterval.setLayoutData((Object)fdDataLoggingInterval);
        lastControl = this.wDataLoggingInterval;
        Label wlPluginType = new Label(wMainComp, 131072);
        props.setLook((Control)wlPluginType);
        wlPluginType.setText(BaseMessages.getString(PKG, (String)"ExecutionInfoLocationEditor.label.locationType", (String[])new String[0]));
        FormData fdlPluginType = new FormData();
        fdlPluginType.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlPluginType.left = new FormAttachment(0, 0);
        fdlPluginType.right = new FormAttachment(middle, 0);
        wlPluginType.setLayoutData((Object)fdlPluginType);
        this.wPluginType = new ComboVar(this.manager.getVariables(), wMainComp, 18436);
        props.setLook((Control)this.wPluginType);
        this.wPluginType.setItems(this.getPluginTypes());
        FormData fdPluginType = new FormData();
        fdPluginType.top = new FormAttachment((Control)wlPluginType, 0, 0x1000000);
        fdPluginType.left = new FormAttachment(middle, margin);
        fdPluginType.right = new FormAttachment(100, 0);
        this.wPluginType.setLayoutData(fdPluginType);
        lastControl = this.wPluginType;
        this.wPluginSpecificComp = new Composite(wMainComp, 8);
        props.setLook((Control)this.wPluginSpecificComp);
        this.wPluginSpecificComp.setLayout((Layout)new FormLayout());
        FormData fdPluginSpecificComp = new FormData();
        fdPluginSpecificComp.left = new FormAttachment(0, 0);
        fdPluginSpecificComp.right = new FormAttachment(100, 0);
        fdPluginSpecificComp.top = new FormAttachment((Control)lastControl, margin);
        fdPluginSpecificComp.bottom = new FormAttachment(100, 0);
        this.wPluginSpecificComp.setLayoutData((Object)fdPluginSpecificComp);
        this.addGuiCompositeWidgets();
        FormData fdMainSComp = new FormData();
        fdMainSComp.top = new FormAttachment(0, 0);
        fdMainSComp.left = new FormAttachment(0, 0);
        fdMainSComp.right = new FormAttachment(95, 0);
        fdMainSComp.bottom = new FormAttachment(95, 0);
        wMainSComp.setLayoutData((Object)fdMainSComp);
        FormData fdMainComp = new FormData();
        fdMainComp.left = new FormAttachment(0, 0);
        fdMainComp.top = new FormAttachment(0, 0);
        fdMainComp.right = new FormAttachment(100, 0);
        fdMainComp.bottom = new FormAttachment(100, 0);
        wMainComp.setLayoutData((Object)fdMainComp);
        wMainComp.pack();
        Rectangle mainBounds = wMainComp.getBounds();
        wMainSComp.setContent((Control)wMainComp);
        wMainSComp.setExpandHorizontal(true);
        wMainSComp.setExpandVertical(true);
        wMainSComp.setMinWidth(mainBounds.width);
        wMainSComp.setMinHeight(mainBounds.height);
        this.setWidgetsContent();
        this.resetChanged();
        Listener modifyListener = e -> this.setChanged();
        this.wName.addListener(24, modifyListener);
        this.wDescription.addListener(24, modifyListener);
        this.wDataLoggingDelay.addListener(24, modifyListener);
        this.wDataLoggingInterval.addListener(24, modifyListener);
        this.wPluginType.addListener(24, modifyListener);
        this.wPluginType.addListener(24, e -> this.changeConnectionType());
    }

    private void addGuiCompositeWidgets() {
        for (Control child : this.wPluginSpecificComp.getChildren()) {
            child.dispose();
        }
        if (this.workingLocation.getExecutionInfoLocation() != null) {
            this.guiCompositeWidgets = new GuiCompositeWidgets(this.manager.getVariables());
            this.guiCompositeWidgets.createCompositeWidgets(this.workingLocation.getExecutionInfoLocation(), null, this.wPluginSpecificComp, "ExecutionInfoLocation-PluginSpecific-Options", (Control)this.wDescription);
            this.guiCompositeWidgets.setWidgetsListener(new GuiCompositeWidgetsAdapter(){

                @Override
                public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                    ExecutionInfoLocationEditor.this.setChanged();
                }
            });
        }
        this.wPluginSpecificComp.layout(true, true);
    }

    private void changeConnectionType() {
        if (this.busyChangingPluginType.get()) {
            return;
        }
        this.busyChangingPluginType.set(true);
        this.getWidgetsContent(this.workingLocation);
        if (this.workingLocation.getExecutionInfoLocation() != null) {
            this.metaMap.put(this.workingLocation.getExecutionInfoLocation().getPluginName(), this.workingLocation.getExecutionInfoLocation());
        }
        this.changeWorkingLocation(this.workingLocation);
        this.addGuiCompositeWidgets();
        this.setWidgetsContent();
        this.busyChangingPluginType.set(false);
    }

    @Override
    public void save() throws HopException {
        this.changeWorkingLocation(this.executionInfoLocation);
        super.save();
    }

    @Override
    public void setWidgetsContent() {
        this.wName.setText(Const.NVL((String)this.workingLocation.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)this.workingLocation.getDescription(), (String)""));
        this.wDataLoggingDelay.setText(Const.NVL((String)this.workingLocation.getDataLoggingDelay(), (String)""));
        this.wDataLoggingInterval.setText(Const.NVL((String)this.workingLocation.getDataLoggingInterval(), (String)""));
        if (this.workingLocation.getExecutionInfoLocation() != null) {
            this.wPluginType.setText(Const.NVL((String)this.workingLocation.getExecutionInfoLocation().getPluginName(), (String)""));
            this.guiCompositeWidgets.setWidgetsContents(this.workingLocation.getExecutionInfoLocation(), this.wPluginSpecificComp, "ExecutionInfoLocation-PluginSpecific-Options");
        } else {
            this.wPluginType.setText("");
        }
    }

    @Override
    public void getWidgetsContent(ExecutionInfoLocation location) {
        location.setName(this.wName.getText());
        location.setDescription(this.wDescription.getText());
        location.setDataLoggingDelay(this.wDataLoggingDelay.getText());
        location.setDataLoggingInterval(this.wDataLoggingInterval.getText());
        if (location.getExecutionInfoLocation() != null && this.guiCompositeWidgets != null && !this.guiCompositeWidgets.getWidgetsMap().isEmpty()) {
            this.guiCompositeWidgets.getWidgetsContents(location.getExecutionInfoLocation(), "ExecutionInfoLocation-PluginSpecific-Options");
        }
    }

    private void changeWorkingLocation(ExecutionInfoLocation meta) {
        String pluginName = this.wPluginType.getText();
        IExecutionInfoLocation old = this.metaMap.get(pluginName);
        if (old != null) {
            meta.setExecutionInfoLocation(old);
        } else {
            meta.setExecutionInfoLocation(null);
        }
    }

    private String[] getPluginTypes() {
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(ExecutionInfoLocationPluginType.class);
        String[] types = new String[plugins.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ((IPlugin)plugins.get(i)).getName();
        }
        Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
        return types;
    }
}

