/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.server;

import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.server.HopServer;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HopServerEditor
extends MetadataEditor<HopServer> {
    private static final Class<?> PKG = HopServerEditor.class;
    private CTabFolder wTabFolder;
    private Text wName;
    private TextVar wHostname;
    private TextVar wPort;
    private TextVar wWebAppName;
    private TextVar wUsername;
    private TextVar wPassword;
    private Button wSSL;
    private TextVar wProxyHost;
    private TextVar wProxyPort;
    private TextVar wNonProxyHosts;
    private int middle;
    private int margin;

    public HopServerEditor(HopGui hopGui, MetadataManager<HopServer> manager, HopServer metadata) {
        super(hopGui, manager, metadata);
    }

    @Override
    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        this.middle = props.getMiddlePct();
        this.margin = props.getMargin();
        Label wIcon = new Label(parent, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlicon);
        props.setLook((Control)wIcon);
        Label wlName = new Label(parent, 131072);
        props.setLook((Control)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.ServerName.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, 0);
        fdlName.left = new FormAttachment(0, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        props.setLook((Control)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 5);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment((Control)wIcon, -5);
        this.wName.setLayoutData((Object)fdName);
        Label spacer = new Label(parent, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wTabFolder = new CTabFolder(parent, 2048);
        props.setLook((Control)this.wTabFolder, 5);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)spacer, 15);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.createServiceTab();
        this.createProxyTab();
        this.wTabFolder.setSelection(0);
        this.setWidgetsContent();
        ModifyListener lsMod = e -> this.setChanged();
        this.wName.addModifyListener(lsMod);
        this.wHostname.addModifyListener(lsMod);
        this.wPort.addModifyListener(lsMod);
        this.wWebAppName.addModifyListener(lsMod);
        this.wUsername.addModifyListener(lsMod);
        this.wPassword.addModifyListener(lsMod);
        this.wProxyHost.addModifyListener(lsMod);
        this.wProxyPort.addModifyListener(lsMod);
        this.wNonProxyHosts.addModifyListener(lsMod);
        this.wSSL.addListener(13, e -> this.setChanged());
    }

    private void createServiceTab() {
        PropsUi props = PropsUi.getInstance();
        HopServer hopServer = (HopServer)this.getMetadata();
        CTabItem wServiceTab = new CTabItem(this.wTabFolder, 0);
        wServiceTab.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.USER_TAB_SERVICE", (String[])new String[0]));
        Composite wServiceComp = new Composite((Composite)this.wTabFolder, 0);
        props.setLook((Control)wServiceComp);
        FormLayout genLayout = new FormLayout();
        genLayout.marginWidth = 5;
        genLayout.marginHeight = 5;
        wServiceComp.setLayout((Layout)genLayout);
        Label wlHostname = new Label(wServiceComp, 131072);
        props.setLook((Control)wlHostname);
        wlHostname.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.HostIP.Label", (String[])new String[0]));
        FormData fdlHostname = new FormData();
        fdlHostname.top = new FormAttachment(0, this.margin * 2);
        fdlHostname.left = new FormAttachment(0, 0);
        fdlHostname.right = new FormAttachment(this.middle, -this.margin);
        wlHostname.setLayoutData((Object)fdlHostname);
        this.wHostname = new TextVar(this.manager.getVariables(), wServiceComp, 18436);
        props.setLook((Control)this.wHostname);
        FormData fdHostname = new FormData();
        fdHostname.top = new FormAttachment((Control)this.wName, this.margin * 2);
        fdHostname.left = new FormAttachment(this.middle, 0);
        fdHostname.right = new FormAttachment(95, 0);
        this.wHostname.setLayoutData(fdHostname);
        Label wlPort = new Label(wServiceComp, 131072);
        props.setLook((Control)wlPort);
        wlPort.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.Port.Label", (String[])new String[0]));
        FormData fdlPort = new FormData();
        fdlPort.top = new FormAttachment((Control)this.wHostname, this.margin);
        fdlPort.left = new FormAttachment(0, 0);
        fdlPort.right = new FormAttachment(this.middle, -this.margin);
        wlPort.setLayoutData((Object)fdlPort);
        this.wPort = new TextVar(this.manager.getVariables(), wServiceComp, 18436);
        props.setLook((Control)this.wPort);
        FormData fdPort = new FormData();
        fdPort.top = new FormAttachment((Control)this.wHostname, this.margin);
        fdPort.left = new FormAttachment(this.middle, 0);
        fdPort.right = new FormAttachment(95, 0);
        this.wPort.setLayoutData(fdPort);
        Label wlWebAppName = new Label(wServiceComp, 131072);
        wlWebAppName.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.WebAppName.Label", (String[])new String[0]));
        props.setLook((Control)wlWebAppName);
        FormData fdlWebAppName = new FormData();
        fdlWebAppName.top = new FormAttachment((Control)this.wPort, this.margin);
        fdlWebAppName.left = new FormAttachment(0, 0);
        fdlWebAppName.right = new FormAttachment(this.middle, -this.margin);
        wlWebAppName.setLayoutData((Object)fdlWebAppName);
        this.wWebAppName = new TextVar(this.manager.getVariables(), wServiceComp, 18436);
        props.setLook((Control)this.wWebAppName);
        FormData fdWebAppName = new FormData();
        fdWebAppName.top = new FormAttachment((Control)this.wPort, this.margin);
        fdWebAppName.left = new FormAttachment(this.middle, 0);
        fdWebAppName.right = new FormAttachment(95, 0);
        this.wWebAppName.setLayoutData(fdWebAppName);
        Label wlUsername = new Label(wServiceComp, 131072);
        wlUsername.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.UserName.Label", (String[])new String[0]));
        props.setLook((Control)wlUsername);
        FormData fdlUsername = new FormData();
        fdlUsername.top = new FormAttachment((Control)this.wWebAppName, this.margin);
        fdlUsername.left = new FormAttachment(0, 0);
        fdlUsername.right = new FormAttachment(this.middle, -this.margin);
        wlUsername.setLayoutData((Object)fdlUsername);
        this.wUsername = new TextVar(this.manager.getVariables(), wServiceComp, 18436);
        props.setLook((Control)this.wUsername);
        FormData fdUsername = new FormData();
        fdUsername.top = new FormAttachment((Control)this.wWebAppName, this.margin);
        fdUsername.left = new FormAttachment(this.middle, 0);
        fdUsername.right = new FormAttachment(95, 0);
        this.wUsername.setLayoutData(fdUsername);
        Label wlPassword = new Label(wServiceComp, 131072);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.Password.Label", (String[])new String[0]));
        props.setLook((Control)wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.top = new FormAttachment((Control)this.wUsername, this.margin);
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.right = new FormAttachment(this.middle, -this.margin);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(this.manager.getVariables(), wServiceComp, 18436);
        props.setLook((Control)this.wPassword);
        FormData fdPassword = new FormData();
        fdPassword.top = new FormAttachment((Control)this.wUsername, this.margin);
        fdPassword.left = new FormAttachment(this.middle, 0);
        fdPassword.right = new FormAttachment(95, 0);
        this.wPassword.setLayoutData(fdPassword);
        Label wlSSL = new Label(wServiceComp, 131072);
        wlSSL.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.UseSsl.Label", (String[])new String[0]));
        props.setLook((Control)wlSSL);
        FormData fd = new FormData();
        fd.top = new FormAttachment((Control)this.wPassword, this.margin);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(this.middle, -this.margin);
        wlSSL.setLayoutData((Object)fd);
        wlSSL.setVisible(true);
        this.wSSL = new Button(wServiceComp, 32);
        props.setLook((Control)this.wSSL);
        FormData bfd = new FormData();
        bfd.top = new FormAttachment((Control)wlSSL, 0, 0x1000000);
        bfd.left = new FormAttachment(this.middle, 0);
        bfd.right = new FormAttachment(95, 0);
        this.wSSL.setLayoutData((Object)bfd);
        this.wSSL.setVisible(true);
        FormData fdServiceComp = new FormData();
        fdServiceComp.left = new FormAttachment(0, 0);
        fdServiceComp.top = new FormAttachment(0, 0);
        fdServiceComp.right = new FormAttachment(100, 0);
        fdServiceComp.bottom = new FormAttachment(100, 0);
        wServiceComp.setLayoutData((Object)fdServiceComp);
        wServiceComp.layout();
        wServiceTab.setControl((Control)wServiceComp);
    }

    private void createProxyTab() {
        PropsUi props = PropsUi.getInstance();
        HopServer hopServer = (HopServer)this.getMetadata();
        CTabItem wProxyTab = new CTabItem(this.wTabFolder, 0);
        wProxyTab.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.USER_TAB_PROXY", (String[])new String[0]));
        FormLayout poolLayout = new FormLayout();
        poolLayout.marginWidth = 5;
        poolLayout.marginHeight = 5;
        Composite wProxyComp = new Composite((Composite)this.wTabFolder, 0);
        props.setLook((Control)wProxyComp);
        wProxyComp.setLayout((Layout)poolLayout);
        Label wlProxyHost = new Label(wProxyComp, 131072);
        props.setLook((Control)wlProxyHost);
        wlProxyHost.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.ProxyServerName.Label", (String[])new String[0]));
        FormData fdlProxyHost = new FormData();
        fdlProxyHost.top = new FormAttachment(0, 0);
        fdlProxyHost.left = new FormAttachment(0, 0);
        fdlProxyHost.right = new FormAttachment(this.middle, -this.margin);
        wlProxyHost.setLayoutData((Object)fdlProxyHost);
        this.wProxyHost = new TextVar(this.manager.getVariables(), wProxyComp, 18436);
        props.setLook((Control)this.wProxyHost);
        FormData fdProxyHost = new FormData();
        fdProxyHost.top = new FormAttachment(0, 0);
        fdProxyHost.left = new FormAttachment(this.middle, 0);
        fdProxyHost.right = new FormAttachment(95, 0);
        this.wProxyHost.setLayoutData(fdProxyHost);
        Label wlProxyPort = new Label(wProxyComp, 131072);
        props.setLook((Control)wlProxyPort);
        wlProxyPort.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.ProxyServerPort.Label", (String[])new String[0]));
        FormData fdlProxyPort = new FormData();
        fdlProxyPort.top = new FormAttachment((Control)this.wProxyHost, this.margin);
        fdlProxyPort.left = new FormAttachment(0, 0);
        fdlProxyPort.right = new FormAttachment(this.middle, -this.margin);
        wlProxyPort.setLayoutData((Object)fdlProxyPort);
        this.wProxyPort = new TextVar(this.manager.getVariables(), wProxyComp, 18436);
        props.setLook((Control)this.wProxyPort);
        FormData fdProxyPort = new FormData();
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, this.margin);
        fdProxyPort.left = new FormAttachment(this.middle, 0);
        fdProxyPort.right = new FormAttachment(95, 0);
        this.wProxyPort.setLayoutData(fdProxyPort);
        Label wlNonProxyHosts = new Label(wProxyComp, 131072);
        props.setLook((Control)wlNonProxyHosts);
        wlNonProxyHosts.setText(BaseMessages.getString(PKG, (String)"HopServerDialog.IgnoreProxyForHosts.Label", (String[])new String[0]));
        FormData fdlNonProxyHosts = new FormData();
        fdlNonProxyHosts.top = new FormAttachment((Control)this.wProxyPort, this.margin);
        fdlNonProxyHosts.left = new FormAttachment(0, 0);
        fdlNonProxyHosts.right = new FormAttachment(this.middle, -this.margin);
        wlNonProxyHosts.setLayoutData((Object)fdlNonProxyHosts);
        this.wNonProxyHosts = new TextVar(this.manager.getVariables(), wProxyComp, 18436);
        props.setLook((Control)this.wNonProxyHosts);
        FormData fdNonProxyHosts = new FormData();
        fdNonProxyHosts.top = new FormAttachment((Control)this.wProxyPort, this.margin);
        fdNonProxyHosts.left = new FormAttachment(this.middle, 0);
        fdNonProxyHosts.right = new FormAttachment(95, 0);
        this.wNonProxyHosts.setLayoutData(fdNonProxyHosts);
        FormData fdProxyComp = new FormData();
        fdProxyComp.left = new FormAttachment(0, 0);
        fdProxyComp.top = new FormAttachment(0, 0);
        fdProxyComp.right = new FormAttachment(100, 0);
        fdProxyComp.bottom = new FormAttachment(100, 0);
        wProxyComp.setLayoutData((Object)fdProxyComp);
        wProxyComp.layout();
        wProxyTab.setControl((Control)wProxyComp);
    }

    @Override
    public void setWidgetsContent() {
        HopServer server = (HopServer)this.getMetadata();
        this.wName.setText(Const.NVL((String)server.getName(), (String)""));
        this.wHostname.setText(Const.NVL((String)server.getHostname(), (String)""));
        this.wPort.setText(Const.NVL((String)server.getPort(), (String)""));
        this.wWebAppName.setText(Const.NVL((String)server.getWebAppName(), (String)""));
        this.wUsername.setText(Const.NVL((String)server.getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)server.getPassword(), (String)""));
        this.wProxyHost.setText(Const.NVL((String)server.getProxyHostname(), (String)""));
        this.wProxyPort.setText(Const.NVL((String)server.getProxyPort(), (String)""));
        this.wNonProxyHosts.setText(Const.NVL((String)server.getNonProxyHosts(), (String)""));
        this.wSSL.setSelection(server.isSslMode());
    }

    @Override
    public void getWidgetsContent(HopServer server) {
        server.setName(this.wName.getText());
        server.setHostname(this.wHostname.getText());
        server.setPort(this.wPort.getText());
        server.setWebAppName(this.wWebAppName.getText());
        server.setUsername(this.wUsername.getText());
        server.setPassword(this.wPassword.getText());
        server.setProxyHostname(this.wProxyHost.getText());
        server.setProxyPort(this.wProxyPort.getText());
        server.setNonProxyHosts(this.wNonProxyHosts.getText());
        server.setSslMode(this.wSSL.getSelection());
    }

    @Override
    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }

    public void test() {
        HopServer server = (HopServer)this.getMetadata();
        this.getWidgetsContent(server);
        try {
            String xml = "<sample/>";
            String reply = server.sendXml(this.manager.getVariables(), xml, "/hop/registerPipeline");
            String message = BaseMessages.getString(PKG, (String)"HopServer.Replay.Info1", (String[])new String[0]) + server.constructUrl(this.manager.getVariables(), "/hop/registerPipeline") + Const.CR + BaseMessages.getString(PKG, (String)"HopServer.Replay.Info2", (String[])new String[0]) + Const.CR + Const.CR;
            message = message + xml;
            message = message + Const.CR + Const.CR;
            message = message + "Reply was:" + Const.CR + Const.CR;
            message = message + reply + Const.CR;
            EnterTextDialog dialog = new EnterTextDialog(this.getShell(), "XML", BaseMessages.getString(PKG, (String)"HopServer.RetournedXMLInfo", (String[])new String[0]), message);
            dialog.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"HopServer.ExceptionError", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopServer.ExceptionUnableGetReplay.Error1", (String[])new String[0]) + server.getHostname() + BaseMessages.getString(PKG, (String)"HopServer.ExceptionUnableGetReplay.Error2", (String[])new String[0]), e);
        }
    }
}

