/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.workflow.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiCompositeWidgetsAdapter;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEnginePluginType;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

@GuiPlugin(description="This dialog allows you to configure the various workflow run configurations")
public class WorkflowRunConfigurationEditor
extends MetadataEditor<WorkflowRunConfiguration> {
    private static final Class<?> PKG = WorkflowRunConfigurationEditor.class;
    private WorkflowRunConfiguration runConfiguration;
    private WorkflowRunConfiguration workingConfiguration;
    private Text wName;
    private Text wDescription;
    private MetaSelectionLine<ExecutionInfoLocation> wExecutionInfoLocation;
    private ComboVar wPluginType;
    private Composite wPluginSpecificComp;
    private GuiCompositeWidgets guiCompositeWidgets;
    private Map<String, IWorkflowEngineRunConfiguration> metaMap;
    private Listener modifyListener = e -> this.setChanged();
    private AtomicBoolean busyChangingPluginType = new AtomicBoolean(false);

    public WorkflowRunConfigurationEditor(HopGui hopGui, MetadataManager<WorkflowRunConfiguration> manager, WorkflowRunConfiguration runConfiguration) {
        super(hopGui, manager, runConfiguration);
        this.runConfiguration = runConfiguration;
        this.workingConfiguration = new WorkflowRunConfiguration(runConfiguration);
        this.metaMap = this.populateMetaMap();
        if (this.workingConfiguration.getEngineRunConfiguration() != null) {
            this.metaMap.put(this.workingConfiguration.getEngineRunConfiguration().getEnginePluginName(), this.workingConfiguration.getEngineRunConfiguration());
        }
    }

    private Map<String, IWorkflowEngineRunConfiguration> populateMetaMap() {
        this.metaMap = new HashMap<String, IWorkflowEngineRunConfiguration>();
        List plugins = PluginRegistry.getInstance().getPlugins(WorkflowEnginePluginType.class);
        for (IPlugin plugin : plugins) {
            try {
                IWorkflowEngine engine = (IWorkflowEngine)PluginRegistry.getInstance().loadClass(plugin, IWorkflowEngine.class);
                IWorkflowEngineRunConfiguration engineRunConfiguration = engine.createDefaultWorkflowEngineRunConfiguration();
                engineRunConfiguration.setEnginePluginId(plugin.getIds()[0]);
                engineRunConfiguration.setEnginePluginName(plugin.getName());
                this.metaMap.put(engineRunConfiguration.getEnginePluginName(), engineRunConfiguration);
            }
            catch (Exception e) {
                HopGui.getInstance().getLog().logError("Error instantiating workflow run configuration plugin", (Throwable)e);
            }
        }
        return this.metaMap;
    }

    @Override
    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = props.getMargin();
        Label wlName = new Label(parent, 131072);
        props.setLook((Control)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"WorkflowRunConfigurationDialog.label.name", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin * 2);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        props.setLook((Control)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Object lastControl = this.wName;
        Label wlDescription = new Label(parent, 131072);
        props.setLook((Control)wlDescription);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"WorkflowRunConfigurationDialog.label.Description", (String[])new String[0]));
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(middle, 0);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(parent, 18436);
        props.setLook((Control)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.top = new FormAttachment((Control)wlDescription, 0, 0x1000000);
        fdDescription.left = new FormAttachment(middle, margin);
        fdDescription.right = new FormAttachment(100, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        lastControl = this.wDescription;
        this.wExecutionInfoLocation = new MetaSelectionLine<ExecutionInfoLocation>(this.manager.getVariables(), this.manager.getMetadataProvider(), ExecutionInfoLocation.class, parent, 16388, BaseMessages.getString(PKG, (String)"WorkflowRunConfigurationDialog.label.ExecutionInfoLocation", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WorkflowRunConfigurationDialog.toolTip.ExecutionInfoLocation", (String[])new String[0]));
        props.setLook((Control)this.wExecutionInfoLocation);
        FormData fdExecutionInfoLocation = new FormData();
        fdExecutionInfoLocation.top = new FormAttachment((Control)lastControl, margin);
        fdExecutionInfoLocation.left = new FormAttachment(0, 0);
        fdExecutionInfoLocation.right = new FormAttachment(100, 0);
        this.wExecutionInfoLocation.setLayoutData(fdExecutionInfoLocation);
        lastControl = this.wExecutionInfoLocation;
        Label wlPluginType = new Label(parent, 131072);
        props.setLook((Control)wlPluginType);
        wlPluginType.setText(BaseMessages.getString(PKG, (String)"WorkflowRunConfigurationDialog.label.EngineType", (String[])new String[0]));
        FormData fdlPluginType = new FormData();
        fdlPluginType.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlPluginType.left = new FormAttachment(0, 0);
        fdlPluginType.right = new FormAttachment(middle, 0);
        wlPluginType.setLayoutData((Object)fdlPluginType);
        this.wPluginType = new ComboVar(this.manager.getVariables(), parent, 18436);
        props.setLook((Control)this.wPluginType);
        this.wPluginType.setItems(this.getPluginTypes());
        FormData fdPluginType = new FormData();
        fdPluginType.top = new FormAttachment((Control)wlPluginType, 0, 0x1000000);
        fdPluginType.left = new FormAttachment(middle, margin);
        fdPluginType.right = new FormAttachment(100, 0);
        this.wPluginType.setLayoutData(fdPluginType);
        lastControl = this.wPluginType;
        this.wPluginSpecificComp = new Composite(parent, 8);
        props.setLook((Control)this.wPluginSpecificComp);
        this.wPluginSpecificComp.setLayout((Layout)new FormLayout());
        FormData fdPluginSpecificComp = new FormData();
        fdPluginSpecificComp.left = new FormAttachment(0, 0);
        fdPluginSpecificComp.right = new FormAttachment(100, 0);
        fdPluginSpecificComp.top = new FormAttachment((Control)lastControl, margin);
        fdPluginSpecificComp.bottom = new FormAttachment(100, 0);
        this.wPluginSpecificComp.setLayoutData((Object)fdPluginSpecificComp);
        this.addGuiCompositeWidgets();
        this.setWidgetsContent();
        this.resetChanged();
        this.wName.addListener(24, this.modifyListener);
        this.wDescription.addListener(24, this.modifyListener);
        this.wPluginType.addListener(24, this.modifyListener);
        this.wPluginType.addListener(24, e -> this.changeConnectionType());
    }

    private void addGuiCompositeWidgets() {
        for (Control child : this.wPluginSpecificComp.getChildren()) {
            child.dispose();
        }
        if (this.workingConfiguration.getEngineRunConfiguration() != null) {
            this.guiCompositeWidgets = new GuiCompositeWidgets(this.manager.getVariables());
            this.guiCompositeWidgets.createCompositeWidgets(this.workingConfiguration.getEngineRunConfiguration(), null, this.wPluginSpecificComp, "WorkflowRunConfiguration-PluginSpecific-Options", null);
            this.guiCompositeWidgets.setWidgetsListener(new GuiCompositeWidgetsAdapter(){

                @Override
                public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                    WorkflowRunConfigurationEditor.this.setChanged();
                }
            });
        }
    }

    private void changeConnectionType() {
        if (this.busyChangingPluginType.get()) {
            return;
        }
        this.busyChangingPluginType.set(true);
        this.getWidgetsContent(this.workingConfiguration);
        if (this.workingConfiguration.getEngineRunConfiguration() != null) {
            this.metaMap.put(this.workingConfiguration.getEngineRunConfiguration().getEnginePluginName(), this.workingConfiguration.getEngineRunConfiguration());
        }
        this.changeWorkingEngineConfiguration(this.workingConfiguration);
        this.addGuiCompositeWidgets();
        this.setWidgetsContent();
        this.busyChangingPluginType.set(false);
    }

    @Override
    public void save() throws HopException {
        this.changeWorkingEngineConfiguration(this.runConfiguration);
        super.save();
    }

    @Override
    public void setWidgetsContent() {
        this.wName.setText(Const.NVL((String)this.workingConfiguration.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)this.workingConfiguration.getDescription(), (String)""));
        try {
            this.wExecutionInfoLocation.fillItems();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error getting the list of execution information locations", e);
        }
        this.wExecutionInfoLocation.setText(Const.NVL((String)this.workingConfiguration.getExecutionInfoLocationName(), (String)""));
        if (this.workingConfiguration.getEngineRunConfiguration() != null) {
            this.wPluginType.setText(Const.NVL((String)this.workingConfiguration.getEngineRunConfiguration().getEnginePluginName(), (String)""));
            this.guiCompositeWidgets.setWidgetsContents(this.workingConfiguration.getEngineRunConfiguration(), this.wPluginSpecificComp, "WorkflowRunConfiguration-PluginSpecific-Options");
        } else {
            this.wPluginType.setText("");
        }
    }

    @Override
    public void getWidgetsContent(WorkflowRunConfiguration meta) {
        meta.setName(this.wName.getText());
        meta.setDescription(this.wDescription.getText());
        meta.setExecutionInfoLocationName(this.wExecutionInfoLocation.getText());
        if (meta.getEngineRunConfiguration() != null && this.guiCompositeWidgets != null && !this.guiCompositeWidgets.getWidgetsMap().isEmpty()) {
            this.guiCompositeWidgets.getWidgetsContents(meta.getEngineRunConfiguration(), "WorkflowRunConfiguration-PluginSpecific-Options");
        }
    }

    private void changeWorkingEngineConfiguration(WorkflowRunConfiguration meta) {
        String pluginName = this.wPluginType.getText();
        IWorkflowEngineRunConfiguration engineRunConfiguration = this.metaMap.get(pluginName);
        if (engineRunConfiguration != null) {
            meta.setEngineRunConfiguration(engineRunConfiguration);
        } else {
            meta.setEngineRunConfiguration(null);
        }
    }

    private String[] getPluginTypes() {
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(WorkflowEnginePluginType.class);
        String[] types = new String[plugins.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ((IPlugin)plugins.get(i)).getName();
        }
        Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
        return types;
    }
}

