/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Objects;
import org.apache.hive.common.util.SuppressFBWarnings;

public class Date
implements Comparable<Date> {
    private static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);
    private static final DateTimeFormatter PARSE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NORMAL).toFormatter().withResolverStyle(ResolverStyle.STRICT);
    private static final DateTimeFormatter PRINT_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("uuuu-MM-dd")).toFormatter();
    private LocalDate localDate;

    private Date(LocalDate localDate) {
        this.localDate = localDate != null ? localDate : EPOCH;
    }

    public Date() {
        this(EPOCH);
    }

    public Date(Date d) {
        this(d.localDate);
    }

    public String toString() {
        return this.localDate.format(PRINT_FORMATTER);
    }

    public int hashCode() {
        return this.localDate.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Date) {
            return this.compareTo((Date)other) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Date o) {
        return this.localDate.compareTo(o.localDate);
    }

    public int toEpochDay() {
        return (int)this.localDate.toEpochDay();
    }

    public long toEpochSecond() {
        return this.localDate.atStartOfDay().toEpochSecond(ZoneOffset.UTC);
    }

    public long toEpochMilli() {
        return this.localDate.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public long toEpochMilli(ZoneId id) {
        return this.localDate.atStartOfDay().atZone(id).toInstant().toEpochMilli();
    }

    public void setYear(int year) {
        this.localDate = this.localDate.withYear(year);
    }

    public void setMonth(int month) {
        this.localDate = this.localDate.withMonth(month);
    }

    public void setDayOfMonth(int dayOfMonth) {
        this.localDate = this.localDate.withDayOfMonth(dayOfMonth);
    }

    public void setTimeInDays(int epochDay) {
        this.localDate = LocalDate.ofEpochDay(epochDay);
    }

    public void setTimeInMillis(long epochMilli) {
        this.localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC).toLocalDate();
    }

    public static Date valueOf(String text) {
        LocalDate localDate;
        String s = Objects.requireNonNull(text).trim();
        int idx = s.indexOf(" ");
        if (idx != -1) {
            s = s.substring(0, idx);
        } else {
            idx = s.indexOf(84);
            if (idx != -1) {
                s = s.substring(0, idx);
            }
        }
        try {
            localDate = LocalDate.parse(s, PARSE_FORMATTER);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException("Cannot create date, parsing error");
        }
        return new Date(localDate);
    }

    public static Date ofEpochDay(int epochDay) {
        return new Date(LocalDate.ofEpochDay(epochDay));
    }

    public static Date ofEpochMilli(long epochMilli) {
        return new Date(LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC).toLocalDate());
    }

    public static Date of(int year, int month, int dayOfMonth) {
        return new Date(LocalDate.of(year, month, dayOfMonth));
    }

    public int getYear() {
        return this.localDate.getYear();
    }

    public int getMonth() {
        return this.localDate.getMonthValue();
    }

    public int getDay() {
        return this.localDate.getDayOfMonth();
    }

    public int lengthOfMonth() {
        return this.localDate.lengthOfMonth();
    }

    public int getDayOfWeek() {
        return this.localDate.getDayOfWeek().plus(1L).getValue();
    }

    @SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"}, justification="Intended")
    public Object clone() {
        return new Date(this.localDate);
    }
}

