/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiException;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.TableName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusException;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import com.google.bigtable.repackaged.io.opencensus.tags.TagValue;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@InternalApi(value="For internal use only")
public class Util {
    static final Metadata.Key<String> ATTEMPT_HEADER_KEY = Metadata.Key.of("bigtable-attempt", Metadata.ASCII_STRING_MARSHALLER);
    static final Metadata.Key<String> ATTEMPT_EPOCH_KEY = Metadata.Key.of("bigtable-client-attempt-epoch-usec", Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SERVER_TIMING_HEADER_KEY = Metadata.Key.of("server-timing", Metadata.ASCII_STRING_MARSHALLER);
    private static final Pattern SERVER_TIMING_HEADER_PATTERN = Pattern.compile(".*dur=(?<dur>\\d+)");
    static final Metadata.Key<byte[]> METADATA_KEY = Metadata.Key.of("x-goog-ext-425905942-bin", Metadata.BINARY_BYTE_MARSHALLER);

    static String extractStatus(@Nullable Throwable error) {
        if (error == null) {
            return StatusCode.Code.OK.toString();
        }
        String statusString = error instanceof CancellationException ? Status.Code.CANCELLED.toString() : (error instanceof ApiException ? ((ApiException)error).getStatusCode().getCode().toString() : (error instanceof StatusRuntimeException ? ((StatusRuntimeException)error).getStatus().getCode().toString() : (error instanceof StatusException ? ((StatusException)error).getStatus().getCode().toString() : StatusCode.Code.UNKNOWN.toString())));
        return statusString;
    }

    static TagValue extractStatusFromFuture(Future<?> future) {
        Throwable error = null;
        try {
            future.get();
        }
        catch (InterruptedException e) {
            error = e;
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            error = e.getCause();
        }
        catch (RuntimeException e) {
            error = e;
        }
        return TagValue.create(Util.extractStatus(error));
    }

    static String extractTableId(Object request) {
        String tableName = null;
        if (request instanceof ReadRowsRequest) {
            tableName = ((ReadRowsRequest)request).getTableName();
        } else if (request instanceof MutateRowsRequest) {
            tableName = ((MutateRowsRequest)request).getTableName();
        } else if (request instanceof MutateRowRequest) {
            tableName = ((MutateRowRequest)request).getTableName();
        } else if (request instanceof SampleRowKeysRequest) {
            tableName = ((SampleRowKeysRequest)request).getTableName();
        } else if (request instanceof CheckAndMutateRowRequest) {
            tableName = ((CheckAndMutateRowRequest)request).getTableName();
        } else if (request instanceof ReadModifyWriteRowRequest) {
            tableName = ((ReadModifyWriteRowRequest)request).getTableName();
        }
        return !Strings.isNullOrEmpty(tableName) ? TableName.parse(tableName).getTable() : "undefined";
    }

    static Map<String, List<String>> createStatsHeaders(ApiCallContext apiCallContext) {
        ImmutableMap.Builder<String, List<String>> headers = ImmutableMap.builder();
        headers.put(ATTEMPT_EPOCH_KEY.name(), Arrays.asList(String.valueOf(Instant.EPOCH.until(Instant.now(), ChronoUnit.MICROS))));
        if (apiCallContext.getTracer() instanceof BigtableTracer) {
            int attemptCount = ((BigtableTracer)apiCallContext.getTracer()).getAttempt();
            headers.put(ATTEMPT_HEADER_KEY.name(), Arrays.asList(String.valueOf(attemptCount)));
        }
        return headers.build();
    }

    static Long getGfeLatency(Metadata metadata) {
        String serverTiming;
        Matcher matcher;
        if (metadata != null && metadata.get(SERVER_TIMING_HEADER_KEY) != null && (matcher = SERVER_TIMING_HEADER_PATTERN.matcher(serverTiming = metadata.get(SERVER_TIMING_HEADER_KEY))).find()) {
            long latency = Long.valueOf(matcher.group("dur"));
            return latency;
        }
        return null;
    }
}

