/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryingFuture;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsAttemptCallable;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class MutateRowsRetryingCallable
extends UnaryCallable<MutateRowsRequest, Void> {
    private final ApiCallContext callContextPrototype;
    private final ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> callable;
    private final RetryingExecutorWithContext<Void> executor;
    private final ImmutableSet<StatusCode.Code> retryCodes;

    public MutateRowsRetryingCallable(@Nonnull ApiCallContext callContextPrototype, @Nonnull ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> callable, @Nonnull RetryingExecutorWithContext<Void> executor, @Nonnull Set<StatusCode.Code> retryCodes) {
        this.callContextPrototype = Preconditions.checkNotNull(callContextPrototype);
        this.callable = Preconditions.checkNotNull(callable);
        this.executor = Preconditions.checkNotNull(executor);
        this.retryCodes = ImmutableSet.copyOf(retryCodes);
    }

    @Override
    public RetryingFuture<Void> futureCall(MutateRowsRequest request, ApiCallContext inputContext) {
        ApiCallContext context = this.callContextPrototype.nullToSelf(inputContext);
        MutateRowsAttemptCallable retryCallable = new MutateRowsAttemptCallable(this.callable.all(), request, context, this.retryCodes);
        RetryingFuture<Void> retryingFuture = this.executor.createFuture(retryCallable, context);
        retryCallable.setExternalFuture(retryingFuture);
        retryCallable.call();
        return retryingFuture;
    }

    public String toString() {
        return String.format("retrying(%s)", this.callable);
    }
}

