/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.re2j;

import com.google.bigtable.repackaged.com.google.re2j.Compiler;
import com.google.bigtable.repackaged.com.google.re2j.Machine;
import com.google.bigtable.repackaged.com.google.re2j.MachineInput;
import com.google.bigtable.repackaged.com.google.re2j.MatcherInput;
import com.google.bigtable.repackaged.com.google.re2j.Parser;
import com.google.bigtable.repackaged.com.google.re2j.PatternSyntaxException;
import com.google.bigtable.repackaged.com.google.re2j.Prog;
import com.google.bigtable.repackaged.com.google.re2j.Regexp;
import com.google.bigtable.repackaged.com.google.re2j.Simplify;
import com.google.bigtable.repackaged.com.google.re2j.Utils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;

class RE2 {
    static final int FOLD_CASE = 1;
    static final int LITERAL = 2;
    static final int CLASS_NL = 4;
    static final int DOT_NL = 8;
    static final int ONE_LINE = 16;
    static final int NON_GREEDY = 32;
    static final int PERL_X = 64;
    static final int UNICODE_GROUPS = 128;
    static final int WAS_DOLLAR = 256;
    static final int MATCH_NL = 12;
    static final int PERL = 212;
    static final int POSIX = 0;
    static final int UNANCHORED = 0;
    static final int ANCHOR_START = 1;
    static final int ANCHOR_BOTH = 2;
    final String expr;
    final Prog prog;
    final int cond;
    final int numSubexp;
    boolean longest;
    String prefix;
    byte[] prefixUTF8;
    boolean prefixComplete;
    int prefixRune;
    private final Queue<Machine> machine = new ArrayDeque<Machine>();
    public Map<String, Integer> namedGroups;

    RE2(String expr) {
        RE2 re2 = RE2.compile(expr);
        this.expr = re2.expr;
        this.prog = re2.prog;
        this.cond = re2.cond;
        this.numSubexp = re2.numSubexp;
        this.longest = re2.longest;
        this.prefix = re2.prefix;
        this.prefixUTF8 = re2.prefixUTF8;
        this.prefixComplete = re2.prefixComplete;
        this.prefixRune = re2.prefixRune;
    }

    private RE2(String expr, Prog prog, int numSubexp, boolean longest) {
        this.expr = expr;
        this.prog = prog;
        this.numSubexp = numSubexp;
        this.cond = prog.startCond();
        this.longest = longest;
    }

    static RE2 compile(String expr) throws PatternSyntaxException {
        return RE2.compileImpl(expr, 212, false);
    }

    static RE2 compilePOSIX(String expr) throws PatternSyntaxException {
        return RE2.compileImpl(expr, 0, true);
    }

    static RE2 compileImpl(String expr, int mode, boolean longest) throws PatternSyntaxException {
        Regexp re = Parser.parse(expr, mode);
        int maxCap = re.maxCap();
        re = Simplify.simplify(re);
        Prog prog = Compiler.compileRegexp(re);
        RE2 re2 = new RE2(expr, prog, maxCap, longest);
        StringBuilder prefixBuilder = new StringBuilder();
        re2.prefixComplete = prog.prefix(prefixBuilder);
        re2.prefix = prefixBuilder.toString();
        try {
            re2.prefixUTF8 = re2.prefix.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("can't happen");
        }
        if (!re2.prefix.isEmpty()) {
            re2.prefixRune = re2.prefix.codePointAt(0);
        }
        re2.namedGroups = re.namedGroups;
        return re2;
    }

    int numberOfCapturingGroups() {
        return this.numSubexp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Machine get() {
        RE2 rE2 = this;
        synchronized (rE2) {
            if (!this.machine.isEmpty()) {
                return this.machine.remove();
            }
        }
        return new Machine(this);
    }

    synchronized void reset() {
        this.machine.clear();
    }

    synchronized void put(Machine m) {
        this.machine.add(m);
    }

    public String toString() {
        return this.expr;
    }

    private int[] doExecute(MachineInput in, int pos, int anchor, int ncap) {
        Machine m = this.get();
        m.init(ncap);
        int[] cap = m.match(in, pos, anchor) ? m.submatches() : null;
        this.put(m);
        return cap;
    }

    boolean match(CharSequence s) {
        return this.doExecute(MachineInput.fromUTF16(s), 0, 0, 0) != null;
    }

    boolean match(CharSequence input, int start, int end, int anchor, int[] group, int ngroup) {
        return this.match(MatcherInput.utf16(input), start, end, anchor, group, ngroup);
    }

    boolean match(MatcherInput input, int start, int end, int anchor, int[] group, int ngroup) {
        if (start > end) {
            return false;
        }
        MachineInput machineInput = input.getEncoding() == MatcherInput.Encoding.UTF_16 ? MachineInput.fromUTF16(input.asCharSequence(), 0, end) : MachineInput.fromUTF8(input.asBytes(), 0, end);
        int[] groupMatch = this.doExecute(machineInput, start, anchor, 2 * ngroup);
        if (groupMatch == null) {
            return false;
        }
        if (group != null) {
            System.arraycopy(groupMatch, 0, group, 0, groupMatch.length);
        }
        return true;
    }

    boolean matchUTF8(byte[] b) {
        return this.doExecute(MachineInput.fromUTF8(b), 0, 0, 0) != null;
    }

    static boolean match(String pattern, CharSequence s) throws PatternSyntaxException {
        return RE2.compile(pattern).match(s);
    }

    String replaceAll(String src, final String repl) {
        return this.replaceAllFunc(src, new ReplaceFunc(){

            @Override
            public String replace(String orig) {
                return repl;
            }
        }, 2 * src.length() + 1);
    }

    String replaceFirst(String src, final String repl) {
        return this.replaceAllFunc(src, new ReplaceFunc(){

            @Override
            public String replace(String orig) {
                return repl;
            }
        }, 1);
    }

    String replaceAllFunc(String src, ReplaceFunc repl, int maxReplaces) {
        int[] a;
        int lastMatchEnd = 0;
        int searchPos = 0;
        StringBuilder buf = new StringBuilder();
        MachineInput input = MachineInput.fromUTF16(src);
        int numReplaces = 0;
        while (searchPos <= src.length() && (a = this.doExecute(input, searchPos, 0, 2)) != null && a.length != 0) {
            buf.append(src.substring(lastMatchEnd, a[0]));
            if (a[1] > lastMatchEnd || a[0] == 0) {
                buf.append(repl.replace(src.substring(a[0], a[1])));
                ++numReplaces;
            }
            lastMatchEnd = a[1];
            int width = input.step(searchPos) & 7;
            searchPos = searchPos + width > a[1] ? (searchPos += width) : (searchPos + 1 > a[1] ? ++searchPos : a[1]);
            if (numReplaces < maxReplaces) continue;
            break;
        }
        buf.append(src.substring(lastMatchEnd));
        return buf.toString();
    }

    static String quoteMeta(String s) {
        StringBuilder b = new StringBuilder(2 * s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ("\\.+*?()|[]{}^$".indexOf(c) >= 0) {
                b.append('\\');
            }
            b.append(c);
        }
        return b.toString();
    }

    private int[] pad(int[] a) {
        if (a == null) {
            return null;
        }
        int n = (1 + this.numSubexp) * 2;
        if (a.length < n) {
            int[] a2 = new int[n];
            System.arraycopy(a, 0, a2, 0, a.length);
            Arrays.fill(a2, a.length, n, -1);
            a = a2;
        }
        return a;
    }

    private void allMatches(MachineInput input, int n, DeliverFunc deliver) {
        int[] matches;
        int end = input.endPos();
        if (n < 0) {
            n = end + 1;
        }
        int pos = 0;
        int i = 0;
        int prevMatchEnd = -1;
        while (i < n && pos <= end && (matches = this.doExecute(input, pos, 0, this.prog.numCap)) != null && matches.length != 0) {
            boolean accept = true;
            if (matches[1] == pos) {
                int r;
                if (matches[0] == prevMatchEnd) {
                    accept = false;
                }
                pos = (r = input.step(pos)) < 0 ? end + 1 : (pos += r & 7);
            } else {
                pos = matches[1];
            }
            prevMatchEnd = matches[1];
            if (!accept) continue;
            deliver.deliver(this.pad(matches));
            ++i;
        }
    }

    byte[] findUTF8(byte[] b) {
        int[] a = this.doExecute(MachineInput.fromUTF8(b), 0, 0, 2);
        if (a == null) {
            return null;
        }
        return Utils.subarray(b, a[0], a[1]);
    }

    int[] findUTF8Index(byte[] b) {
        int[] a = this.doExecute(MachineInput.fromUTF8(b), 0, 0, 2);
        if (a == null) {
            return null;
        }
        return Utils.subarray(a, 0, 2);
    }

    String find(String s) {
        int[] a = this.doExecute(MachineInput.fromUTF16(s), 0, 0, 2);
        if (a == null) {
            return "";
        }
        return s.substring(a[0], a[1]);
    }

    int[] findIndex(String s) {
        return this.doExecute(MachineInput.fromUTF16(s), 0, 0, 2);
    }

    byte[][] findUTF8Submatch(byte[] b) {
        int[] a = this.doExecute(MachineInput.fromUTF8(b), 0, 0, this.prog.numCap);
        if (a == null) {
            return null;
        }
        byte[][] ret = new byte[1 + this.numSubexp][];
        for (int i = 0; i < ret.length; ++i) {
            if (2 * i >= a.length || a[2 * i] < 0) continue;
            ret[i] = Utils.subarray(b, a[2 * i], a[2 * i + 1]);
        }
        return ret;
    }

    int[] findUTF8SubmatchIndex(byte[] b) {
        return this.pad(this.doExecute(MachineInput.fromUTF8(b), 0, 0, this.prog.numCap));
    }

    String[] findSubmatch(String s) {
        int[] a = this.doExecute(MachineInput.fromUTF16(s), 0, 0, this.prog.numCap);
        if (a == null) {
            return null;
        }
        String[] ret = new String[1 + this.numSubexp];
        for (int i = 0; i < ret.length; ++i) {
            if (2 * i >= a.length || a[2 * i] < 0) continue;
            ret[i] = s.substring(a[2 * i], a[2 * i + 1]);
        }
        return ret;
    }

    int[] findSubmatchIndex(String s) {
        return this.pad(this.doExecute(MachineInput.fromUTF16(s), 0, 0, this.prog.numCap));
    }

    List<byte[]> findAllUTF8(final byte[] b, int n) {
        final ArrayList<byte[]> result = new ArrayList<byte[]>();
        this.allMatches(MachineInput.fromUTF8(b), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                result.add(Utils.subarray(b, match[0], match[1]));
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    List<int[]> findAllUTF8Index(byte[] b, int n) {
        final ArrayList<int[]> result = new ArrayList<int[]>();
        this.allMatches(MachineInput.fromUTF8(b), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                result.add(Utils.subarray(match, 0, 2));
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    List<String> findAll(final String s, int n) {
        final ArrayList<String> result = new ArrayList<String>();
        this.allMatches(MachineInput.fromUTF16(s), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                result.add(s.substring(match[0], match[1]));
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    List<int[]> findAllIndex(String s, int n) {
        final ArrayList<int[]> result = new ArrayList<int[]>();
        this.allMatches(MachineInput.fromUTF16(s), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                result.add(Utils.subarray(match, 0, 2));
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    List<byte[][]> findAllUTF8Submatch(final byte[] b, int n) {
        final ArrayList<byte[][]> result = new ArrayList<byte[][]>();
        this.allMatches(MachineInput.fromUTF8(b), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                byte[][] slice = new byte[match.length / 2][];
                for (int j = 0; j < slice.length; ++j) {
                    if (match[2 * j] < 0) continue;
                    slice[j] = Utils.subarray(b, match[2 * j], match[2 * j + 1]);
                }
                result.add(slice);
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    List<int[]> findAllUTF8SubmatchIndex(byte[] b, int n) {
        final ArrayList<int[]> result = new ArrayList<int[]>();
        this.allMatches(MachineInput.fromUTF8(b), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                result.add(match);
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    List<String[]> findAllSubmatch(final String s, int n) {
        final ArrayList<String[]> result = new ArrayList<String[]>();
        this.allMatches(MachineInput.fromUTF16(s), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                String[] slice = new String[match.length / 2];
                for (int j = 0; j < slice.length; ++j) {
                    if (match[2 * j] < 0) continue;
                    slice[j] = s.substring(match[2 * j], match[2 * j + 1]);
                }
                result.add(slice);
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    List<int[]> findAllSubmatchIndex(String s, int n) {
        final ArrayList<int[]> result = new ArrayList<int[]>();
        this.allMatches(MachineInput.fromUTF16(s), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                result.add(match);
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private static interface DeliverFunc {
        public void deliver(int[] var1);
    }

    static interface ReplaceFunc {
        public String replace(String var1);
    }
}

