/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent.AutoValue_OcAgentTraceExporterConfiguration;
import io.netty.handler.ssl.SslContext;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class OcAgentTraceExporterConfiguration {
    @VisibleForTesting
    static final String DEFAULT_END_POINT = "localhost:55678";
    @VisibleForTesting
    static final String DEFAULT_SERVICE_NAME = "OpenCensus";
    @VisibleForTesting
    static final Duration DEFAULT_RETRY_INTERVAL = Duration.create(300L, 0);
    @VisibleForTesting
    static final Duration DEFAULT_DEADLINE = Duration.create(10L, 0);
    @VisibleForTesting
    static final Duration ZERO = Duration.create(0L, 0);

    OcAgentTraceExporterConfiguration() {
    }

    public abstract String getEndPoint();

    public abstract Boolean getUseInsecure();

    @Nullable
    public abstract SslContext getSslContext();

    public abstract String getServiceName();

    public abstract Duration getRetryInterval();

    public abstract boolean getEnableConfig();

    public abstract Duration getDeadline();

    public static Builder builder() {
        return new AutoValue_OcAgentTraceExporterConfiguration.Builder().setEndPoint(DEFAULT_END_POINT).setServiceName(DEFAULT_SERVICE_NAME).setEnableConfig(true).setUseInsecure(true).setRetryInterval(DEFAULT_RETRY_INTERVAL).setDeadline(DEFAULT_DEADLINE);
    }

    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setEndPoint(String var1);

        public abstract Builder setUseInsecure(Boolean var1);

        public abstract Builder setSslContext(SslContext var1);

        public abstract Builder setServiceName(String var1);

        public abstract Builder setRetryInterval(Duration var1);

        public abstract Builder setEnableConfig(boolean var1);

        public abstract Builder setDeadline(Duration var1);

        abstract Duration getRetryInterval();

        abstract OcAgentTraceExporterConfiguration autoBuild();

        abstract Duration getDeadline();

        public OcAgentTraceExporterConfiguration build() {
            Preconditions.checkArgument(this.getDeadline().compareTo(ZERO) > 0, "Deadline must be positive.");
            Preconditions.checkArgument(this.getRetryInterval().compareTo(ZERO) > 0, "Retry interval must be positive.");
            return this.autoBuild();
        }
    }
}

