/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class MasterAddressTracker
extends ZooKeeperNodeTracker {
    public MasterAddressTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.getMasterAddressZNode(), abortable);
    }

    public static List<ServerName> getBackupMastersAndRenewWatch(ZooKeeperWatcher watcher) {
        List<String> backupMasterStrings;
        try {
            backupMasterStrings = ZKUtil.listChildrenAndWatchForNewChildren(watcher, watcher.backupMasterAddressesZNode);
        }
        catch (KeeperException e) {
            LOG.warn((Object)watcher.prefix("Unable to list backup servers"), (Throwable)e);
            backupMasterStrings = null;
        }
        ArrayList<ServerName> backupMasters = new ArrayList<ServerName>();
        if (backupMasterStrings != null && !backupMasterStrings.isEmpty()) {
            for (String s : backupMasterStrings) {
                try {
                    ServerName sn;
                    byte[] bytes;
                    try {
                        bytes = ZKUtil.getData(watcher, ZKUtil.joinZNode(watcher.backupMasterAddressesZNode, s));
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("Thread interrupted.");
                    }
                    if (bytes == null) continue;
                    try {
                        sn = ServerName.parseFrom(bytes);
                    }
                    catch (DeserializationException e) {
                        LOG.warn((Object)"Failed parse, skipping registering backup server", (Throwable)e);
                        continue;
                    }
                    backupMasters.add(sn);
                }
                catch (InterruptedIOException | KeeperException e) {
                    LOG.warn((Object)watcher.prefix("Unable to get information about backup servers"), (Throwable)e);
                }
            }
            Collections.sort(backupMasters, new Comparator<ServerName>(){

                @Override
                public int compare(ServerName s1, ServerName s2) {
                    return s1.getServerName().compareTo(s2.getServerName());
                }
            });
        }
        return backupMasters;
    }

    public ServerName getMasterAddress() {
        return this.getMasterAddress(false);
    }

    public int getMasterInfoPort() {
        try {
            ZooKeeperProtos.Master master = MasterAddressTracker.parse(this.getData(false));
            if (master == null) {
                return 0;
            }
            return master.getInfoPort();
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse master zk node data", (Throwable)e);
            return 0;
        }
    }

    public int getBackupMasterInfoPort(ServerName sn) {
        String backupZNode = ZKUtil.joinZNode(this.watcher.backupMasterAddressesZNode, sn.toString());
        try {
            byte[] data = ZKUtil.getData(this.watcher, backupZNode);
            ZooKeeperProtos.Master backup = MasterAddressTracker.parse(data);
            if (backup == null) {
                return 0;
            }
            return backup.getInfoPort();
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get backup master: " + sn + "'s info port."), (Throwable)e);
            return 0;
        }
    }

    public ServerName getMasterAddress(boolean refresh) {
        try {
            return ServerName.parseFrom(super.getData(refresh));
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse", (Throwable)e);
            return null;
        }
    }

    public static ServerName getMasterAddress(ZooKeeperWatcher zkw) throws KeeperException, IOException {
        byte[] data;
        try {
            data = ZKUtil.getData(zkw, zkw.getMasterAddressZNode());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (data == null) {
            throw new IOException("Can't get master address from ZooKeeper; znode data == null");
        }
        try {
            return ServerName.parseFrom(data);
        }
        catch (DeserializationException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause(e);
            throw ke;
        }
    }

    public static int getMasterInfoPort(ZooKeeperWatcher zkw) throws KeeperException, IOException {
        byte[] data;
        try {
            data = ZKUtil.getData(zkw, zkw.getMasterAddressZNode());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (data == null) {
            throw new IOException("Can't get master address from ZooKeeper; znode data == null");
        }
        try {
            return MasterAddressTracker.parse(data).getInfoPort();
        }
        catch (DeserializationException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause(e);
            throw ke;
        }
    }

    public static boolean setMasterAddress(ZooKeeperWatcher zkw, String znode, ServerName master, int infoPort) throws KeeperException {
        return ZKUtil.createEphemeralNodeAndWatch(zkw, znode, MasterAddressTracker.toByteArray(master, infoPort));
    }

    public boolean hasMaster() {
        return super.getData(false) != null;
    }

    static byte[] toByteArray(ServerName sn, int infoPort) {
        ZooKeeperProtos.Master.Builder mbuilder = ZooKeeperProtos.Master.newBuilder();
        HBaseProtos.ServerName.Builder snbuilder = HBaseProtos.ServerName.newBuilder();
        snbuilder.setHostName(sn.getHostname());
        snbuilder.setPort(sn.getPort());
        snbuilder.setStartCode(sn.getStartcode());
        mbuilder.setMaster(snbuilder.build());
        mbuilder.setRpcVersion(0);
        mbuilder.setInfoPort(infoPort);
        return ProtobufUtil.prependPBMagic(mbuilder.build().toByteArray());
    }

    public static ZooKeeperProtos.Master parse(byte[] data) throws DeserializationException {
        if (data == null) {
            return null;
        }
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        try {
            return ZooKeeperProtos.Master.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
    }

    public static boolean deleteIfEquals(ZooKeeperWatcher zkw, String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null");
        }
        try {
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch(zkw, zkw.getMasterAddressZNode(), stat);
            ServerName sn = ServerName.parseFrom(data);
            if (sn != null && content.equals(sn.toString())) {
                return ZKUtil.deleteNode(zkw, zkw.getMasterAddressZNode(), stat.getVersion());
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Can't get or delete the master znode", (Throwable)e);
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Can't get or delete the master znode", (Throwable)e);
        }
        return false;
    }
}

