/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.values.TypeDescriptor;

public class BigQueryInsertErrorCoder
extends AtomicCoder<BigQueryInsertError> {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
    private static final BigQueryInsertErrorCoder INSTANCE = new BigQueryInsertErrorCoder();
    private static final TypeDescriptor<BigQueryInsertError> TYPE_DESCRIPTOR = new TypeDescriptor<BigQueryInsertError>(){};

    public static BigQueryInsertErrorCoder of() {
        return INSTANCE;
    }

    public void encode(BigQueryInsertError value, OutputStream outStream) throws IOException {
        String errorStrValue = MAPPER.writeValueAsString((Object)value.getError());
        StringUtf8Coder.of().encode(errorStrValue, outStream);
        TableRowJsonCoder.of().encode(value.getRow(), outStream);
        StringUtf8Coder.of().encode(BigQueryHelpers.toTableSpec(value.getTable()), outStream);
    }

    public BigQueryInsertError decode(InputStream inStream) throws IOException {
        TableDataInsertAllResponse.InsertErrors err = (TableDataInsertAllResponse.InsertErrors)MAPPER.readValue(StringUtf8Coder.of().decode(inStream), TableDataInsertAllResponse.InsertErrors.class);
        TableRow row = TableRowJsonCoder.of().decode(inStream);
        TableReference ref = BigQueryHelpers.parseTableSpec(StringUtf8Coder.of().decode(inStream));
        return new BigQueryInsertError(row, err, ref);
    }

    protected long getEncodedElementByteSize(BigQueryInsertError value) throws Exception {
        String errorStrValue = MAPPER.writeValueAsString((Object)value.getError());
        String tableStrValue = MAPPER.writeValueAsString((Object)value.getTable());
        return StringUtf8Coder.of().getEncodedElementByteSize(errorStrValue) + TableRowJsonCoder.of().getEncodedElementByteSize(value.getRow()) + StringUtf8Coder.of().getEncodedElementByteSize(tableStrValue);
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException((Coder)this, "TableRow can hold arbitrary instances, which may be non-deterministic.");
    }

    public TypeDescriptor<BigQueryInsertError> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

