/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ChildPartitionsRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.DataChangeRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.HeartbeatRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamResultSet;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.ChangeStreamRecordMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.PartitionMetadataMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartitionsRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.HeartbeatRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ThroughputEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryChangeStreamAction {
    private static final Logger LOG = LoggerFactory.getLogger(QueryChangeStreamAction.class);
    private static final Duration BUNDLE_FINALIZER_TIMEOUT = Duration.standardMinutes((long)5L);
    private static final String OUT_OF_RANGE_ERROR_MESSAGE = "Specified start_timestamp is invalid";
    private final ChangeStreamDao changeStreamDao;
    private final PartitionMetadataDao partitionMetadataDao;
    private final ChangeStreamRecordMapper changeStreamRecordMapper;
    private final PartitionMetadataMapper partitionMetadataMapper;
    private final DataChangeRecordAction dataChangeRecordAction;
    private final HeartbeatRecordAction heartbeatRecordAction;
    private final ChildPartitionsRecordAction childPartitionsRecordAction;
    private final ChangeStreamMetrics metrics;
    private final ThroughputEstimator throughputEstimator;

    QueryChangeStreamAction(ChangeStreamDao changeStreamDao, PartitionMetadataDao partitionMetadataDao, ChangeStreamRecordMapper changeStreamRecordMapper, PartitionMetadataMapper partitionMetadataMapper, DataChangeRecordAction dataChangeRecordAction, HeartbeatRecordAction heartbeatRecordAction, ChildPartitionsRecordAction childPartitionsRecordAction, ChangeStreamMetrics metrics, ThroughputEstimator throughputEstimator) {
        this.changeStreamDao = changeStreamDao;
        this.partitionMetadataDao = partitionMetadataDao;
        this.changeStreamRecordMapper = changeStreamRecordMapper;
        this.partitionMetadataMapper = partitionMetadataMapper;
        this.dataChangeRecordAction = dataChangeRecordAction;
        this.heartbeatRecordAction = heartbeatRecordAction;
        this.childPartitionsRecordAction = childPartitionsRecordAction;
        this.metrics = metrics;
        this.throughputEstimator = throughputEstimator;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public DoFn.ProcessContinuation run(PartitionMetadata partition, RestrictionTracker<TimestampRange, Timestamp> tracker, DoFn.OutputReceiver<DataChangeRecord> receiver, ManualWatermarkEstimator<Instant> watermarkEstimator, DoFn.BundleFinalizer bundleFinalizer) {
        String token = partition.getPartitionToken();
        Timestamp startTimestamp = ((TimestampRange)tracker.currentRestriction()).getFrom();
        Timestamp endTimestamp = partition.getEndTimestamp();
        PartitionMetadata updatedPartition = Optional.ofNullable(this.partitionMetadataDao.getPartition(token)).map(this.partitionMetadataMapper::from).orElseThrow(() -> new IllegalStateException("Partition " + token + " not found in metadata table"));
        try (ChangeStreamResultSet resultSet = this.changeStreamDao.changeStreamQuery(token, startTimestamp, endTimestamp, partition.getHeartbeatMillis());){
            this.metrics.incQueryCounter();
            while (resultSet.next()) {
                List<ChangeStreamRecord> records = this.changeStreamRecordMapper.toChangeStreamRecords(updatedPartition, resultSet.getCurrentRowAsStruct(), resultSet.getMetadata());
                for (ChangeStreamRecord record : records) {
                    Optional<DoFn.ProcessContinuation> maybeContinuation;
                    if (record instanceof DataChangeRecord) {
                        maybeContinuation = this.dataChangeRecordAction.run(updatedPartition, (DataChangeRecord)record, tracker, receiver, watermarkEstimator);
                    } else if (record instanceof HeartbeatRecord) {
                        maybeContinuation = this.heartbeatRecordAction.run(updatedPartition, (HeartbeatRecord)record, tracker, watermarkEstimator);
                    } else if (record instanceof ChildPartitionsRecord) {
                        maybeContinuation = this.childPartitionsRecordAction.run(updatedPartition, (ChildPartitionsRecord)record, tracker, watermarkEstimator);
                    } else {
                        LOG.error("[" + token + "] Unknown record type " + record.getClass());
                        throw new IllegalArgumentException("Unknown record type " + record.getClass());
                    }
                    this.throughputEstimator.update(Timestamp.now(), record.toString().getBytes(StandardCharsets.UTF_8).length);
                    if (!maybeContinuation.isPresent()) continue;
                    LOG.debug("[" + token + "] Continuation present, returning " + maybeContinuation);
                    bundleFinalizer.afterBundleCommit(Instant.now().plus((ReadableDuration)BUNDLE_FINALIZER_TIMEOUT), this.updateWatermarkCallback(token, (WatermarkEstimator<Instant>)watermarkEstimator));
                    DoFn.ProcessContinuation processContinuation = maybeContinuation.get();
                    return processContinuation;
                }
            }
            bundleFinalizer.afterBundleCommit(Instant.now().plus((ReadableDuration)BUNDLE_FINALIZER_TIMEOUT), this.updateWatermarkCallback(token, (WatermarkEstimator<Instant>)watermarkEstimator));
        }
        catch (SpannerException e) {
            if (this.isTimestampOutOfRange(e)) {
                LOG.debug("[" + token + "] query change stream is out of range for " + startTimestamp + " to " + endTimestamp + ", finishing stream");
            }
            throw e;
        }
        LOG.debug("[" + token + "] change stream completed successfully");
        if (tracker.tryClaim((Object)endTimestamp)) {
            LOG.debug("[" + token + "] Finishing partition");
            this.partitionMetadataDao.updateToFinished(token);
            this.metrics.decActivePartitionReadCounter();
            LOG.info("[" + token + "] Partition finished");
        }
        return DoFn.ProcessContinuation.stop();
    }

    private DoFn.BundleFinalizer.Callback updateWatermarkCallback(String token, WatermarkEstimator<Instant> watermarkEstimator) {
        return () -> {
            Instant watermark = watermarkEstimator.currentWatermark();
            LOG.debug("[" + token + "] Updating current watermark to " + watermark);
            try {
                this.partitionMetadataDao.updateWatermark(token, Timestamp.ofTimeMicroseconds((long)(watermark.getMillis() * 1000L)));
            }
            catch (SpannerException e) {
                if (e.getErrorCode() == ErrorCode.NOT_FOUND) {
                    LOG.debug("[" + token + "] Unable to update the current watermark, partition NOT FOUND");
                }
                LOG.error("[" + token + "] Error updating the current watermark: " + e.getMessage(), (Throwable)e);
            }
        };
    }

    private boolean isTimestampOutOfRange(SpannerException e) {
        return (e.getErrorCode() == ErrorCode.INVALID_ARGUMENT || e.getErrorCode() == ErrorCode.OUT_OF_RANGE) && e.getMessage() != null && e.getMessage().contains(OUT_OF_RANGE_ERROR_MESSAGE);
    }
}

