/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseDateTimeValue;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.TimeZone;

public class ClickHouseOffsetDateTimeValue
extends ClickHouseObjectValue<OffsetDateTime> {
    private final int scale;
    private final TimeZone tz;

    public static ClickHouseOffsetDateTimeValue ofNull(int scale, TimeZone tz) {
        return ClickHouseOffsetDateTimeValue.ofNull(null, scale, tz);
    }

    public static ClickHouseOffsetDateTimeValue ofNull(ClickHouseValue ref, int scale, TimeZone tz) {
        return ref instanceof ClickHouseOffsetDateTimeValue ? (ClickHouseOffsetDateTimeValue)((ClickHouseOffsetDateTimeValue)ref).set(null) : new ClickHouseOffsetDateTimeValue(null, scale, tz);
    }

    public static ClickHouseOffsetDateTimeValue of(LocalDateTime value, int scale, TimeZone tz) {
        return ClickHouseOffsetDateTimeValue.of(null, value, scale, tz);
    }

    public static ClickHouseOffsetDateTimeValue of(ClickHouseValue ref, LocalDateTime value, int scale, TimeZone tz) {
        OffsetDateTime v = null;
        if (value != null) {
            v = value.atZone(tz == null || tz.equals(ClickHouseValues.UTC_TIMEZONE) ? ClickHouseValues.UTC_ZONE : tz.toZoneId()).toOffsetDateTime();
        }
        return ref instanceof ClickHouseOffsetDateTimeValue ? (ClickHouseOffsetDateTimeValue)((ClickHouseOffsetDateTimeValue)ref).set(v) : new ClickHouseOffsetDateTimeValue(v, scale, tz);
    }

    protected ClickHouseOffsetDateTimeValue(OffsetDateTime value, int scale, TimeZone tz) {
        super(value);
        this.scale = ClickHouseChecker.between(scale, "scale", 0, 9);
        this.tz = tz == null || tz.equals(ClickHouseValues.UTC_TIMEZONE) ? ClickHouseValues.UTC_TIMEZONE : tz;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public ClickHouseOffsetDateTimeValue copy(boolean deep) {
        return new ClickHouseOffsetDateTimeValue((OffsetDateTime)this.getValue(), this.scale, this.tz);
    }

    @Override
    public byte asByte() {
        return this.isNullOrEmpty() ? (byte)0 : (byte)((OffsetDateTime)this.getValue()).toEpochSecond();
    }

    @Override
    public short asShort() {
        return this.isNullOrEmpty() ? (short)0 : (short)((OffsetDateTime)this.getValue()).toEpochSecond();
    }

    @Override
    public int asInteger() {
        return this.isNullOrEmpty() ? 0 : (int)((OffsetDateTime)this.getValue()).toEpochSecond();
    }

    @Override
    public long asLong() {
        return this.isNullOrEmpty() ? 0L : ((OffsetDateTime)this.getValue()).toEpochSecond();
    }

    @Override
    public float asFloat() {
        return this.isNullOrEmpty() ? 0.0f : (float)((OffsetDateTime)this.getValue()).toEpochSecond() + (float)((OffsetDateTime)this.getValue()).getNano() / ClickHouseValues.NANOS.floatValue();
    }

    @Override
    public double asDouble() {
        return this.isNullOrEmpty() ? 0.0 : (double)((OffsetDateTime)this.getValue()).toEpochSecond() + (double)((OffsetDateTime)this.getValue()).getNano() / ClickHouseValues.NANOS.doubleValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNullOrEmpty() ? null : BigInteger.valueOf(((OffsetDateTime)this.getValue()).toEpochSecond());
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        OffsetDateTime value = (OffsetDateTime)this.getValue();
        BigDecimal v = null;
        if (value != null) {
            int nanoSeconds = value.getNano();
            v = new BigDecimal(BigInteger.valueOf(value.toEpochSecond()), scale);
            if (scale != 0 && nanoSeconds != 0) {
                v = v.add(BigDecimal.valueOf(nanoSeconds).divide(ClickHouseValues.NANOS).setScale(scale, ClickHouseValues.ROUNDING_MODE));
            }
        }
        return v;
    }

    @Override
    public LocalDate asDate() {
        return this.isNullOrEmpty() ? null : this.asOffsetDateTime(0).toLocalDate();
    }

    @Override
    public LocalTime asTime(int scale) {
        return this.isNullOrEmpty() ? null : this.asOffsetDateTime(scale).toLocalTime();
    }

    @Override
    public LocalDateTime asDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ((OffsetDateTime)this.getValue()).toLocalDateTime();
    }

    @Override
    public Instant asInstant(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ((OffsetDateTime)this.getValue()).toInstant();
    }

    @Override
    public OffsetDateTime asOffsetDateTime(int scale) {
        return (OffsetDateTime)this.getValue();
    }

    @Override
    public ZonedDateTime asZonedDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ((OffsetDateTime)this.getValue()).toZonedDateTime();
    }

    @Override
    public Object asObject() {
        return this.getValue();
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        String str = this.asDateTime(this.scale).format(this.scale > 0 ? ClickHouseValues.DATETIME_FORMATTER : ClickHouseDateTimeValue.dateTimeFormatter);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.US_ASCII : charset), length);
        }
        return str;
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        return '\'' + this.asDateTime(this.scale).format(this.scale > 0 ? ClickHouseValues.DATETIME_FORMATTER : ClickHouseDateTimeValue.dateTimeFormatter) + '\'';
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(byte value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(short value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(int value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(long value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(float value) {
        return this.update(BigDecimal.valueOf(value));
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(double value) {
        return this.update(BigDecimal.valueOf(value));
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(BigInteger value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (this.scale == 0) {
            this.set(ClickHouseValues.convertToDateTime(new BigDecimal(value, 0), this.tz).toOffsetDateTime());
        } else {
            this.set(ClickHouseValues.convertToDateTime(new BigDecimal(value, this.scale), this.tz).toOffsetDateTime());
        }
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(BigDecimal value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            if (value.scale() != this.scale) {
                value = value.setScale(this.scale, ClickHouseValues.ROUNDING_MODE);
            }
            this.set(ClickHouseValues.convertToDateTime(value, this.tz).toOffsetDateTime());
        }
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(Enum<?> value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.ordinal()));
        }
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(LocalDate value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            LocalDateTime dateTime = LocalDateTime.of(value, LocalTime.MIN);
            this.set(this.tz != null ? dateTime.atZone(this.tz.toZoneId()).toOffsetDateTime() : dateTime.atOffset(ZoneOffset.UTC));
        }
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(LocalTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            LocalDateTime dateTime = LocalDateTime.of(LocalDate.now(), value);
            this.set(this.tz != null ? dateTime.atZone(this.tz.toZoneId()).toOffsetDateTime() : dateTime.atOffset(ZoneOffset.UTC));
        }
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(LocalDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(this.tz != null && !this.tz.equals(ClickHouseValues.UTC_TIMEZONE) ? value.atZone(this.tz.toZoneId()).toOffsetDateTime() : value.atOffset(ZoneOffset.UTC));
        }
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(Instant value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(OffsetDateTime.ofInstant(value, this.tz.toZoneId()));
        }
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(OffsetDateTime value) {
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(ZonedDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.toOffsetDateTime());
        }
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDateTime.parse(value, ClickHouseValues.DATETIME_FORMATTER).atZone(this.tz.toZoneId()).toOffsetDateTime());
        }
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.asOffsetDateTime(this.scale));
        }
        return this;
    }

    @Override
    public ClickHouseOffsetDateTimeValue update(Object value) {
        if (value instanceof OffsetDateTime) {
            this.set((OffsetDateTime)value);
        } else if (value instanceof String) {
            this.update((String)value);
        } else {
            super.update(value);
        }
        return this;
    }
}

