/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceupsert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformDialog;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;
import org.apache.hop.pipeline.transforms.salesforceupsert.SalesforceUpsertMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SalesforceUpsertDialog
extends SalesforceTransformDialog {
    private static final Class<?> PKG = SalesforceUpsertMeta.class;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] ciReturn;
    private TableView wReturn;
    private SalesforceUpsertMeta input;
    private LabelTextVar wUserName;
    private LabelTextVar wURL;
    private LabelTextVar wPassword;
    private TextVar wBatchSize;
    private ComboVar wModule;
    private CCombo wUpsertField;
    private TextVar wSalesforceIDFieldName;
    private boolean gotModule = false;
    private boolean getModulesListError = false;
    private Button wUseCompression;
    private TextVar wTimeOut;
    private Button wRollbackAllChangesOnError;
    private static List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private String[] moduleFields;

    public SalesforceUpsertDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, in, pipelineMeta, sname);
        this.input = (SalesforceUpsertMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.moduleFields = null;
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SalesforceUpsertDialog.this.input.setChanged();
                SalesforceUpsertDialog.this.moduleFields = null;
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.General.Tab", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wConnectionGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wConnectionGroup);
        wConnectionGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ConnectionGroup.Label", (String[])new String[0]));
        FormLayout connectionGroupLayout = new FormLayout();
        connectionGroupLayout.marginWidth = 10;
        connectionGroupLayout.marginHeight = 10;
        wConnectionGroup.setLayout((Layout)connectionGroupLayout);
        this.wURL = new LabelTextVar(this.variables, (Composite)wConnectionGroup, BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.URL.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.URL.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wURL);
        this.wURL.addModifyListener(lsMod);
        FormData fdURL = new FormData();
        fdURL.left = new FormAttachment(0, 0);
        fdURL.top = new FormAttachment((Control)this.wTransformName, margin);
        fdURL.right = new FormAttachment(100, 0);
        this.wURL.setLayoutData((Object)fdURL);
        this.wUserName = new LabelTextVar(this.variables, (Composite)wConnectionGroup, BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.User.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.User.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wUserName);
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(0, 0);
        fdUserName.top = new FormAttachment((Control)this.wURL, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
        this.wPassword = new LabelTextVar(this.variables, (Composite)wConnectionGroup, BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.Password.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.Password.Tooltip", (String[])new String[0]), true);
        this.props.setLook((Control)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(0, 0);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        Button wTest = new Button((Composite)wConnectionGroup, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.TestConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wPassword, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        FormData fdConnectionGroup = new FormData();
        fdConnectionGroup.left = new FormAttachment(0, margin);
        fdConnectionGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdConnectionGroup.right = new FormAttachment(100, -margin);
        wConnectionGroup.setLayoutData((Object)fdConnectionGroup);
        Group wSettingsGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wSettingsGroup);
        wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.SettingsGroup.Label", (String[])new String[0]));
        FormLayout settingGroupLayout = new FormLayout();
        settingGroupLayout.marginWidth = 10;
        settingGroupLayout.marginHeight = 10;
        wSettingsGroup.setLayout((Layout)settingGroupLayout);
        Label wlTimeOut = new Label((Composite)wSettingsGroup, 131072);
        wlTimeOut.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.TimeOut.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTimeOut);
        FormData fdlTimeOut = new FormData();
        fdlTimeOut.left = new FormAttachment(0, 0);
        fdlTimeOut.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdlTimeOut.right = new FormAttachment(middle, -margin);
        wlTimeOut.setLayoutData((Object)fdlTimeOut);
        this.wTimeOut = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        this.props.setLook((Control)this.wTimeOut);
        this.wTimeOut.addModifyListener(lsMod);
        FormData fdTimeOut = new FormData();
        fdTimeOut.left = new FormAttachment(middle, 0);
        fdTimeOut.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdTimeOut.right = new FormAttachment(100, 0);
        this.wTimeOut.setLayoutData((Object)fdTimeOut);
        Label wlUseCompression = new Label((Composite)wSettingsGroup, 131072);
        wlUseCompression.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.UseCompression.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUseCompression);
        FormData fdlUseCompression = new FormData();
        fdlUseCompression.left = new FormAttachment(0, 0);
        fdlUseCompression.top = new FormAttachment((Control)this.wTimeOut, margin);
        fdlUseCompression.right = new FormAttachment(middle, -margin);
        wlUseCompression.setLayoutData((Object)fdlUseCompression);
        this.wUseCompression = new Button((Composite)wSettingsGroup, 32);
        this.props.setLook((Control)this.wUseCompression);
        this.wUseCompression.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.UseCompression.Tooltip", (String[])new String[0]));
        FormData fdUseCompression = new FormData();
        fdUseCompression.left = new FormAttachment(middle, 0);
        fdUseCompression.top = new FormAttachment((Control)wlUseCompression, 0, 0x1000000);
        this.wUseCompression.setLayoutData((Object)fdUseCompression);
        this.wUseCompression.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlRollbackAllChangesOnError = new Label((Composite)wSettingsGroup, 131072);
        wlRollbackAllChangesOnError.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.RollbackAllChangesOnError.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRollbackAllChangesOnError);
        FormData fdlRollbackAllChangesOnError = new FormData();
        fdlRollbackAllChangesOnError.left = new FormAttachment(0, 0);
        fdlRollbackAllChangesOnError.top = new FormAttachment((Control)this.wUseCompression, margin);
        fdlRollbackAllChangesOnError.right = new FormAttachment(middle, -margin);
        wlRollbackAllChangesOnError.setLayoutData((Object)fdlRollbackAllChangesOnError);
        this.wRollbackAllChangesOnError = new Button((Composite)wSettingsGroup, 32);
        this.wRollbackAllChangesOnError.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        this.props.setLook((Control)this.wRollbackAllChangesOnError);
        this.wRollbackAllChangesOnError.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.RollbackAllChangesOnError.Tooltip", (String[])new String[0]));
        FormData fdRollbackAllChangesOnError = new FormData();
        fdRollbackAllChangesOnError.left = new FormAttachment(middle, 0);
        fdRollbackAllChangesOnError.top = new FormAttachment((Control)wlRollbackAllChangesOnError, 0, 0x1000000);
        this.wRollbackAllChangesOnError.setLayoutData((Object)fdRollbackAllChangesOnError);
        Label wlBatchSize = new Label((Composite)wSettingsGroup, 131072);
        wlBatchSize.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.Limit.Label", (String[])new String[0]));
        this.props.setLook((Control)wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.top = new FormAttachment((Control)this.wRollbackAllChangesOnError, margin);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        this.props.setLook((Control)this.wBatchSize);
        this.wBatchSize.addModifyListener(lsMod);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(middle, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wRollbackAllChangesOnError, margin);
        fdBatchSize.right = new FormAttachment(100, 0);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        Label wlModule = new Label((Composite)wSettingsGroup, 131072);
        wlModule.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.Module.Label", (String[])new String[0]));
        this.props.setLook((Control)wlModule);
        FormData fdlModule = new FormData();
        fdlModule.left = new FormAttachment(0, 0);
        fdlModule.top = new FormAttachment((Control)this.wBatchSize, margin);
        fdlModule.right = new FormAttachment(middle, -margin);
        wlModule.setLayoutData((Object)fdlModule);
        this.wModule = new ComboVar(this.variables, (Composite)wSettingsGroup, 2060);
        this.wModule.setEditable(true);
        this.props.setLook((Control)this.wModule);
        this.wModule.addModifyListener(lsTableMod);
        this.wModule.addSelectionListener((SelectionListener)lsSelection);
        FormData fdModule = new FormData();
        fdModule.left = new FormAttachment(middle, 0);
        fdModule.top = new FormAttachment((Control)this.wBatchSize, margin);
        fdModule.right = new FormAttachment(100, -margin);
        this.wModule.setLayoutData((Object)fdModule);
        this.wModule.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (SalesforceUpsertDialog.this.skipFetchModules()) {
                    SalesforceUpsertDialog.this.getModulesListError = false;
                    return;
                }
                Cursor busy = new Cursor((Device)SalesforceUpsertDialog.this.shell.getDisplay(), 1);
                SalesforceUpsertDialog.this.shell.setCursor(busy);
                SalesforceUpsertDialog.this.getModulesList();
                SalesforceUpsertDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlUpsertField = new Label((Composite)wSettingsGroup, 131072);
        wlUpsertField.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.Upsert.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUpsertField);
        FormData fdlUpsertField = new FormData();
        fdlUpsertField.left = new FormAttachment(0, 0);
        fdlUpsertField.top = new FormAttachment((Control)this.wModule, margin);
        fdlUpsertField.right = new FormAttachment(middle, -margin);
        wlUpsertField.setLayoutData((Object)fdlUpsertField);
        this.wUpsertField = new CCombo((Composite)wSettingsGroup, 2060);
        this.wUpsertField.setEditable(true);
        this.props.setLook((Control)this.wUpsertField);
        this.wUpsertField.addModifyListener(lsMod);
        FormData fdUpsertField = new FormData();
        fdUpsertField.left = new FormAttachment(middle, 0);
        fdUpsertField.top = new FormAttachment((Control)this.wModule, margin);
        fdUpsertField.right = new FormAttachment(100, -margin);
        this.wUpsertField.setLayoutData((Object)fdUpsertField);
        this.wUpsertField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                SalesforceUpsertDialog.this.getFieldsList();
            }
        });
        FormData fdSettingsGroup = new FormData();
        fdSettingsGroup.left = new FormAttachment(0, margin);
        fdSettingsGroup.top = new FormAttachment((Control)wConnectionGroup, margin);
        fdSettingsGroup.right = new FormAttachment(100, -margin);
        wSettingsGroup.setLayoutData((Object)fdSettingsGroup);
        Group wOutFieldsGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wOutFieldsGroup);
        wOutFieldsGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.OutFieldsGroup.Label", (String[])new String[0]));
        FormLayout outFieldsGroupLayout = new FormLayout();
        outFieldsGroupLayout.marginWidth = 10;
        outFieldsGroupLayout.marginHeight = 10;
        wOutFieldsGroup.setLayout((Layout)outFieldsGroupLayout);
        Label wlSalesforceIDFieldName = new Label((Composite)wOutFieldsGroup, 131072);
        wlSalesforceIDFieldName.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.SalesforceIDFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSalesforceIDFieldName);
        FormData fdlSalesforceIDFieldName = new FormData();
        fdlSalesforceIDFieldName.left = new FormAttachment(0, 0);
        fdlSalesforceIDFieldName.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdlSalesforceIDFieldName.right = new FormAttachment(middle, -margin);
        wlSalesforceIDFieldName.setLayoutData((Object)fdlSalesforceIDFieldName);
        this.wSalesforceIDFieldName = new TextVar(this.variables, (Composite)wOutFieldsGroup, 18436);
        this.props.setLook((Control)this.wSalesforceIDFieldName);
        this.wSalesforceIDFieldName.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.SalesforceIDFieldName.Tooltip", (String[])new String[0]));
        this.wSalesforceIDFieldName.addModifyListener(lsMod);
        FormData fdSalesforceIDFieldName = new FormData();
        fdSalesforceIDFieldName.left = new FormAttachment(middle, 0);
        fdSalesforceIDFieldName.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdSalesforceIDFieldName.right = new FormAttachment(100, 0);
        this.wSalesforceIDFieldName.setLayoutData((Object)fdSalesforceIDFieldName);
        FormData fdOutFieldsGroup = new FormData();
        fdOutFieldsGroup.left = new FormAttachment(0, margin);
        fdOutFieldsGroup.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdOutFieldsGroup.right = new FormAttachment(100, -margin);
        wOutFieldsGroup.setLayoutData((Object)fdOutFieldsGroup);
        Label wlReturn = new Label(wGeneralComp, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.UpdateFields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)wOutFieldsGroup, margin);
        wlReturn.setLayoutData((Object)fdlReturn);
        int upInsCols = 3;
        int upInsRows = this.input.getUpdateLookup() != null ? this.input.getUpdateLookup().length : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ColumnInfo.UseExternalId", (String[])new String[0]), 2, new String[]{"Y", "N"});
        this.ciReturn[2].setToolTip(BaseMessages.getString(PKG, (String)"SalesforceUpdateDialog.ColumnInfo.UseExternalId.Tooltip", (String[])new String[0]));
        tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView(this.variables, wGeneralComp, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        this.wReturn.getTable().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SalesforceUpsertDialog.this.setModuleFieldCombo();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        Button wDoMapping = new Button(wGeneralComp, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)wlReturn, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        wDoMapping.addListener(13, arg0 -> this.generateMappings());
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)wlReturn, margin);
        fdReturn.right = new FormAttachment((Control)wDoMapping, -margin);
        fdReturn.bottom = new FormAttachment(100, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        Button wGetLU = new Button(wGeneralComp, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.GetAndUpdateFields.Label", (String[])new String[0]));
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)wDoMapping, margin);
        fdGetLU.left = new FormAttachment((Control)this.wReturn, margin);
        fdGetLU.right = new FormAttachment(100, 0);
        wGetLU.setLayoutData((Object)fdGetLU);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                    Display.getDefault().asyncExec(() -> {
                        if (!this.wReturn.isDisposed()) {
                            for (int i = 0; i < this.wReturn.table.getItemCount(); ++i) {
                                TableItem it = this.wReturn.table.getItem(i);
                                if (Utils.isEmpty((CharSequence)it.getText(2)) || this.inputFields.containsKey(it.getText(2))) continue;
                                it.setBackground(GuiResource.getInstance().getColorRed());
                            }
                        }
                    });
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wOk.addListener(13, e -> this.ok());
        wGetLU.addListener(13, e -> this.getUpdate());
        wTest.addListener(13, e -> this.test());
        this.wCancel.addListener(13, e -> this.cancel());
        wTabFolder.setSelection(0);
        this.getData(this.input);
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(3, "Y");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getFieldsList() {
        try {
            String selectedField = this.wUpsertField.getText();
            this.wUpsertField.removeAll();
            this.wUpsertField.setItems(this.getModuleFields());
            if (!Utils.isEmpty((CharSequence)selectedField)) {
                this.wUpsertField.setText(selectedField);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ErrorRetrieveModules.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ErrorRetrieveData.ErrorRetrieveModules", (String[])new String[0]), e);
        }
    }

    public void getData(SalesforceUpsertMeta in) {
        this.wURL.setText(Const.NVL((String)in.getTargetUrl(), (String)""));
        this.wUserName.setText(Const.NVL((String)in.getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)in.getPassword(), (String)""));
        this.wBatchSize.setText(in.getBatchSize());
        this.wModule.setText(Const.NVL((String)in.getModule(), (String)"Account"));
        this.wUpsertField.setText(Const.NVL((String)in.getUpsertField(), (String)"Id"));
        this.wBatchSize.setText(in.getBatchSize());
        this.wSalesforceIDFieldName.setText(Const.NVL((String)in.getSalesforceIDFieldName(), (String)""));
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        }
        if (this.input.getUpdateLookup() != null) {
            for (int i = 0; i < this.input.getUpdateLookup().length; ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getUpdateLookup()[i] != null) {
                    item.setText(1, this.input.getUpdateLookup()[i]);
                }
                if (this.input.getUpdateStream()[i] != null) {
                    item.setText(2, this.input.getUpdateStream()[i]);
                }
                if (this.input.getUseExternalId()[i] == null || this.input.getUseExternalId()[i].booleanValue()) {
                    item.setText(3, "Y");
                    continue;
                }
                item.setText(3, "N");
            }
        }
        this.wReturn.removeEmptyRows();
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTimeOut.setText(Const.NVL((String)in.getTimeout(), (String)"60000"));
        this.wUseCompression.setSelection(in.isCompression());
        this.wRollbackAllChangesOnError.setSelection(in.isRollbackAllChangesOnError());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ErrorValidateData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ErrorValidateData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    @Override
    protected void getInfo(SalesforceTransformMeta in) throws HopException {
        SalesforceUpsertMeta meta = (SalesforceUpsertMeta)in;
        this.transformName = this.wTransformName.getText();
        meta.setTargetUrl(Const.NVL((String)this.wURL.getText(), (String)"https://login.salesforce.com/services/Soap/u/50.0"));
        meta.setUsername(this.wUserName.getText());
        meta.setPassword(this.wPassword.getText());
        meta.setModule(Const.NVL((String)this.wModule.getText(), (String)"Account"));
        meta.setUpsertField(Const.NVL((String)this.wUpsertField.getText(), (String)"Id"));
        meta.setSalesforceIDFieldName(this.wSalesforceIDFieldName.getText());
        meta.setBatchSize(this.wBatchSize.getText());
        int nrFields = this.wReturn.nrNonEmpty();
        meta.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            meta.getUpdateLookup()[i] = item.getText(1);
            meta.getUpdateStream()[i] = item.getText(2);
            meta.getUseExternalId()[i] = "Y".equals(item.getText(3));
        }
        meta.setCompression(this.wUseCompression.getSelection());
        meta.setTimeout(Const.NVL((String)this.wTimeOut.getText(), (String)"0"));
        meta.setRollbackAllChangesOnError(this.wRollbackAllChangesOnError.getSelection());
    }

    private boolean checkInput() {
        if (Utils.isEmpty((CharSequence)this.wModule.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ModuleMissing.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
            return false;
        }
        return this.checkUser();
    }

    private boolean checkUser() {
        if (Utils.isEmpty((CharSequence)this.wUserName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.UsernameMissing.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getModuleFields() throws HopException {
        if (this.moduleFields != null) {
            return this.moduleFields;
        }
        if (this.skipFetchModules() || Utils.isEmpty((CharSequence)this.wModule.getText())) {
            this.getModulesListError = false;
            return new String[0];
        }
        this.getModulesListError = true;
        SalesforceUpsertMeta meta = new SalesforceUpsertMeta();
        this.getInfo(meta);
        String url = this.variables.resolve(meta.getTargetUrl());
        String selectedModule = this.variables.resolve(meta.getModule());
        SalesforceConnection connection = new SalesforceConnection((ILogChannel)this.log, url, this.variables.resolve(meta.getUsername()), Utils.resolvePassword((IVariables)this.variables, (String)meta.getPassword()));
        int realTimeOut = Const.toInt((String)this.variables.resolve(meta.getTimeout()), (int)0);
        connection.setTimeOut(realTimeOut);
        Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
        try {
            this.shell.setCursor(busy);
            connection.connect();
            boolean excludeNonUpdatableFields = true;
            this.moduleFields = connection.getFields(selectedModule, excludeNonUpdatableFields);
            this.getModulesListError = false;
            String[] stringArray = this.moduleFields;
            return stringArray;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            this.shell.setCursor(null);
            busy.dispose();
        }
    }

    private boolean skipFetchModules() {
        return Utils.isEmpty((CharSequence)this.wURL.getText()) || Utils.isEmpty((CharSequence)this.wUserName.getText()) || Utils.isEmpty((CharSequence)this.wPassword.getText()) || this.getModulesListError;
    }

    private void generateMappings() {
        EnterMappingDialog d;
        int i;
        IRowMeta sourceFields;
        if (!this.checkInput()) {
            return;
        }
        RowMeta targetFields = new RowMeta();
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        try {
            String[] fields = this.getModuleFields();
            for (i = 0; i < fields.length; ++i) {
                targetFields.addValueMeta((IValueMeta)new ValueMetaNone(fields[i]));
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), e);
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i2 = 0; i2 < nrFields; ++i2) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i2);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)292);
            boolean bl = goOn = (answer & 0x20) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i3 = 0; i3 < mappings.size(); ++i3) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i3);
                TableItem item = this.wReturn.table.getItem(i3);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getModulesList() {
        if (!this.gotModule) {
            SalesforceConnection connection = null;
            try {
                SalesforceUpsertMeta meta = new SalesforceUpsertMeta();
                this.getInfo(meta);
                String url = this.variables.resolve(meta.getTargetUrl());
                String selectedField = this.wModule.getText();
                this.wModule.removeAll();
                connection = new SalesforceConnection((ILogChannel)this.log, url, this.variables.resolve(meta.getUsername()), Utils.resolvePassword((IVariables)this.variables, (String)meta.getPassword()));
                connection.connect();
                this.wModule.setItems(connection.getAllAvailableObjects(false));
                if (!Utils.isEmpty((CharSequence)selectedField)) {
                    this.wModule.setText(selectedField);
                }
                this.gotModule = true;
                this.getModulesListError = false;
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ErrorRetrieveModules.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ErrorRetrieveData.ErrorRetrieveModules", (String[])new String[0]), e);
                this.getModulesListError = true;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void setModuleFieldCombo() {
        block6: {
            for (int i = 0; i < tableFieldColumns.size(); ++i) {
                ColumnInfo colInfo = tableFieldColumns.get(i);
                colInfo.setComboValues(new String[0]);
            }
            String selectedModule = this.variables.resolve(this.wModule.getText());
            if (!Utils.isEmpty((CharSequence)selectedModule)) {
                try {
                    String[] fieldsName = this.getModuleFields();
                    if (fieldsName == null) break block6;
                    for (int i = 0; i < tableFieldColumns.size(); ++i) {
                        ColumnInfo colInfo = tableFieldColumns.get(i);
                        colInfo.setComboValues(fieldsName);
                    }
                }
                catch (Exception e) {
                    for (int i = 0; i < tableFieldColumns.size(); ++i) {
                        ColumnInfo colInfo = tableFieldColumns.get(i);
                        colInfo.setComboValues(new String[0]);
                    }
                }
            }
        }
    }
}

