/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDTrace;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

class AS400JDBCWriter
extends Writer {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private boolean closed_ = false;
    private long position_;
    private AS400JDBCClob clob_;
    private AS400JDBCClobLocator locator_;
    private AS400JDBCSQLXML xml_;

    AS400JDBCWriter(AS400JDBCClob aS400JDBCClob, long l) {
        this.clob_ = aS400JDBCClob;
        this.position_ = l;
    }

    AS400JDBCWriter(AS400JDBCClobLocator aS400JDBCClobLocator, long l) {
        this.locator_ = aS400JDBCClobLocator;
        this.position_ = l;
    }

    AS400JDBCWriter(AS400JDBCSQLXML aS400JDBCSQLXML, long l) {
        this.xml_ = aS400JDBCSQLXML;
        this.position_ = l;
    }

    public void close() {
        this.closed_ = true;
    }

    public void flush() {
    }

    public void write(char[] cArray) throws IOException {
        if (cArray == null) {
            throw new NullPointerException("cbuf");
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new NullPointerException("cbuf");
        }
        if (n < 0 || n > n2) {
            throw new ExtendedIllegalArgumentException("off", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("len", 2);
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        this.write(new String(cArray, n, n2));
    }

    public void write(int n) throws IOException {
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        this.write(new String(new char[]{(char)n}));
    }

    public void write(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("str");
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        this.write(string, 0, string.length());
    }

    public synchronized void write(String string, int n, int n2) throws IOException {
        if (string == null) {
            throw new NullPointerException("str");
        }
        if (n < 0 || n > n2) {
            throw new ExtendedIllegalArgumentException("off", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("len", 2);
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        try {
            if (this.clob_ != null) {
                this.clob_.setString(this.position_, string, n, n2);
            } else if (this.locator_ != null) {
                this.locator_.setString(this.position_, string, n, n2);
            } else if (this.xml_ != null) {
                this.xml_.setString(this.position_, string, n, n2);
            }
            this.position_ += (long)n2;
        }
        catch (SQLException sQLException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(this, "Exception caught", sQLException);
            }
            this.closed_ = true;
            IOException iOException = new IOException(sQLException.getMessage());
            try {
                iOException.initCause(sQLException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
    }
}

