/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;

class RetryInputStream
extends FilterInputStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final int exceptionThreshold_ = 3;

    public RetryInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        int n = 0;
        while (true) {
            try {
                return super.read();
            }
            catch (SocketException socketException) {
                if (!Trace.isTraceOn()) continue;
                Trace.log(2, "Socket closed prematurely, let's try again", (Throwable)socketException);
                if (++n < 3) continue;
                throw socketException;
            }
            break;
        }
    }

    public int read(byte[] byArray) throws IOException {
        int n = 0;
        while (true) {
            try {
                return super.read(byArray);
            }
            catch (SocketException socketException) {
                if (!Trace.isTraceOn()) continue;
                Trace.log(2, "Socket closed prematurely, let's try again", (Throwable)socketException);
                if (++n < 3) continue;
                throw socketException;
            }
            break;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (true) {
            try {
                return super.read(byArray, n, n2);
            }
            catch (SocketException socketException) {
                if (!Trace.isTraceOn()) continue;
                Trace.log(2, "Socket closed prematurely, let's try again", (Throwable)socketException);
                if (++n3 < 3) continue;
                throw socketException;
            }
            break;
        }
    }
}

