/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.servlet;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.http.HttpServer;
import org.apache.hive.service.server.HS2ActivePassiveHARegistry;
import org.apache.hive.service.server.HS2ActivePassiveHARegistryClient;
import org.apache.hive.service.server.HiveServer2Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HS2Peers
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HS2Peers.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletContext context = this.getServletContext();
        if (!HttpServer.isInstrumentationAccessAllowed((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response)) {
            LOG.warn("Unauthorized to perform GET action. remoteUser: {}", (Object)request.getRemoteUser());
            return;
        }
        response.setContentType("application/json; charset=utf8");
        response.setHeader("Access-Control-Allow-Methods", "GET");
        response.setHeader("Access-Control-Allow-Origin", "*");
        ServletContext ctx = this.getServletContext();
        HiveConf hiveConf = (HiveConf)ctx.getAttribute("hiveconf");
        HS2ActivePassiveHARegistry hs2Registry = HS2ActivePassiveHARegistryClient.getClient((Configuration)hiveConf);
        HS2Instances instances = new HS2Instances(hs2Registry.getAll());
        response.getWriter().write(instances.toJson());
        response.setStatus(200);
        response.flushBuffer();
    }

    public static class HS2Instances {
        private Collection<HiveServer2Instance> hiveServer2Instances;

        public HS2Instances() {
        }

        public HS2Instances(Collection<HiveServer2Instance> hiveServer2Instances) {
            this.hiveServer2Instances = hiveServer2Instances;
        }

        public Collection<HiveServer2Instance> getHiveServer2Instances() {
            return this.hiveServer2Instances;
        }

        public void setHiveServer2Instances(Collection<HiveServer2Instance> hiveServer2Instances) {
            this.hiveServer2Instances = hiveServer2Instances;
        }

        @JsonIgnore
        public String toJson() throws IOException {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
    }
}

