/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import java.util.List;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.Rectangle;

public class AreaOwner<Parent, Owner> {
    private Rectangle area;
    private Parent parent;
    private Owner owner;
    private AreaType areaType;

    public AreaOwner(AreaType areaType, int x, int y, int width, int height, Point offset, Parent parent, Owner owner) {
        this.areaType = areaType;
        this.area = new Rectangle(x - offset.x, y - offset.y, width, height);
        this.parent = parent;
        this.owner = owner;
    }

    public AreaOwner(AreaOwner<Parent, Owner> o) {
        this.areaType = o.areaType;
        this.area = new Rectangle(o.area);
        this.parent = o.parent;
        this.owner = o.owner;
    }

    public boolean contains(int x, int y) {
        return this.area.contains(x, y);
    }

    public int getCentreX() {
        return this.area.x + this.area.width / 2;
    }

    public int getCentreY() {
        return this.area.y + this.area.height / 2;
    }

    public double distanceTo(AreaOwner o) {
        int distX = this.getCentreX() - o.getCentreX();
        int distY = this.getCentreY() - o.getCentreY();
        return Math.sqrt(distX * distX + distY * distY);
    }

    public static synchronized <Owner, Parent> AreaOwner<Owner, Parent> getVisibleAreaOwner(List<AreaOwner<Owner, Parent>> areaOwners, int x, int y) {
        for (int i = areaOwners.size() - 1; i >= 0; --i) {
            AreaOwner<Owner, Parent> areaOwner = areaOwners.get(i);
            if (!areaOwner.contains(x, y)) continue;
            return areaOwner;
        }
        return null;
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void setArea(Rectangle area) {
        this.area = area;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public Parent getParent() {
        return this.parent;
    }

    public void setParent(Parent parent) {
        this.parent = parent;
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
    }

    public static enum AreaType {
        NOTE,
        TRANSFORM_PARTITIONING,
        TRANSFORM_ICON,
        TRANSFORM_NAME,
        TRANSFORM_INFO_ICON,
        TRANSFORM_FAILURE_ICON,
        TRANSFORM_INPUT_HOP_ICON,
        TRANSFORM_OUTPUT_HOP_ICON,
        TRANSFORM_INFO_HOP_ICON,
        TRANSFORM_ERROR_HOP_ICON,
        TRANSFORM_TARGET_HOP_ICON,
        HOP_COPY_ICON,
        ROW_DISTRIBUTION_ICON,
        HOP_ERROR_ICON,
        HOP_INFO_ICON,
        HOP_INFO_TRANSFORM_COPIES_ERROR,
        HOP_INFO_TRANSFORMS_PARTITIONED,
        TRANSFORM_TARGET_HOP_ICON_OPTION,
        TRANSFORM_EDIT_ICON,
        TRANSFORM_MENU_ICON,
        TRANSFORM_COPIES_TEXT,
        TRANSFORM_DATA_SERVICE,
        ACTION_ICON,
        ACTION_NAME,
        ACTION_INFO_ICON,
        WORKFLOW_HOP_ICON,
        WORKFLOW_HOP_PARALLEL_ICON,
        ACTION_BUSY,
        ACTION_RESULT_SUCCESS,
        ACTION_RESULT_FAILURE,
        ACTION_RESULT_CHECKPOINT,
        TRANSFORM_INJECT_ICON,
        TRANSFORM_OUTPUT_DATA,
        CUSTOM;

    }
}

