/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.remote;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionInfoLocationTypeMetadata;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.IExecutionMatcher;
import org.apache.hop.execution.plugin.ExecutionInfoLocationPlugin;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.engines.remote.HopServerTypeMetadata;
import org.apache.hop.server.HopServer;
import org.apache.hop.www.GetExecutionInfoServlet;
import org.apache.http.client.utils.URIBuilder;

@GuiPlugin(description="File execution information location GUI elements")
@ExecutionInfoLocationPlugin(id="remote-location", name="Remote location", description="Stores execution information on a remote Hop server")
public class RemoteExecutionInfoLocation
implements IExecutionInfoLocation {
    @HopMetadataProperty
    protected String pluginId;
    @HopMetadataProperty
    protected String pluginName;
    @GuiWidgetElement(id="hopServer", order="010", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.METADATA, typeMetadata=HopServerTypeMetadata.class, toolTip="i18n::RemoteExecutionInfoLocation.HopServer.Tooltip", label="i18n::RemoteExecutionInfoLocation.HopServer.Label")
    @HopMetadataProperty(key="server")
    protected String serverName;
    @GuiWidgetElement(id="location", order="020", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.METADATA, typeMetadata=ExecutionInfoLocationTypeMetadata.class, toolTip="i18n::RemoteExecutionInfoLocation.LocationName.Tooltip", label="i18n::RemoteExecutionInfoLocation.LocationName.Label")
    @HopMetadataProperty(key="location")
    protected String locationName;
    private HopServer server;
    private ExecutionInfoLocation location;
    private IVariables variables;

    public RemoteExecutionInfoLocation() {
    }

    public RemoteExecutionInfoLocation(RemoteExecutionInfoLocation location) {
        this.pluginId = location.pluginId;
        this.pluginName = location.pluginName;
        this.serverName = location.serverName;
        this.locationName = location.locationName;
    }

    @Override
    public RemoteExecutionInfoLocation clone() {
        return new RemoteExecutionInfoLocation(this);
    }

    @Override
    public void initialize(IVariables variables, IHopMetadataProvider metadataProvider) throws HopException {
        this.variables = variables;
        try {
            if (StringUtils.isNotEmpty((String)this.serverName)) {
                this.server = (HopServer)metadataProvider.getSerializer(HopServer.class).load(variables.resolve(this.serverName));
            }
            if (StringUtils.isNotEmpty((String)this.locationName)) {
                this.location = (ExecutionInfoLocation)metadataProvider.getSerializer(ExecutionInfoLocation.class).load(variables.resolve(this.locationName));
            }
            this.validateSettings();
        }
        catch (Exception e) {
            throw new HopException("Error initializing remote execution information location", (Throwable)e);
        }
    }

    @Override
    public void close() throws HopException {
        if (this.location != null) {
            this.location.getExecutionInfoLocation().close();
        }
    }

    private String getJson(Object object) throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString(object);
    }

    private void validateSettings() throws HopException {
        if (this.server == null) {
            throw new HopException("Please specify a Hop server to send execution information to.");
        }
        if (this.location == null) {
            throw new HopException("Please specify an execution information location (on the Hop server) to send execution information to.");
        }
    }

    @Override
    public void registerExecution(Execution execution) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/registerExecInfo").addParameter("type", "execution").addParameter("location", this.location.getName()).build();
            this.server.sendJson(this.variables, uri.toString(), this.getJson(execution));
        }
        catch (Exception e) {
            throw new HopException("Error registering execution at remote location", (Throwable)e);
        }
    }

    @Override
    public boolean deleteExecution(String executionId) throws HopException {
        try {
            URI uri = new URIBuilder("/hop/registerExecInfo").addParameter("type", "execution").addParameter("location", this.location.getName()).build();
            this.validateSettings();
            return false;
        }
        catch (Exception e) {
            throw new HopException("Error deleting execution at remote location", (Throwable)e);
        }
    }

    @Override
    public void updateExecutionState(ExecutionState executionState) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/registerExecInfo").addParameter("type", "state").addParameter("location", this.location.getName()).build();
            this.server.sendJson(this.variables, this.getJson(executionState), uri.toString());
        }
        catch (Exception e) {
            throw new HopException("Error registering execution state at remote location", (Throwable)e);
        }
    }

    @Override
    public void registerData(ExecutionData data) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/registerExecInfo").addParameter("type", "data").addParameter("location", this.location.getName()).build();
            this.server.sendJson(this.variables, this.getJson(data), uri.toString());
        }
        catch (Exception e) {
            throw new HopException("Error registering execution data at remote location", (Throwable)e);
        }
    }

    @Override
    public List<String> getExecutionIds(boolean includeChildren, int limit) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/getExecInfo").addParameter("type", GetExecutionInfoServlet.Type.ids.name()).addParameter("location", this.location.getName()).addParameter("children", includeChildren ? "Y" : "N").addParameter("limit", Integer.toString(limit)).build();
            String json = this.server.execService(this.variables, uri.toString());
            String[] ids = (String[])new ObjectMapper().readValue(json, String[].class);
            return Arrays.asList(ids);
        }
        catch (Exception e) {
            throw new HopException("Error get execution IDs from remote location", (Throwable)e);
        }
    }

    @Override
    public Execution getExecution(String executionId) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/getExecInfo").addParameter("type", GetExecutionInfoServlet.Type.execution.name()).addParameter("location", this.location.getName()).addParameter("id", executionId).build();
            String json = this.server.execService(this.variables, uri.toString());
            Execution execution = (Execution)new ObjectMapper().readValue(json, Execution.class);
            return execution;
        }
        catch (Exception e) {
            throw new HopException("Error getting execution from remote location", (Throwable)e);
        }
    }

    @Override
    public ExecutionState getExecutionState(String executionId) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/getExecInfo").addParameter("type", GetExecutionInfoServlet.Type.state.name()).addParameter("location", this.location.getName()).addParameter("id", executionId).build();
            String json = this.server.execService(this.variables, uri.toString());
            ExecutionState executionState = (ExecutionState)new ObjectMapper().readValue(json, ExecutionState.class);
            return executionState;
        }
        catch (Exception e) {
            throw new HopException("Error getting execution state from remote location", (Throwable)e);
        }
    }

    @Override
    public List<Execution> findExecutions(String parentExecutionId) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/getExecInfo").addParameter("type", GetExecutionInfoServlet.Type.children.name()).addParameter("location", this.location.getName()).addParameter("id", parentExecutionId).build();
            String json = this.server.execService(this.variables, uri.toString());
            Execution[] executions = (Execution[])new ObjectMapper().readValue(json, Execution[].class);
            return Arrays.asList(executions);
        }
        catch (Exception e) {
            throw new HopException("Error getting execution state from remote location", (Throwable)e);
        }
    }

    @Override
    public List<Execution> findExecutions(IExecutionMatcher matcher) throws HopException {
        try {
            ArrayList<Execution> executions = new ArrayList<Execution>();
            for (String id : this.getExecutionIds(true, 0)) {
                Execution execution = this.getExecution(id);
                if (!matcher.matches(execution)) continue;
                executions.add(execution);
            }
            return executions;
        }
        catch (Exception e) {
            throw new HopException("Error finding executions with a matcher", (Throwable)e);
        }
    }

    @Override
    public Execution findPreviousSuccessfulExecution(ExecutionType executionType, String name) throws HopException {
        try {
            List<Execution> executions = this.findExecutions((Execution e) -> e.getExecutionType() == executionType && name.equals(e.getName()));
            for (Execution execution : executions) {
                ExecutionState executionState = this.getExecutionState(execution.getId());
                if (executionState == null || executionState.isFailed()) continue;
                return execution;
            }
            return null;
        }
        catch (Exception e2) {
            throw new HopException("Error finding previous successful execution", (Throwable)e2);
        }
    }

    @Override
    public ExecutionData getExecutionData(String parentExecutionId, String executionId) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/getExecInfo").addParameter("type", GetExecutionInfoServlet.Type.data.name()).addParameter("location", this.location.getName()).addParameter("parentId", parentExecutionId).addParameter("id", executionId).build();
            String json = this.server.execService(this.variables, uri.toString());
            ExecutionData executionData = (ExecutionData)new ObjectMapper().readValue(json, ExecutionData.class);
            return executionData;
        }
        catch (Exception e) {
            throw new HopException("Error getting execution data from remote location", (Throwable)e);
        }
    }

    @Override
    public Execution findLastExecution(ExecutionType executionType, String name) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/getExecInfo").addParameter("type", GetExecutionInfoServlet.Type.lastExecution.name()).addParameter("location", this.location.getName()).addParameter("execType", executionType.name()).addParameter("name", name).build();
            String json = this.server.execService(this.variables, uri.toString());
            Execution execution = (Execution)new ObjectMapper().readValue(json, Execution.class);
            return execution;
        }
        catch (Exception e) {
            throw new HopException("Error finding last execution from remote location", (Throwable)e);
        }
    }

    @Override
    public List<String> findChildIds(ExecutionType parentExecutionType, String parentExecutionId) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/getExecInfo").addParameter("type", GetExecutionInfoServlet.Type.childIds.name()).addParameter("location", this.location.getName()).addParameter("execType", parentExecutionType.name()).addParameter("id", parentExecutionId).build();
            String json = this.server.execService(this.variables, uri.toString());
            String[] ids = (String[])new ObjectMapper().readValue(json, String[].class);
            return Arrays.asList(ids);
        }
        catch (Exception e) {
            throw new HopException("Error finding execution child IDs from remote location", (Throwable)e);
        }
    }

    @Override
    public String findParentId(String childId) throws HopException {
        try {
            this.validateSettings();
            URI uri = new URIBuilder("/hop/getExecInfo").addParameter("type", GetExecutionInfoServlet.Type.parentId.name()).addParameter("location", this.location.getName()).addParameter("id", childId).build();
            String json = this.server.execService(this.variables, uri.toString());
            String parentId = (String)new ObjectMapper().readValue(json, String.class);
            return parentId;
        }
        catch (Exception e) {
            throw new HopException("Error finding parent execution ID from remote location", (Throwable)e);
        }
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public HopServer getServer() {
        return this.server;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public void setServer(HopServer server) {
        this.server = server;
    }

    public ExecutionInfoLocation getLocation() {
        return this.location;
    }

    public void setLocation(ExecutionInfoLocation location) {
        this.location = location;
    }
}

