/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.ReplicaInfo;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class InstanceConfigInfo {
    private final InstanceConfigId id;
    private final String displayName;
    private final List<ReplicaInfo> replicas;
    private final List<String> leaderOptions;

    public InstanceConfigInfo(InstanceConfigId id, String displayName) {
        this(id, displayName, Collections.emptyList(), Collections.emptyList());
    }

    public InstanceConfigInfo(InstanceConfigId id, String displayName, List<ReplicaInfo> replicas, List<String> leaderOptions) {
        this.id = id;
        this.displayName = displayName;
        this.replicas = replicas;
        this.leaderOptions = leaderOptions;
    }

    public InstanceConfigId getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<ReplicaInfo> getReplicas() {
        return this.replicas;
    }

    public List<String> getLeaderOptions() {
        return this.leaderOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceConfigInfo)) {
            return false;
        }
        InstanceConfigInfo that = (InstanceConfigInfo)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.replicas, that.replicas) && Objects.equals(this.leaderOptions, that.leaderOptions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.replicas, this.leaderOptions);
    }

    public String toString() {
        return String.format("Instance Config[%s, %s, %s, %s]", this.id, this.displayName, this.replicas, this.leaderOptions);
    }
}

