/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.spanner.v1.Session;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.GuardedBy;

class SessionClient
implements AutoCloseable {
    private final SpannerImpl spanner;
    private final GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    private final ScheduledExecutorService executor;
    private final DatabaseId db;
    @GuardedBy(value="this")
    private volatile long sessionChannelCounter;

    static Map<SpannerRpc.Option, ?> optionMap(SessionOption ... options) {
        if (options.length == 0) {
            return Collections.emptyMap();
        }
        EnumMap tmp = Maps.newEnumMap(SpannerRpc.Option.class);
        for (SessionOption option : options) {
            Object prev = tmp.put(option.rpcOption(), option.value());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object)((Object)option.rpcOption()));
        }
        return ImmutableMap.copyOf((Map)tmp);
    }

    SessionClient(SpannerImpl spanner, DatabaseId db, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory) {
        this.spanner = spanner;
        this.db = db;
        this.executorFactory = executorFactory;
        this.executor = (ScheduledExecutorService)executorFactory.get();
    }

    @Override
    public void close() {
        this.executorFactory.release((ExecutorService)this.executor);
    }

    SpannerImpl getSpanner() {
        return this.spanner;
    }

    DatabaseId getDatabaseId() {
        return this.db;
    }

    /*
     * Exception decompiling
     */
    SessionImpl createSession() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncBatchCreateSessions(int sessionCount, boolean distributeOverChannels, SessionConsumer consumer) {
        int remainder;
        int sessionCountPerChannel;
        if (distributeOverChannels) {
            sessionCountPerChannel = sessionCount / ((SpannerOptions)this.spanner.getOptions()).getNumChannels();
            remainder = sessionCount % ((SpannerOptions)this.spanner.getOptions()).getNumChannels();
        } else {
            sessionCountPerChannel = sessionCount;
            remainder = 0;
        }
        int numBeingCreated = 0;
        SessionClient sessionClient = this;
        synchronized (sessionClient) {
            for (int channelIndex = 0; channelIndex < ((SpannerOptions)this.spanner.getOptions()).getNumChannels(); ++channelIndex) {
                int createCountForChannel = sessionCountPerChannel;
                if (channelIndex == 0) {
                    createCountForChannel = sessionCountPerChannel + remainder;
                }
                if (createCountForChannel <= 0 || numBeingCreated >= sessionCount) break;
                try {
                    this.executor.submit(new BatchCreateSessionsRunnable(createCountForChannel, this.sessionChannelCounter++, consumer));
                    numBeingCreated += createCountForChannel;
                    continue;
                }
                catch (Throwable t) {
                    consumer.onSessionCreateFailure(t, sessionCount - numBeingCreated);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<SessionImpl> internalBatchCreateSessions(int sessionCount, long channelHint) throws SpannerException {
        Map<SpannerRpc.Option, ?> options = SessionClient.optionMap(SessionOption.channelHint(channelHint));
        Span parent = SpannerImpl.tracer.getCurrentSpan();
        Span span = SpannerImpl.tracer.spanBuilderWithExplicitParent("CloudSpannerOperation.BatchCreateSessionsRequest", parent).startSpan();
        span.addAnnotation(String.format("Requesting %d sessions", sessionCount));
        try (Scope s = SpannerImpl.tracer.withSpan(span);){
            List<Session> sessions = this.spanner.getRpc().batchCreateSessions(this.db.getName(), sessionCount, ((SpannerOptions)this.spanner.getOptions()).getSessionLabels(), options);
            span.addAnnotation(String.format("Request for %d sessions returned %d sessions", sessionCount, sessions.size()));
            span.end(TraceUtil.END_SPAN_OPTIONS);
            ArrayList<SessionImpl> res = new ArrayList<SessionImpl>(sessionCount);
            for (Session session : sessions) {
                res.add(new SessionImpl(this.spanner, session.getName(), options));
            }
            ArrayList<SessionImpl> arrayList = res;
            return arrayList;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SessionImpl sessionWithId(String name) {
        Map<SpannerRpc.Option, ?> options;
        SessionClient sessionClient = this;
        synchronized (sessionClient) {
            options = SessionClient.optionMap(SessionOption.channelHint(this.sessionChannelCounter++));
        }
        return new SessionImpl(this.spanner, name, options);
    }

    static interface SessionConsumer {
        public void onSessionReady(SessionImpl var1);

        public void onSessionCreateFailure(Throwable var1, int var2);
    }

    private final class BatchCreateSessionsRunnable
    implements Runnable {
        private final long channelHint;
        private final int sessionCount;
        private final SessionConsumer consumer;

        private BatchCreateSessionsRunnable(int sessionCount, long channelHint, SessionConsumer consumer) {
            Preconditions.checkNotNull((Object)consumer);
            Preconditions.checkArgument((sessionCount > 0 ? 1 : 0) != 0, (Object)"sessionCount must be > 0");
            this.channelHint = channelHint;
            this.sessionCount = sessionCount;
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Span span = SpannerImpl.tracer.spanBuilder("CloudSpannerOperation.BatchCreateSessions").startSpan();
            try (Scope s = SpannerImpl.tracer.withSpan(span);){
                List sessions;
                SpannerImpl.tracer.getCurrentSpan().addAnnotation(String.format("Creating %d sessions", this.sessionCount));
                for (int remainingSessionsToCreate = this.sessionCount; remainingSessionsToCreate > 0; remainingSessionsToCreate -= sessions.size()) {
                    try {
                        sessions = SessionClient.this.internalBatchCreateSessions(remainingSessionsToCreate, this.channelHint);
                    }
                    catch (Throwable t) {
                        TraceUtil.setWithFailure(SpannerImpl.tracer.getCurrentSpan(), t);
                        this.consumer.onSessionCreateFailure(t, remainingSessionsToCreate);
                        break;
                    }
                    for (SessionImpl session : sessions) {
                        this.consumer.onSessionReady(session);
                    }
                }
            }
            finally {
                span.end(TraceUtil.END_SPAN_OPTIONS);
            }
        }
    }

    static class SessionOption {
        private final SpannerRpc.Option rpcOption;
        private final Object value;

        SessionOption(SpannerRpc.Option option, Object value) {
            this.rpcOption = (SpannerRpc.Option)((Object)Preconditions.checkNotNull((Object)((Object)option)));
            this.value = value;
        }

        static SessionOption channelHint(long hint) {
            return new SessionOption(SpannerRpc.Option.CHANNEL_HINT, hint);
        }

        SpannerRpc.Option rpcOption() {
            return this.rpcOption;
        }

        Object value() {
            return this.value;
        }
    }

    static class SessionId {
        private static final PathTemplate NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}/instances/{instance}/databases/{database}/sessions/{session}");
        private final DatabaseId db;
        private final String name;

        private SessionId(DatabaseId db, String name) {
            this.db = (DatabaseId)Preconditions.checkNotNull((Object)db);
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        static SessionId of(String name) {
            Preconditions.checkNotNull((Object)name);
            Map parts = NAME_TEMPLATE.match(name);
            Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (String)"Name should conform to pattern %s: %s", (Object)NAME_TEMPLATE, (Object)name);
            return SessionId.of((String)parts.get("project"), (String)parts.get("instance"), (String)parts.get("database"), (String)parts.get("session"));
        }

        static SessionId of(String project, String instance, String database, String session) {
            return new SessionId(new DatabaseId(new InstanceId(project, instance), database), session);
        }

        DatabaseId getDatabaseId() {
            return this.db;
        }

        String getName() {
            return this.name;
        }
    }
}

