/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableexists;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.tableexists.TableExistsMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TableExistsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = TableExistsMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private CCombo wTableName;
    private Text wResult;
    private TextVar wSchemaname;
    private final TableExistsMeta input;

    public TableExistsDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (TableExistsMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TableExistsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"TableExistsDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, databaseMeta, lsMod);
        this.wConnection.addModifyListener(lsMod);
        Label wlSchemaname = new Label((Composite)this.shell, 131072);
        wlSchemaname.setText(BaseMessages.getString(PKG, (String)"TableExistsDialog.Schemaname.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSchemaname);
        FormData fdlSchemaname = new FormData();
        fdlSchemaname.left = new FormAttachment(0, 0);
        fdlSchemaname.right = new FormAttachment(middle, -margin);
        fdlSchemaname.top = new FormAttachment(this.wConnection, 2 * margin);
        wlSchemaname.setLayoutData((Object)fdlSchemaname);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableExistsDialog.this.getSchemaNames();
            }
        });
        this.wSchemaname = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchemaname);
        this.wSchemaname.setToolTipText(BaseMessages.getString(PKG, (String)"TableExistsDialog.Schemaname.Tooltip", (String[])new String[0]));
        this.wSchemaname.addModifyListener(lsMod);
        FormData fdSchemaname = new FormData();
        fdSchemaname.left = new FormAttachment(middle, 0);
        fdSchemaname.top = new FormAttachment(this.wConnection, 2 * margin);
        fdSchemaname.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchemaname.setLayoutData((Object)fdSchemaname);
        Label wlTableName = new Label((Composite)this.shell, 131072);
        wlTableName.setText(BaseMessages.getString(PKG, (String)"TableExistsDialog.TableName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTableName);
        FormData fdlTableName = new FormData();
        fdlTableName.left = new FormAttachment(0, 0);
        fdlTableName.right = new FormAttachment(middle, -margin);
        fdlTableName.top = new FormAttachment((Control)wbSchema, margin);
        wlTableName.setLayoutData((Object)fdlTableName);
        this.wTableName = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wTableName);
        this.wTableName.addModifyListener(lsMod);
        FormData fdTableName = new FormData();
        fdTableName.left = new FormAttachment(middle, 0);
        fdTableName.top = new FormAttachment((Control)wbSchema, margin);
        fdTableName.right = new FormAttachment(100, -margin);
        this.wTableName.setLayoutData((Object)fdTableName);
        this.wTableName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)TableExistsDialog.this.shell.getDisplay(), 1);
                TableExistsDialog.this.shell.setCursor(busy);
                TableExistsDialog.this.get();
                TableExistsDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlResult = new Label((Composite)this.shell, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"TableExistsDialog.ResultField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)this.wTableName, margin * 2);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new Text((Composite)this.shell, 18436);
        this.wResult.setToolTipText(BaseMessages.getString(PKG, (String)"TableExistsDialog.ResultField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)this.wTableName, margin * 2);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wResult);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"TableExistsDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        if (this.input.getTableNameField() != null) {
            this.wTableName.setText(this.input.getTableNameField());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchemaname.setText(this.input.getSchemaName());
        }
        if (this.input.getResultFieldName() != null) {
            this.wResult.setText(this.input.getResultFieldName());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setConnection(this.wConnection.getText());
        this.input.setSchemaName(this.wSchemaname.getText());
        this.input.setTableNameField(this.wTableName.getText());
        this.input.setResultFieldName(this.wResult.getText());
        this.transformName = this.wTransformName.getText();
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        if (databaseMeta == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableExistsDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TableExistsDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void get() {
        try {
            this.wTableName.removeAll();
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                r.getFieldNames();
                for (int i = 0; i < r.getFieldNames().length; ++i) {
                    this.wTableName.add(r.getFieldNames()[i]);
                }
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableExistsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableExistsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        if (this.wSchemaname.isDisposed()) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Message", (String[])new String[0]));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchemaname.setText(Const.NVL((String)d, (String)""));
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Empty.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Empty.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.ConnectionError", (String[])new String[0]), e);
            }
            finally {
                if (database != null) {
                    database.disconnect();
                    database = null;
                }
            }
        }
    }
}

