/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class BigDecimalCoder
extends AtomicCoder<BigDecimal> {
    private static final BigDecimalCoder INSTANCE = new BigDecimalCoder();
    private static final VarIntCoder VAR_INT_CODER = VarIntCoder.of();
    private static final BigIntegerCoder BIG_INT_CODER = BigIntegerCoder.of();

    public static BigDecimalCoder of() {
        return INSTANCE;
    }

    private BigDecimalCoder() {
    }

    @Override
    public void encode(BigDecimal value, OutputStream outStream) throws IOException, CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(BigDecimal value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        Preconditions.checkNotNull((Object)value, (Object)String.format("cannot encode a null %s", BigDecimal.class.getSimpleName()));
        VAR_INT_CODER.encode(value.scale(), outStream);
        BIG_INT_CODER.encode(value.unscaledValue(), outStream, context);
    }

    @Override
    public BigDecimal decode(InputStream inStream) throws IOException, CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public BigDecimal decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        int scale = VAR_INT_CODER.decode(inStream);
        BigInteger bigInteger = BIG_INT_CODER.decode(inStream, context);
        return new BigDecimal(bigInteger, scale);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        VAR_INT_CODER.verifyDeterministic();
        BIG_INT_CODER.verifyDeterministic();
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(BigDecimal value) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(BigDecimal value) throws Exception {
        Preconditions.checkNotNull((Object)value, (Object)String.format("cannot encode a null %s", BigDecimal.class.getSimpleName()));
        return VAR_INT_CODER.getEncodedElementByteSize(value.scale()) + BIG_INT_CODER.getEncodedElementByteSize(value.unscaledValue());
    }
}

