/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class RowWithGetters
extends Row {
    private final Object getterTarget;
    private final List<FieldValueGetter> getters;
    private Map<Integer, Object> cache;

    RowWithGetters(Schema schema, Factory<List<FieldValueGetter>> getterFactory, Object getterTarget) {
        super(schema);
        this.getterTarget = getterTarget;
        this.getters = getterFactory.create(getterTarget.getClass(), schema);
    }

    @Override
    public <T> @Nullable T getValue(int fieldIdx) {
        Object fieldValue;
        Schema.Field field = this.getSchema().getField(fieldIdx);
        boolean cacheField = this.cacheFieldType(field);
        if (cacheField && this.cache == null) {
            this.cache = new TreeMap<Integer, Object>();
        }
        Object object = fieldValue = cacheField ? this.cache.computeIfAbsent(fieldIdx, idx -> this.getters.get((int)idx).get(this.getterTarget)) : this.getters.get(fieldIdx).get(this.getterTarget);
        if (fieldValue == null && !field.getType().getNullable().booleanValue()) {
            throw new RuntimeException("Null value set on non-nullable field " + field);
        }
        return (T)fieldValue;
    }

    private boolean cacheFieldType(Schema.Field field) {
        Schema.TypeName typeName = field.getType().getTypeName();
        return typeName.equals((Object)Schema.TypeName.MAP) || typeName.equals((Object)Schema.TypeName.ARRAY) || typeName.equals((Object)Schema.TypeName.ITERABLE);
    }

    @Override
    public int getFieldCount() {
        return this.getters.size();
    }

    @Override
    @Internal
    public List<Object> getValues() {
        ArrayList<Object> rawValues = new ArrayList<Object>(this.getters.size());
        for (FieldValueGetter getter : this.getters) {
            rawValues.add(getter.getRaw(this.getterTarget));
        }
        return rawValues;
    }

    public List<FieldValueGetter> getGetters() {
        return this.getters;
    }

    public Object getGetterTarget() {
        return this.getterTarget;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof RowWithGetters) {
            RowWithGetters other = (RowWithGetters)o;
            return Objects.equals(this.getSchema(), other.getSchema()) && Objects.equals(this.getterTarget, other.getterTarget);
        }
        if (o instanceof Row) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getSchema(), this.getterTarget);
    }
}

