/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.TransformInputs;
import org.apache.beam.repackaged.direct_java.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class CombineTranslation {
    static final String JAVA_SERIALIZED_COMBINE_FN_URN = "beam:combinefn:javasdk:v1";

    private static RunnerApi.CombinePayload combinePayload(CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn, Coder<?> accumulatorCoder, SdkComponents components) throws IOException {
        return RunnerApi.CombinePayload.newBuilder().setAccumulatorCoderId(components.registerCoder(accumulatorCoder)).setCombineFn(CombineTranslation.toProto(combineFn, components)).build();
    }

    public static RunnerApi.FunctionSpec toProto(CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn, SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_COMBINE_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(combineFn))).build();
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(Combine.Globally.class, (Object)new CombineGloballyPayloadTranslator()).put(Combine.GroupedValues.class, (Object)new CombineGroupedValuesPayloadTranslator()).put(Combine.PerKey.class, (Object)new CombinePerKeyPayloadTranslator()).build();
        }
    }

    public static class CombineGroupedValuesPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Combine.GroupedValues<?, ?, ?>> {
        private CombineGroupedValuesPayloadTranslator() {
        }

        @Override
        public String getUrn(Combine.GroupedValues<?, ?, ?> transform) {
            return "beam:transform:combine_grouped_values:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Combine.GroupedValues<?, ?, ?>> transform, SdkComponents components) throws IOException {
            if (transform.getTransform().getSideInputs().isEmpty()) {
                CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn = transform.getTransform().getFn();
                Coder<?> accumulatorCoder = CombineGroupedValuesPayloadTranslator.extractAccumulatorCoder(combineFn, transform);
                return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(CombineTranslation.combinePayload(combineFn, accumulatorCoder, components).toByteString()).build();
            }
            return null;
        }

        private static <K, InputT, AccumT> Coder<AccumT> extractAccumulatorCoder(CombineFnBase.GlobalCombineFn<InputT, AccumT, ?> combineFn, AppliedPTransform<PCollection<KV<K, Iterable<InputT>>>, ?, Combine.GroupedValues<K, InputT, ?>> transform) throws IOException {
            try {
                PCollection mainInput = (PCollection)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(transform));
                KvCoder kvCoder = (KvCoder)mainInput.getCoder();
                IterableCoder iterCoder = (IterableCoder)kvCoder.getValueCoder();
                return combineFn.getAccumulatorCoder(transform.getPipeline().getCoderRegistry(), iterCoder.getElemCoder());
            }
            catch (CannotProvideCoderException e) {
                throw new IOException("Could not obtain a Coder for the accumulator", e);
            }
        }
    }

    public static class CombineGloballyPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Combine.Globally<?, ?>> {
        private CombineGloballyPayloadTranslator() {
        }

        @Override
        public String getUrn(Combine.Globally<?, ?> transform) {
            return "beam:transform:combine_globally:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Combine.Globally<?, ?>> transform, SdkComponents components) throws IOException {
            if (transform.getTransform().getSideInputs().isEmpty()) {
                return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(CombineGloballyPayloadTranslator.payloadForCombineGlobally(transform, components).toByteString()).build();
            }
            return null;
        }

        private static <InputT, AccumT> Coder<AccumT> extractAccumulatorCoder(CombineFnBase.GlobalCombineFn<InputT, AccumT, ?> combineFn, AppliedPTransform<PCollection<InputT>, ?, Combine.Globally<InputT, ?>> transform) throws IOException {
            try {
                PCollection mainInput = (PCollection)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(transform));
                return combineFn.getAccumulatorCoder(transform.getPipeline().getCoderRegistry(), mainInput.getCoder());
            }
            catch (CannotProvideCoderException e) {
                throw new IOException("Could not obtain a Coder for the accumulator", e);
            }
        }

        @VisibleForTesting
        static <InputT, OutputT> RunnerApi.CombinePayload payloadForCombineGlobally(AppliedPTransform<PCollection<InputT>, PCollection<OutputT>, Combine.Globally<InputT, OutputT>> transform, SdkComponents components) throws IOException {
            CombineFnBase.GlobalCombineFn<InputT, ?, OutputT> combineFn = transform.getTransform().getFn();
            Coder<?> accumulatorCoder = CombineGloballyPayloadTranslator.extractAccumulatorCoder(combineFn, transform);
            return CombineTranslation.combinePayload(combineFn, accumulatorCoder, components);
        }
    }

    public static class CombinePerKeyPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Combine.PerKey<?, ?, ?>> {
        private CombinePerKeyPayloadTranslator() {
        }

        @Override
        public String getUrn(Combine.PerKey<?, ?, ?> transform) {
            return "beam:transform:combine_per_key:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Combine.PerKey<?, ?, ?>> transform, SdkComponents components) throws IOException {
            if (transform.getTransform().getSideInputs().isEmpty()) {
                CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn = transform.getTransform().getFn();
                Coder<?> accumulatorCoder = CombinePerKeyPayloadTranslator.extractAccumulatorCoder(combineFn, transform);
                return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(CombineTranslation.combinePayload(combineFn, accumulatorCoder, components).toByteString()).build();
            }
            return null;
        }

        private static <K, InputT, AccumT> Coder<AccumT> extractAccumulatorCoder(CombineFnBase.GlobalCombineFn<InputT, AccumT, ?> combineFn, AppliedPTransform<PCollection<KV<K, InputT>>, ?, Combine.PerKey<K, InputT, ?>> transform) throws IOException {
            try {
                PCollection mainInput = (PCollection)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(transform));
                return combineFn.getAccumulatorCoder(transform.getPipeline().getCoderRegistry(), ((KvCoder)mainInput.getCoder()).getValueCoder());
            }
            catch (CannotProvideCoderException e) {
                throw new IOException("Could not obtain a Coder for the accumulator", e);
            }
        }
    }
}

