/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.sdk.fn.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class DataStreams {
    public static final int DEFAULT_OUTBOUND_BUFFER_LIMIT_BYTES = 1000000;

    public static ElementDelimitedOutputStream outbound(OutputChunkConsumer<ByteString> consumer) {
        return DataStreams.outbound(consumer, 1000000);
    }

    public static ElementDelimitedOutputStream outbound(OutputChunkConsumer<ByteString> consumer, int maximumChunkSize) {
        return new ElementDelimitedOutputStream(consumer, maximumChunkSize);
    }

    public static class DataStreamDecoder<T>
    implements PrefetchableIterator<T> {
        private final PrefetchableIterator<ByteString> inputByteStrings;
        private final Inbound inbound;
        private final Coder<T> coder;
        private static final InputStream EMPTY_STREAM = ByteString.EMPTY.newInput();

        public DataStreamDecoder(Coder<T> coder, PrefetchableIterator<ByteString> inputStream) {
            this.coder = coder;
            this.inputByteStrings = inputStream;
            this.inbound = new Inbound();
        }

        public List<T> decodeFromChunkBoundaryToChunkBoundary() {
            this.inbound.currentStream = ((ByteString)this.inputByteStrings.next()).newInput();
            this.inbound.position = 0;
            try {
                InputStream previousStream = this.inbound.currentStream;
                ArrayList<T> rvals = new ArrayList<T>();
                while (previousStream == this.inbound.currentStream && this.inbound.currentStream.available() != 0) {
                    rvals.add(this.next());
                }
                return rvals;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean isReady() {
            try {
                return this.inbound.isReady();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void prefetch() {
            if (!this.isReady()) {
                this.inputByteStrings.prefetch();
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return !this.inbound.isEof();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                long previousPosition = this.inbound.position;
                InputStream previousStream = this.inbound.currentStream;
                T next = this.coder.decode(this.inbound);
                if (previousPosition == (long)this.inbound.position && previousStream == this.inbound.currentStream) {
                    Preconditions.checkState((this.inbound.read() != -1 ? 1 : 0) != 0, (Object)"Unexpected EOF reached");
                }
                return next;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ InputStream access$200() {
            return EMPTY_STREAM;
        }

        private class Inbound
        extends InputStream {
            private int position;
            private InputStream currentStream = DataStreamDecoder.access$200();

            public boolean isReady() throws IOException {
                while (this.currentStream.available() == 0) {
                    if (!DataStreamDecoder.this.inputByteStrings.isReady()) {
                        return false;
                    }
                    if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                        return true;
                    }
                    this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                    this.position = 0;
                }
                return true;
            }

            public boolean isEof() throws IOException {
                while (this.currentStream.available() == 0) {
                    if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                        return true;
                    }
                    this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                    this.position = 0;
                }
                return false;
            }

            @Override
            public int read() throws IOException {
                int read;
                while ((read = this.currentStream.read()) == -1) {
                    if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                        return -1;
                    }
                    this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                    this.position = 0;
                }
                ++this.position;
                return read;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int read;
                for (int remainingLen = len; remainingLen > 0; remainingLen -= read) {
                    while ((read = this.currentStream.read(b, off + len - remainingLen, remainingLen)) == -1) {
                        if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                            int bytesRead = len - remainingLen;
                            this.position += bytesRead;
                            return bytesRead > 0 ? bytesRead : -1;
                        }
                        this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                        this.position = 0;
                    }
                }
                this.position += len;
                return len;
            }
        }
    }

    public static interface OutputChunkConsumer<T> {
        public void read(T var1) throws IOException;
    }

    public static final class ElementDelimitedOutputStream
    extends OutputStream {
        private final OutputChunkConsumer<ByteString> consumer;
        private final ByteStringOutputStream output;
        private final int maximumChunkSize;
        int previousPosition;

        public ElementDelimitedOutputStream(OutputChunkConsumer<ByteString> consumer, int maximumChunkSize) {
            this.consumer = consumer;
            this.maximumChunkSize = maximumChunkSize;
            this.output = new ByteStringOutputStream(maximumChunkSize);
        }

        public void delimitElement() throws IOException {
            if (this.previousPosition == this.output.size()) {
                this.write(0);
            }
            this.previousPosition = this.output.size();
        }

        @Override
        public void write(int i) throws IOException {
            this.output.write(i);
            if (this.maximumChunkSize == this.output.size()) {
                this.internalFlush();
            }
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            int spaceRemaining = this.maximumChunkSize - this.output.size();
            if (length > spaceRemaining) {
                this.output.write(b, offset, spaceRemaining);
                offset += spaceRemaining;
                length -= spaceRemaining;
                this.internalFlush();
            }
            while (length > this.maximumChunkSize) {
                this.output.write(b, offset, this.maximumChunkSize);
                offset += this.maximumChunkSize;
                length -= this.maximumChunkSize;
                this.internalFlush();
            }
            this.output.write(b, offset, length);
        }

        @Override
        public void close() throws IOException {
            if (this.output.size() > 0) {
                this.consumer.read(this.output.toByteString());
            }
            this.output.close();
        }

        private void internalFlush() throws IOException {
            this.consumer.read(this.output.toByteStringAndReset());
            this.previousPosition = -1;
        }
    }
}

