/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.direct_java.runners.core.construction.TransformInputs;
import org.apache.beam.runners.direct.DirectGraph;
import org.apache.beam.runners.direct.DirectWriteViewVisitor;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectGraphVisitor
extends Pipeline.PipelineVisitor.Defaults {
    private static final Logger LOG = LoggerFactory.getLogger(DirectGraphVisitor.class);
    private Map<PCollection<?>, AppliedPTransform<?, ?, ?>> producers = new HashMap();
    private Map<PCollectionView<?>, AppliedPTransform<?, ?, ?>> viewWriters = new HashMap();
    private Set<PCollectionView<?>> consumedViews = new HashSet();
    private ListMultimap<PInput, AppliedPTransform<?, ?, ?>> perElementConsumers = ArrayListMultimap.create();
    private ListMultimap<PValue, AppliedPTransform<?, ?, ?>> allConsumers = ArrayListMultimap.create();
    private Set<AppliedPTransform<?, ?, ?>> rootTransforms = new HashSet();
    private Map<AppliedPTransform<?, ?, ?>, String> stepNames = new HashMap();
    private int numTransforms = 0;
    private boolean finalized = false;

    DirectGraphVisitor() {
    }

    @Override
    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        Preconditions.checkState((!this.finalized ? 1 : 0) != 0, (String)"Attempting to traverse a pipeline (node %s) with a %s which has already visited a Pipeline and is finalized", (Object)node.getFullName(), (Object)this.getClass().getSimpleName());
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    @Override
    public void leaveCompositeTransform(TransformHierarchy.Node node) {
        Preconditions.checkState((!this.finalized ? 1 : 0) != 0, (String)"Attempting to traverse a pipeline (node %s) with a %s which is already finalized", (Object)node.getFullName(), (Object)this.getClass().getSimpleName());
        if (node.isRootNode()) {
            this.finalized = true;
            Preconditions.checkState((boolean)this.viewWriters.keySet().containsAll(this.consumedViews), (String)"All %ss that are consumed must be written by some %s %s: Missing %s", (Object)PCollectionView.class.getSimpleName(), (Object)DirectWriteViewVisitor.WriteView.class.getSimpleName(), (Object)PTransform.class.getSimpleName(), (Object)Sets.difference(this.consumedViews, this.viewWriters.keySet()));
        }
    }

    @Override
    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        AppliedPTransform<?, ?, ?> appliedTransform = this.getAppliedTransform(node);
        this.stepNames.put(appliedTransform, this.genStepName());
        if (node.getInputs().isEmpty()) {
            this.rootTransforms.add(appliedTransform);
        } else {
            Collection<PValue> mainInputs = TransformInputs.nonAdditionalInputs(node.toAppliedPTransform(this.getPipeline()));
            if (!mainInputs.containsAll(node.getInputs().values())) {
                LOG.debug("Inputs reduced to {} from {} by removing additional inputs", mainInputs, node.getInputs().values());
            }
            for (PValue pValue : mainInputs) {
                this.perElementConsumers.put((Object)pValue, appliedTransform);
            }
            for (PValue pValue : node.getInputs().values()) {
                this.allConsumers.put((Object)pValue, appliedTransform);
            }
        }
        if (node.getTransform() instanceof ParDo.MultiOutput) {
            this.consumedViews.addAll(((ParDo.MultiOutput)node.getTransform()).getSideInputs().values());
        } else if (node.getTransform() instanceof DirectWriteViewVisitor.WriteView) {
            this.viewWriters.put(((DirectWriteViewVisitor.WriteView)node.getTransform()).getView(), node.toAppliedPTransform(this.getPipeline()));
        }
    }

    @Override
    public void visitValue(PValue value, TransformHierarchy.Node producer) {
        AppliedPTransform<?, ?, ?> appliedTransform = this.getAppliedTransform(producer);
        if (value instanceof PCollection && !this.producers.containsKey(value)) {
            this.producers.put((PCollection)value, appliedTransform);
        }
    }

    private AppliedPTransform<?, ?, ?> getAppliedTransform(TransformHierarchy.Node node) {
        AppliedPTransform<?, ?, ?> application = node.toAppliedPTransform(this.getPipeline());
        return application;
    }

    private String genStepName() {
        return String.format("s%s", this.numTransforms++);
    }

    public DirectGraph getGraph() {
        Preconditions.checkState((boolean)this.finalized, (Object)"Can't get a graph before the Pipeline has been completely traversed");
        return DirectGraph.create(this.producers, this.viewWriters, this.perElementConsumers, this.rootTransforms, this.stepNames);
    }
}

