/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItem;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItemCoder;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItems;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformReplacements;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ParDoTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ReplacementOutputs;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SplittableParDo;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

@VisibleForTesting
public class ParDoMultiOverrideFactory<InputT, OutputT>
implements PTransformOverrideFactory<PCollection<? extends InputT>, PCollectionTuple, PTransform<PCollection<? extends InputT>, PCollectionTuple>> {
    static final String DIRECT_STATEFUL_PAR_DO_URN = "beam:directrunner:transforms:stateful_pardo:v1";

    @Override
    public PTransformOverrideFactory.PTransformReplacement<PCollection<? extends InputT>, PCollectionTuple> getReplacementTransform(AppliedPTransform<PCollection<? extends InputT>, PCollectionTuple, PTransform<PCollection<? extends InputT>, PCollectionTuple>> application) {
        try {
            return PTransformOverrideFactory.PTransformReplacement.of(PTransformReplacements.getSingletonMainInput(application), this.getReplacementForApplication(application));
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    private PTransform<PCollection<? extends InputT>, PCollectionTuple> getReplacementForApplication(AppliedPTransform<PCollection<? extends InputT>, PCollectionTuple, PTransform<PCollection<? extends InputT>, PCollectionTuple>> application) throws IOException {
        DoFn<?, ?> fn = ParDoTranslation.getDoFn(application);
        DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
        if (signature.processElement().isSplittable()) {
            return SplittableParDo.forAppliedParDo(application);
        }
        if (signature.stateDeclarations().size() > 0 || signature.timerDeclarations().size() > 0 || signature.timerFamilyDeclarations().size() > 0) {
            return new GbkThenStatefulParDo(fn, ParDoTranslation.getMainOutputTag(application), ParDoTranslation.getAdditionalOutputTags(application), ParDoTranslation.getSideInputs(application), ParDoTranslation.getSchemaInformation(application), ParDoTranslation.getSideInputMapping(application));
        }
        return application.getTransform();
    }

    @Override
    public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollectionTuple newOutput) {
        return ReplacementOutputs.tagged(outputs, newOutput);
    }

    static class ToKeyedWorkItem<K, V>
    extends DoFn<KV<K, Iterable<WindowedValue<KV<K, V>>>>, KeyedWorkItem<K, KV<K, V>>> {
        ToKeyedWorkItem() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
            Object key = ((KV)c.element()).getKey();
            c.output(KeyedWorkItems.elementsWorkItem(key, (Iterable)((KV)c.element()).getValue()));
        }
    }

    static class ReifyWindowedValueFn<K, V>
    extends DoFn<KV<K, V>, KV<K, WindowedValue<KV<K, V>>>> {
        ReifyWindowedValueFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
            c.output(KV.of(((KV)c.element()).getKey(), WindowedValue.of((KV)c.element(), c.timestamp(), window, c.pane())));
        }
    }

    static class StatefulParDo<K, InputT, OutputT>
    extends PTransform<PCollection<? extends KeyedWorkItem<K, KV<K, InputT>>>, PCollectionTuple> {
        private final transient DoFn<KV<K, InputT>, OutputT> doFn;
        private final TupleTagList additionalOutputTags;
        private final TupleTag<OutputT> mainOutputTag;
        private final List<PCollectionView<?>> sideInputs;
        private final DoFnSchemaInformation doFnSchemaInformation;
        private final Map<String, PCollectionView<?>> sideInputMapping;

        public StatefulParDo(DoFn<KV<K, InputT>, OutputT> doFn, TupleTag<OutputT> mainOutputTag, TupleTagList additionalOutputTags, List<PCollectionView<?>> sideInputs, DoFnSchemaInformation doFnSchemaInformation, Map<String, PCollectionView<?>> sideInputMapping) {
            this.doFn = doFn;
            this.mainOutputTag = mainOutputTag;
            this.additionalOutputTags = additionalOutputTags;
            this.sideInputs = sideInputs;
            this.doFnSchemaInformation = doFnSchemaInformation;
            this.sideInputMapping = sideInputMapping;
        }

        public DoFn<KV<K, InputT>, OutputT> getDoFn() {
            return this.doFn;
        }

        public TupleTag<OutputT> getMainOutputTag() {
            return this.mainOutputTag;
        }

        public List<PCollectionView<?>> getSideInputs() {
            return this.sideInputs;
        }

        public TupleTagList getAdditionalOutputTags() {
            return this.additionalOutputTags;
        }

        public DoFnSchemaInformation getSchemaInformation() {
            return this.doFnSchemaInformation;
        }

        public Map<String, PCollectionView<?>> getSideInputMapping() {
            return this.sideInputMapping;
        }

        @Override
        public Map<TupleTag<?>, PValue> getAdditionalInputs() {
            return PCollectionViews.toAdditionalInputs(this.sideInputs);
        }

        @Override
        public PCollectionTuple expand(PCollection<? extends KeyedWorkItem<K, KV<K, InputT>>> input) {
            return PCollectionTuple.ofPrimitiveOutputsInternal(input.getPipeline(), TupleTagList.of(this.getMainOutputTag()).and(this.getAdditionalOutputTags().getAll()), Collections.emptyMap(), input.getWindowingStrategy(), input.isBounded());
        }
    }

    static class GbkThenStatefulParDo<K, InputT, OutputT>
    extends PTransform<PCollection<KV<K, InputT>>, PCollectionTuple> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
        private final transient DoFn<KV<K, InputT>, OutputT> doFn;
        private final TupleTagList additionalOutputTags;
        private final TupleTag<OutputT> mainOutputTag;
        private final List<PCollectionView<?>> sideInputs;
        private final DoFnSchemaInformation doFnSchemaInformation;
        private final Map<String, PCollectionView<?>> sideInputMapping;

        public GbkThenStatefulParDo(DoFn<KV<K, InputT>, OutputT> doFn, TupleTag<OutputT> mainOutputTag, TupleTagList additionalOutputTags, List<PCollectionView<?>> sideInputs, DoFnSchemaInformation doFnSchemaInformation, Map<String, PCollectionView<?>> sideInputMapping) {
            this.doFn = doFn;
            this.additionalOutputTags = additionalOutputTags;
            this.mainOutputTag = mainOutputTag;
            this.sideInputs = sideInputs;
            this.doFnSchemaInformation = doFnSchemaInformation;
            this.sideInputMapping = sideInputMapping;
        }

        @Override
        public Map<TupleTag<?>, PValue> getAdditionalInputs() {
            return PCollectionViews.toAdditionalInputs(this.sideInputs);
        }

        @Override
        public PCollectionTuple expand(PCollection<KV<K, InputT>> input) {
            PCollection<KeyedWorkItem<K, KV<K, InputT>>> adjustedInput = this.groupToKeyedWorkItem(input);
            return this.applyStatefulParDo(adjustedInput);
        }

        @VisibleForTesting
        PCollection<KeyedWorkItem<K, KV<K, InputT>>> groupToKeyedWorkItem(PCollection<KV<K, InputT>> input) {
            WindowingStrategy<?, ?> inputWindowingStrategy = input.getWindowingStrategy();
            Preconditions.checkState((boolean)(input.getCoder() instanceof KvCoder), (String)"Input to a %s using state requires a %s, but the coder was %s", (Object)ParDo.class.getSimpleName(), (Object)KvCoder.class.getSimpleName(), input.getCoder());
            KvCoder kvCoder = (KvCoder)input.getCoder();
            Coder keyCoder = kvCoder.getKeyCoder();
            Coder<?> windowCoder = inputWindowingStrategy.getWindowFn().windowCoder();
            return ((PCollection)((PCollection)((PCollection)((PCollection)input.apply("Reify timestamps", ParDo.of(new ReifyWindowedValueFn()))).setCoder(KvCoder.of(keyCoder, WindowedValue.getFullCoder(kvCoder, windowCoder))).apply(Window.configure().triggering(Repeatedly.forever(AfterPane.elementCountAtLeast(1))).discardingFiredPanes().withAllowedLateness(inputWindowingStrategy.getAllowedLateness()).withTimestampCombiner(TimestampCombiner.EARLIEST))).apply("Group by key", GroupByKey.create())).apply("To KeyedWorkItem", ParDo.of(new ToKeyedWorkItem()))).setCoder(KeyedWorkItemCoder.of(keyCoder, kvCoder, windowCoder)).setWindowingStrategyInternal(inputWindowingStrategy);
        }

        @VisibleForTesting
        PCollectionTuple applyStatefulParDo(PCollection<KeyedWorkItem<K, KV<K, InputT>>> adjustedInput) {
            return (PCollectionTuple)adjustedInput.apply("Stateful ParDo", new StatefulParDo<K, InputT, OutputT>(this.doFn, this.mainOutputTag, this.additionalOutputTags, this.sideInputs, this.doFnSchemaInformation, this.sideInputMapping));
        }
    }
}

