/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.denormaliser;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.denormaliser.DenormaliserGroupField;
import org.apache.hop.pipeline.transforms.denormaliser.DenormaliserMeta;
import org.apache.hop.pipeline.transforms.denormaliser.DenormaliserTargetField;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DenormaliserDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = DenormaliserMeta.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "PivotSortWarning";
    private TableView wGroup;
    private TableView wTarget;
    private CCombo wKeyField;
    private final DenormaliserMeta input;

    public DenormaliserDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (DenormaliserMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlKeyField = new Label((Composite)this.shell, 131072);
        wlKeyField.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.KeyField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlKeyField);
        FormData fdlKeyField = new FormData();
        fdlKeyField.left = new FormAttachment(0, 0);
        fdlKeyField.right = new FormAttachment(middle, -margin);
        fdlKeyField.top = new FormAttachment((Control)this.wTransformName, margin);
        wlKeyField.setLayoutData((Object)fdlKeyField);
        this.wKeyField = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wKeyField);
        this.wKeyField.addModifyListener(lsMod);
        FormData fdKeyField = new FormData();
        fdKeyField.left = new FormAttachment(middle, 0);
        fdKeyField.top = new FormAttachment((Control)this.wTransformName, margin);
        fdKeyField.right = new FormAttachment(100, 0);
        this.wKeyField.setLayoutData((Object)fdKeyField);
        Label wlGroup = new Label((Composite)this.shell, 0);
        wlGroup.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.Group.Label", (String[])new String[0]));
        this.props.setLook((Control)wlGroup);
        FormData fdlGroup = new FormData();
        fdlGroup.left = new FormAttachment(0, 0);
        fdlGroup.top = new FormAttachment((Control)this.wKeyField, margin);
        wlGroup.setLayoutData((Object)fdlGroup);
        int nrKeyCols = 1;
        int nrKeyRows = this.input.getGroupFields() != null ? this.input.getGroupFields().size() : 1;
        ColumnInfo[] ciKey = new ColumnInfo[nrKeyCols];
        ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.GroupField", (String[])new String[0]), 2, false);
        this.wGroup = new TableView(this.variables, (Composite)this.shell, 68354, ciKey, nrKeyRows, lsMod, this.props);
        Button wGet = new Button((Composite)this.shell, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGet = new FormData();
        fdGet.top = new FormAttachment((Control)wlGroup, margin);
        fdGet.right = new FormAttachment(100, 0);
        wGet.setLayoutData((Object)fdGet);
        FormData fdGroup = new FormData();
        fdGroup.left = new FormAttachment(0, 0);
        fdGroup.top = new FormAttachment((Control)wlGroup, margin);
        fdGroup.right = new FormAttachment((Control)wGet, -margin);
        fdGroup.bottom = new FormAttachment(30, 0);
        this.wGroup.setLayoutData((Object)fdGroup);
        Label wlTarget = new Label((Composite)this.shell, 0);
        wlTarget.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.Target.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTarget);
        FormData fdlTarget = new FormData();
        fdlTarget.left = new FormAttachment(0, 0);
        fdlTarget.top = new FormAttachment((Control)this.wGroup, margin);
        wlTarget.setLayoutData((Object)fdlTarget);
        int upInsRows = this.input.getDenormaliserTargetFields() != null ? this.input.getDenormaliserTargetFields().size() : 1;
        ColumnInfo[] ciTarget = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.TargetFieldname", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.ValueFieldname", (String[])new String[0]), 2, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Keyvalue", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getAllValueMetaNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Format", (String[])new String[0]), 5, 4), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Currency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.NullIf", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Aggregation", (String[])new String[0]), 2, DenormaliserTargetField.DenormaliseAggregation.getDescriptions(), false)};
        ciTarget[ciTarget.length - 1].setToolTip(BaseMessages.getString(PKG, (String)"DenormaliserDialog.CiTarget.Title", (String[])new String[0]));
        ciTarget[2].setUsingVariables(true);
        this.wTarget = new TableView(this.variables, (Composite)this.shell, 68354, ciTarget, upInsRows, lsMod, this.props);
        Button wGetAgg = new Button((Composite)this.shell, 8);
        wGetAgg.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.GetLookupFields.Button", (String[])new String[0]));
        FormData fdGetAgg = new FormData();
        fdGetAgg.top = new FormAttachment((Control)wlTarget, margin);
        fdGetAgg.right = new FormAttachment(100, 0);
        wGetAgg.setLayoutData((Object)fdGetAgg);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        FormData fdTarget = new FormData();
        fdTarget.left = new FormAttachment(0, 0);
        fdTarget.top = new FormAttachment((Control)wlTarget, margin);
        fdTarget.right = new FormAttachment((Control)wGetAgg, -margin);
        fdTarget.bottom = new FormAttachment((Control)this.wOk, -margin);
        this.wTarget.setLayoutData((Object)fdTarget);
        this.wOk.addListener(13, e -> this.ok());
        wGet.addListener(13, e -> this.get());
        wGetAgg.addListener(13, e -> this.getAgg());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.shell.getDisplay().asyncExec(() -> {
            String keyValue = this.wKeyField.getText();
            try {
                IRowMeta rowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (rowMeta != null) {
                    String[] fieldNames;
                    for (String fieldName : fieldNames = Const.sortStrings((String[])rowMeta.getFieldNames())) {
                        this.wKeyField.add(fieldName);
                    }
                    ciKey[0].setComboValues(fieldNames);
                    ciTarget[1].setComboValues(fieldNames);
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
            }
            finally {
                if (keyValue != null) {
                    this.wKeyField.setText(keyValue);
                }
            }
        });
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        int i;
        this.logDebug(BaseMessages.getString(PKG, (String)"DenormaliserDialog.Log.Getting.KeyInfo", (String[])new String[0]));
        if (this.input.getKeyField() != null) {
            this.wKeyField.setText(this.input.getKeyField());
        }
        if (this.input.getGroupFields() != null) {
            for (i = 0; i < this.input.getGroupFields().size(); ++i) {
                TableItem item = this.wGroup.table.getItem(i);
                if (this.input.getGroupFields().get(i) == null) continue;
                DenormaliserGroupField groupfield = this.input.getGroupFields().get(i);
                item.setText(1, groupfield.getName());
            }
        }
        if (this.input.getDenormaliserTargetFields() != null) {
            for (i = 0; i < this.input.getDenormaliserTargetFields().size(); ++i) {
                DenormaliserTargetField field = this.input.getDenormaliserTargetFields().get(i);
                TableItem item = this.wTarget.table.getItem(i);
                if (field.getTargetName() != null) {
                    item.setText(1, field.getTargetName());
                }
                if (field.getFieldName() != null) {
                    item.setText(2, field.getFieldName());
                }
                if (field.getKeyValue() != null) {
                    item.setText(3, field.getKeyValue());
                }
                if (field.getTargetType() != null) {
                    item.setText(4, field.getTargetType());
                }
                if (field.getTargetFormat() != null) {
                    item.setText(5, field.getTargetFormat());
                }
                if (field.getTargetLength() >= 0) {
                    item.setText(6, "" + field.getTargetLength());
                }
                if (field.getTargetPrecision() >= 0) {
                    item.setText(7, "" + field.getTargetPrecision());
                }
                if (field.getTargetCurrencySymbol() != null) {
                    item.setText(8, field.getTargetCurrencySymbol());
                }
                if (field.getTargetDecimalSymbol() != null) {
                    item.setText(9, field.getTargetDecimalSymbol());
                }
                if (field.getTargetGroupingSymbol() != null) {
                    item.setText(10, field.getTargetGroupingSymbol());
                }
                if (field.getTargetNullString() != null) {
                    item.setText(11, field.getTargetNullString());
                }
                if (field.getTargetAggregationType().getDefaultResultType() < 0) continue;
                item.setText(12, field.getTargetAggregationType().getDescription());
            }
        }
        this.wGroup.setRowNums();
        this.wGroup.optWidth(true);
        this.wTarget.setRowNums();
        this.wTarget.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        int i;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        int sizegroup = this.wGroup.nrNonEmpty();
        int nrFields = this.wTarget.nrNonEmpty();
        this.input.setKeyField(this.wKeyField.getText());
        this.input.getGroupFields().clear();
        this.input.getDenormaliserTargetFields().clear();
        for (i = 0; i < sizegroup; ++i) {
            TableItem item = this.wGroup.getNonEmpty(i);
            DenormaliserGroupField groupfield = new DenormaliserGroupField();
            groupfield.setName(item.getText(1));
            this.input.getGroupFields().add(groupfield);
        }
        for (i = 0; i < nrFields; ++i) {
            DenormaliserTargetField field = new DenormaliserTargetField();
            TableItem item = this.wTarget.getNonEmpty(i);
            field.setTargetName(item.getText(1));
            field.setFieldName(item.getText(2));
            field.setKeyValue(item.getText(3));
            field.setTargetType(item.getText(4));
            field.setTargetFormat(item.getText(5));
            field.setTargetLength(Const.toInt((String)item.getText(6), (int)-1));
            field.setTargetPrecision(Const.toInt((String)item.getText(7), (int)-1));
            field.setTargetCurrencySymbol(item.getText(8));
            field.setTargetDecimalSymbol(item.getText(9));
            field.setTargetGroupingSymbol(item.getText(10));
            field.setTargetNullString(item.getText(11));
            field.setTargetAggregationType(DenormaliserTargetField.DenormaliseAggregation.getTypeWithDescription(item.getText(12)));
            this.input.getDenormaliserTargetFields().add(field);
        }
        this.transformName = this.wTransformName.getText();
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"DenormaliserDialog.Unpivot.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DenormaliserDialog.Unpivot.DialogMessage", (String[])new String[]{Const.CR, Const.CR}), 8, new String[]{BaseMessages.getString(PKG, (String)"DenormaliserDialog.WarningMessage.Option.1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"DenormaliserDialog.WarningMessage.Option.2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wGroup, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DenormaliserDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DenormaliserDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getAgg() {
        this.wGroup.removeEmptyRows();
        String[] groupingFields = this.wGroup.getItems(0);
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wTarget, (int)2, (int[])new int[0], (int[])new int[0], (int)-1, (int)-1, (tableItem, v) -> {
                    if (Const.indexOfString((String)v.getName(), (String[])groupingFields) < 0 && !this.wKeyField.getText().equalsIgnoreCase(v.getName())) {
                        int nr = tableItem.getParent().indexOf(tableItem) + 1;
                        tableItem.setText(1, BaseMessages.getString(PKG, (String)"DenormaliserDialog.TargetFieldname.Label", (String[])new String[0]) + nr);
                        tableItem.setText(2, v.getName());
                        tableItem.setText(4, v.getTypeDesc());
                        if (v.getLength() >= 0) {
                            tableItem.setText(6, "" + v.getLength());
                        }
                        if (v.getPrecision() >= 0) {
                            tableItem.setText(7, "" + v.getPrecision());
                        }
                    }
                    return true;
                });
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DenormaliserDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DenormaliserDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

