/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.ExtensionPointPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.Plugin;
import org.apache.hop.core.plugins.PluginMainClassType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.xml.XmlHandlerCache;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamHop {
    private static final Logger LOG = LoggerFactory.getLogger(BeamHop.class);

    public static final boolean isInitialized() {
        return HopEnvironment.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void init(List<String> transformPluginClasses, List<String> xpPluginClasses) throws HopException {
        PluginRegistry registry;
        PluginRegistry pluginRegistry = registry = PluginRegistry.getInstance();
        synchronized (pluginRegistry) {
            System.setProperty("HOP_AUTO_CREATE_CONFIG", "N");
            HopEnvironment.init();
            XmlHandlerCache.getInstance();
            TransformPluginType transformPluginType = (TransformPluginType)registry.getPluginType(TransformPluginType.class);
            for (String transformPluginClassName : transformPluginClasses) {
                try {
                    IPlugin exists = BeamHop.findPlugin(registry, TransformPluginType.class, transformPluginClassName);
                    if (exists == null) {
                        Class<?> transformPluginClass = Class.forName(transformPluginClassName);
                        Transform annotation = transformPluginClass.getAnnotation(Transform.class);
                        transformPluginType.handlePluginAnnotation(transformPluginClass, (Annotation)annotation, new ArrayList(), true, null);
                        continue;
                    }
                    LOG.debug("Plugin " + transformPluginClassName + " is already registered");
                }
                catch (Exception e) {
                    LOG.error("Error registering transform plugin class : " + transformPluginClassName, (Throwable)e);
                }
            }
            ExtensionPointPluginType xpPluginType = (ExtensionPointPluginType)registry.getPluginType(ExtensionPointPluginType.class);
            for (String xpPluginClassName : xpPluginClasses) {
                try {
                    IPlugin exists = BeamHop.findPlugin(registry, ExtensionPointPluginType.class, xpPluginClassName);
                    if (exists == null) {
                        Class<?> xpPluginClass = Class.forName(xpPluginClassName);
                        ExtensionPoint annotation = xpPluginClass.getAnnotation(ExtensionPoint.class);
                        xpPluginType.handlePluginAnnotation(xpPluginClass, (Annotation)annotation, new ArrayList(), true, null);
                        continue;
                    }
                    LOG.debug("Plugin " + xpPluginClassName + " is already registered");
                }
                catch (Exception e) {
                    LOG.error("Error registering transform plugin class : " + xpPluginClassName, (Throwable)e);
                }
            }
        }
    }

    private static IPlugin findPlugin(PluginRegistry registry, Class<? extends IPluginType> pluginTypeClass, String pluginClassName) {
        PluginMainClassType classType = pluginTypeClass.getAnnotation(PluginMainClassType.class);
        List plugins = registry.getPlugins(pluginTypeClass);
        for (IPlugin plugin : plugins) {
            String mainClassName = (String)plugin.getClassMap().get(classType.value());
            if (mainClassName == null || !pluginClassName.equals(mainClassName)) continue;
            return plugin;
        }
        return null;
    }

    public static IPlugin getTransformPluginForClass(Class<? extends ITransformMeta> metaClass) {
        Transform transformAnnotation = metaClass.getAnnotation(Transform.class);
        return new Plugin(new String[]{transformAnnotation.id()}, TransformPluginType.class, metaClass, transformAnnotation.categoryDescription(), transformAnnotation.name(), transformAnnotation.description(), transformAnnotation.image(), transformAnnotation.isSeparateClassLoaderNeeded(), false, new HashMap(), new ArrayList(), transformAnnotation.documentationUrl(), transformAnnotation.keywords(), null, false);
    }
}

