/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import java.util.List;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.IRowHandler;
import org.apache.hop.pipeline.transform.IRowListener;

public class BeamRowHandler
implements IRowHandler {
    private final BaseTransform transform;
    private final IRowSet outputRowSet;
    private final IRowSet inputRowSet;

    public BeamRowHandler(BaseTransform transform) {
        this.transform = transform;
        List inputRowSets = transform.getInputRowSets();
        this.inputRowSet = inputRowSets.isEmpty() ? null : (IRowSet)inputRowSets.get(0);
        List outputRowSets = transform.getOutputRowSets();
        this.outputRowSet = outputRowSets.isEmpty() ? null : (IRowSet)outputRowSets.get(0);
    }

    public Object[] getRow() throws HopException {
        if (this.inputRowSet == null) {
            return null;
        }
        Object[] row = this.inputRowSet.getRow();
        if (row != null) {
            this.transform.incrementLinesRead();
            this.transform.setInputRowMeta(this.inputRowSet.getRowMeta());
            List rowListeners = this.transform.getRowListeners();
            for (IRowListener rowListener : rowListeners) {
                rowListener.rowReadEvent(this.inputRowSet.getRowMeta(), row);
            }
        }
        return row;
    }

    public void putRow(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        List rowListeners = this.transform.getRowListeners();
        for (IRowListener rowListener : rowListeners) {
            rowListener.rowWrittenEvent(rowMeta, row);
        }
        if (this.outputRowSet != null) {
            this.outputRowSet.putRow(rowMeta, row);
            this.transform.incrementLinesWritten();
        }
    }

    public void putError(IRowMeta rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws HopTransformException {
        this.transform.handlePutError((IVariables)this.transform, rowMeta, row, nrErrors, errorDescriptions, fieldNames, errorCodes);
    }

    public void putRowTo(IRowMeta rowMeta, Object[] row, IRowSet rowSet) throws HopTransformException {
        List rowListeners = this.transform.getRowListeners();
        for (IRowListener listener : rowListeners) {
            listener.rowWrittenEvent(rowMeta, row);
        }
        rowSet.putRow(rowMeta, row);
        this.transform.incrementLinesWritten();
    }
}

