/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.engines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.runners.core.metrics.DefaultMetricResults;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.flink.FlinkRunner;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.ThrowingSupplier;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.engines.BeamPipelineEngineCapabilities;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.metadata.RunnerType;
import org.apache.hop.beam.pipeline.HopPipelineMetaToBeamPipelineConverter;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.execution.ExecutionBuilder;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionStateBuilder;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.IExecutionFinishedListener;
import org.apache.hop.pipeline.IExecutionStartedListener;
import org.apache.hop.pipeline.IExecutionStoppedListener;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.EngineMetrics;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineComponentRowsReceived;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineCapabilities;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.joda.time.Duration;

public abstract class BeamPipelineEngine
extends Variables
implements IPipelineEngine<PipelineMeta> {
    static MetricResults EMPTY_METRIC_RESULTS = new DefaultMetricResults(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    private final PipelineEngineCapabilities engineCapabilities;
    protected PipelineMeta pipelineMeta;
    protected String pluginId;
    protected PipelineRunConfiguration pipelineRunConfiguration;
    protected boolean preparing;
    protected boolean readyToStart;
    protected boolean running;
    protected boolean finished;
    protected boolean stopped;
    protected boolean paused;
    protected boolean hasHaltedComponents;
    protected boolean preview;
    protected int errors;
    protected IHopMetadataProvider metadataProvider;
    protected ILogChannel logChannel;
    protected ILoggingObject loggingObject;
    protected String containerId;
    protected EngineMetrics engineMetrics;
    protected Result previousResult;
    protected ILoggingObject parent;
    protected IPipelineEngine parentPipeline;
    protected IWorkflowEngine<WorkflowMeta> parentWorkflow;
    protected LogLevel logLevel;
    protected Date executionStartDate;
    protected Date executionEndDate;
    protected List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> executionStartedListeners;
    protected List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> executionFinishedListeners;
    protected List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> executionStoppedListeners;
    protected Map<String, IPipelineEngine> activeSubPipelines;
    protected Map<String, IWorkflowEngine<WorkflowMeta>> activeSubWorkflows;
    protected Map<String, Object> extensionDataMap;
    protected int lastLogLineNr;
    protected Timer refreshTimer;
    protected INamedParameters namedParams = new NamedParameters();
    private String statusDescription = "Waiting";
    private EngineComponent.ComponentExecutionStatus status;
    private HopPipelineMetaToBeamPipelineConverter converter;
    private org.apache.beam.sdk.Pipeline beamPipeline;
    private Thread beamThread;
    private PipelineResult beamPipelineResults;
    private IBeamPipelineEngineRunConfiguration beamEngineRunConfiguration;
    private ExecutionInfoLocation executionInfoLocation;
    private Timer executionInfoTimer;
    protected List<IExecutionDataSampler<? extends IExecutionDataSamplerStore>> dataSamplers;

    public BeamPipelineEngine() {
        this.logChannel = LogChannel.GENERAL;
        this.engineMetrics = new EngineMetrics();
        this.executionStartedListeners = Collections.synchronizedList(new ArrayList());
        this.executionFinishedListeners = Collections.synchronizedList(new ArrayList());
        this.executionStoppedListeners = Collections.synchronizedList(new ArrayList());
        this.activeSubPipelines = new HashMap<String, IPipelineEngine>();
        this.activeSubWorkflows = new HashMap<String, IWorkflowEngine<WorkflowMeta>>();
        this.engineCapabilities = new BeamPipelineEngineCapabilities();
        this.extensionDataMap = Collections.synchronizedMap(new HashMap());
        this.dataSamplers = Collections.synchronizedList(new ArrayList());
    }

    public BeamPipelineEngine(PipelineMeta pipelineMeta, ILoggingObject parent, IVariables variables) {
        this();
        this.pipelineMeta = pipelineMeta;
        this.loggingObject = new LoggingObject((Object)this);
        this.setParent(parent);
        this.initializeFrom(variables);
        this.copyParametersFromDefinitions((INamedParameterDefinitions)pipelineMeta);
        this.activateParameters((IVariables)this);
    }

    public abstract IPipelineEngineRunConfiguration createDefaultPipelineEngineRunConfiguration();

    public abstract void validatePipelineRunConfigurationClass(IPipelineEngineRunConfiguration var1) throws HopException;

    public void prepareExecution() throws HopException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.executionStartDate = new Date();
            this.status = EngineComponent.ComponentExecutionStatus.STATUS_INIT;
            this.statusDescription = "Initializing";
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.setPreparing(true);
            IPipelineEngineRunConfiguration engineRunConfiguration = this.pipelineRunConfiguration.getEngineRunConfiguration();
            this.validatePipelineRunConfigurationClass(engineRunConfiguration);
            if (!(engineRunConfiguration instanceof IBeamPipelineEngineRunConfiguration)) {
                throw new HopException("A beam pipeline needs a beam pipeline engine configuration to run, not '" + this.pipelineRunConfiguration.getName() + "'");
            }
            if (this.metadataProvider == null) {
                throw new HopException("The beam pipeline engine didn't receive a metadata");
            }
            this.beamEngineRunConfiguration = (IBeamPipelineEngineRunConfiguration)engineRunConfiguration;
            if (this.logLevel != null) {
                this.beamEngineRunConfiguration.setVariable("LogLevel", this.logLevel.getCode());
            }
            this.lookupExecutionInformationLocation();
            this.registerPipelineExecutionInformation();
            this.startExecutionInfoTimer();
            this.addExecutionFinishedListener(engine -> this.stopExecutionInfoTimer());
            this.converter = new HopPipelineMetaToBeamPipelineConverter((IVariables)this, this.pipelineMeta, this.metadataProvider, this.pipelineRunConfiguration.getName(), this.dataSamplers, this.getLogChannelId());
            this.beamPipeline = this.converter.createPipeline();
            FileSystems.setDefaultPipelineOptions((PipelineOptions)this.beamPipeline.getOptions());
            this.logChannel.logBasic("Executing this pipeline using the Beam Pipeline Engine with run configuration '" + this.pipelineRunConfiguration.getName() + "'");
            PipelineExecutionConfiguration pipelineExecutionConfiguration = new PipelineExecutionConfiguration();
            pipelineExecutionConfiguration.setRunConfiguration(this.pipelineRunConfiguration.getName());
            if (this.logLevel != null) {
                pipelineExecutionConfiguration.setLogLevel(this.logLevel);
            }
            if (this.previousResult != null) {
                pipelineExecutionConfiguration.setPreviousResult(this.previousResult);
            }
            this.setRunning(false);
            this.setReadyToStart(true);
        }
        catch (Exception e) {
            this.setRunning(false);
            this.setReadyToStart(false);
            this.setStopped(true);
            this.setErrors(this.getErrors() + 1);
            this.setPaused(false);
            this.setPreparing(false);
            throw new HopException("Error preparing remote pipeline", (Throwable)e);
        }
        finally {
            this.setPreparing(false);
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private PipelineResult executePipeline(org.apache.beam.sdk.Pipeline pipeline) throws HopException {
        RunnerType runnerType = this.beamEngineRunConfiguration.getRunnerType();
        try {
            switch (runnerType) {
                case Direct: {
                    return DirectRunner.fromOptions((PipelineOptions)pipeline.getOptions()).run(pipeline);
                }
                case Flink: {
                    return FlinkRunner.fromOptions((PipelineOptions)pipeline.getOptions()).run(pipeline);
                }
                case DataFlow: {
                    return DataflowRunner.fromOptions((PipelineOptions)pipeline.getOptions()).run(pipeline);
                }
                case Spark: {
                    return SparkRunner.fromOptions((PipelineOptions)pipeline.getOptions()).run(pipeline);
                }
            }
            throw new HopException("Execution on runner '" + runnerType.name() + "' is not supported yet.");
        }
        catch (Throwable e) {
            throw new HopException("Error executing pipeline with runner " + runnerType.name(), e);
        }
    }

    public void startThreads() throws HopException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        final AtomicBoolean hasStartupErrors = new AtomicBoolean(false);
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.setRunning(true);
            this.setReadyToStart(false);
            this.status = EngineComponent.ComponentExecutionStatus.STATUS_RUNNING;
            this.statusDescription = "Running";
            if (this.beamEngineRunConfiguration.isRunningAsynchronous()) {
                try {
                    this.beamPipelineResults = this.executePipeline(this.beamPipeline);
                }
                catch (Throwable e) {
                    hasStartupErrors.set(true);
                    this.setRunning(false);
                    this.setStopped(true);
                    this.setPreparing(false);
                    this.setPaused(false);
                    this.setReadyToStart(false);
                    this.setErrors(this.getErrors() + 1);
                    this.logChannel.logError("Error starting the Beam pipeline", e);
                }
                this.firePipelineExecutionStartedListeners();
            } else {
                this.beamThread = new Thread(() -> {
                    try {
                        this.beamPipelineResults = this.executePipeline(this.beamPipeline);
                    }
                    catch (Throwable e) {
                        this.logChannel.logError("Error starting the Beam pipeline", e);
                        this.setRunning(false);
                        this.setStopped(true);
                        this.setPreparing(false);
                        this.setPaused(false);
                        this.setReadyToStart(true);
                        this.setErrors(this.getErrors() + 1);
                    }
                });
                this.beamThread.start();
                new Thread(() -> {
                    try {
                        this.beamThread.join();
                        this.firePipelineExecutionFinishedListeners();
                        this.populateEngineMetrics();
                        if (this.refreshTimer != null) {
                            this.refreshTimer.cancel();
                        }
                        this.setRunning(false);
                        this.status = EngineComponent.ComponentExecutionStatus.STATUS_FINISHED;
                        this.statusDescription = this.getErrors() > 0 ? "Finished (with errors)" : "Finished";
                        this.executionEndDate = new Date();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error post-processing a beam pipeline", e);
                    }
                }).start();
            }
            this.refreshTimer = new Timer();
            this.refreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        BeamPipelineEngine.this.populateEngineMetrics();
                        if (hasStartupErrors.get()) {
                            BeamPipelineEngine.this.refreshTimer.cancel();
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Error refreshing engine metrics in the Beam pipeline engine", e);
                    }
                }
            }, 0L, 1000L);
        }
        catch (Throwable e) {
            throw new HopException("Unexpected error starting Beam pipeline", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void populateEngineMetrics() throws HopException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            EngineMetrics em = new EngineMetrics();
            this.evaluatePipelineStatus();
            em.setStartDate(this.getExecutionStartDate());
            em.setEndDate(this.getExecutionEndDate());
            if (this.beamPipelineResults != null) {
                HashSet<String> transformNames = new HashSet<String>(Arrays.asList(this.pipelineMeta.getTransformNames()));
                HashMap<String, EngineComponent> componentsMap = new HashMap<String, EngineComponent>();
                MetricResults metrics = this.safelyCall(() -> this.beamPipelineResults.metrics(), EMPTY_METRIC_RESULTS);
                MetricQueryResults allResults = metrics.queryMetrics(MetricsFilter.builder().build());
                for (MetricResult result : allResults.getCounters()) {
                    String metricsType = result.getName().getNamespace();
                    String metricsName = result.getName().getName();
                    long processed = (Long)result.getAttempted();
                    if (!transformNames.contains(metricsName)) continue;
                    EngineComponent engineComponent = (EngineComponent)componentsMap.get(metricsName);
                    if (engineComponent == null) {
                        engineComponent = new EngineComponent(metricsName, 0);
                        componentsMap.put(metricsName, engineComponent);
                    }
                    if ("read".equalsIgnoreCase(metricsType)) {
                        engineComponent.setLinesRead(processed);
                        em.setComponentMetric((IEngineComponent)engineComponent, Pipeline.METRIC_READ, Long.valueOf(processed));
                    } else if ("written".equalsIgnoreCase(metricsType)) {
                        engineComponent.setLinesWritten(processed);
                        em.setComponentMetric((IEngineComponent)engineComponent, Pipeline.METRIC_WRITTEN, Long.valueOf(processed));
                    } else if ("input".equalsIgnoreCase(metricsType)) {
                        engineComponent.setLinesInput(processed);
                        em.setComponentMetric((IEngineComponent)engineComponent, Pipeline.METRIC_INPUT, Long.valueOf(processed));
                    } else if ("output".equalsIgnoreCase(metricsType)) {
                        engineComponent.setLinesOutput(processed);
                        em.setComponentMetric((IEngineComponent)engineComponent, Pipeline.METRIC_OUTPUT, Long.valueOf(processed));
                    } else if ("init".equalsIgnoreCase(metricsType)) {
                        em.setComponentMetric((IEngineComponent)engineComponent, Pipeline.METRIC_INIT, Long.valueOf(processed));
                    } else if ("flush_buffer".equalsIgnoreCase(metricsType)) {
                        em.setComponentMetric((IEngineComponent)engineComponent, Pipeline.METRIC_FLUSH_BUFFER, Long.valueOf(processed));
                    }
                    engineComponent.setExecutionStartDate(this.getExecutionStartDate());
                    engineComponent.setExecutionEndDate(this.getExecutionEndDate());
                    engineComponent.setExecutionDuration(this.calculateDuration(this.getExecutionStartDate(), this.getExecutionEndDate()));
                    switch (this.safelyCall(() -> this.beamPipelineResults.getState(), PipelineResult.State.UNKNOWN)) {
                        case DONE: {
                            engineComponent.setRunning(false);
                            engineComponent.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_FINISHED);
                            break;
                        }
                        case CANCELLED: 
                        case FAILED: 
                        case STOPPED: {
                            engineComponent.setStopped(true);
                            engineComponent.setRunning(false);
                            engineComponent.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_STOPPED);
                            break;
                        }
                        case RUNNING: {
                            engineComponent.setRunning(true);
                            engineComponent.setStopped(false);
                            engineComponent.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_RUNNING);
                            break;
                        }
                        case UNKNOWN: {
                            break;
                        }
                        case UPDATED: {
                            break;
                        }
                    }
                }
                em.getComponents().clear();
                em.getComponents().addAll(componentsMap.values());
            }
            EngineMetrics engineMetrics = this.engineMetrics;
            synchronized (engineMetrics) {
                this.engineMetrics = em;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    protected long calculateDuration(Date startTime, Date stopTime) {
        long lapsed;
        if (startTime != null && stopTime == null) {
            Calendar cal = Calendar.getInstance();
            long now = cal.getTimeInMillis();
            long st = startTime.getTime();
            lapsed = now - st;
        } else {
            lapsed = startTime != null && stopTime != null ? stopTime.getTime() - startTime.getTime() : 0L;
        }
        return lapsed;
    }

    protected synchronized void evaluatePipelineStatus() throws HopException {
        if (this.beamPipelineResults == null || this.safelyCall(() -> this.beamPipelineResults.getState()) == null) {
            return;
        }
        PipelineResult.State pipelineState = (PipelineResult.State)this.safelyCall(() -> this.beamPipelineResults.waitUntilFinish(Duration.millis((long)1L)));
        if (pipelineState != null) {
            boolean cancelPipeline = false;
            boolean cancelRefreshTimer = false;
            switch (pipelineState) {
                case DONE: {
                    if (this.isRunning()) {
                        this.setRunning(false);
                        this.executionEndDate = new Date();
                        if (this.beamEngineRunConfiguration.isRunningAsynchronous()) {
                            this.firePipelineExecutionFinishedListeners();
                        }
                        this.logChannel.logBasic("Beam pipeline execution has finished.");
                    }
                    this.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_FINISHED);
                    break;
                }
                case CANCELLED: 
                case STOPPED: {
                    if (!this.isStopped()) {
                        this.firePipelineExecutionStoppedListeners();
                        cancelRefreshTimer = true;
                    }
                    this.setStopped(true);
                    this.setRunning(false);
                    this.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_STOPPED);
                    break;
                }
                case FAILED: {
                    this.setStopped(true);
                    this.setFinished(true);
                    this.setErrors(this.getErrors() + 1);
                    cancelRefreshTimer = true;
                    this.logChannel.logBasic("Beam pipeline execution failed.");
                    break;
                }
                case UNKNOWN: {
                    break;
                }
                case RUNNING: 
                case UPDATED: {
                    this.setRunning(true);
                    this.setStopped(false);
                    break;
                }
            }
            if (cancelPipeline) {
                try {
                    this.safelyCall(() -> this.beamPipelineResults.cancel());
                    this.logChannel.logBasic("Pipeline execution cancelled");
                }
                catch (Exception e) {
                    this.logChannel.logError("Cancellation of pipeline failed", (Throwable)e);
                }
            }
            if (cancelRefreshTimer && this.refreshTimer != null) {
                this.refreshTimer.cancel();
            }
        }
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void execute() throws HopException {
        this.prepareExecution();
        this.startThreads();
    }

    public EngineMetrics getEngineMetrics(String componentName, int copyNr) {
        EngineMetrics em = new EngineMetrics();
        em.setStartDate(this.engineMetrics.getStartDate());
        em.setEndDate(this.engineMetrics.getEndDate());
        for (IEngineComponent component : this.engineMetrics.getComponents()) {
            String speed;
            String status;
            if (!component.getName().equalsIgnoreCase(componentName) || component.getCopyNr() != copyNr) continue;
            Boolean running = (Boolean)this.engineMetrics.getComponentRunningMap().get(component);
            if (running != null) {
                em.setComponentRunning(component, running);
            }
            if ((status = (String)this.engineMetrics.getComponentStatusMap().get(component)) != null) {
                em.setComponentStatus(component, status);
            }
            if ((speed = (String)this.engineMetrics.getComponentSpeedMap().get(component)) == null) continue;
            em.setComponentSpeed(component, speed);
        }
        return em;
    }

    public void cleanup() {
    }

    public void waitUntilFinished() {
        while ((this.running || this.paused || this.readyToStart) && !this.stopped && !this.finished) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public void stopAll() {
        try {
            if (this.beamPipelineResults != null) {
                this.safelyCall(() -> this.beamPipelineResults.cancel());
                this.evaluatePipelineStatus();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Stopping of pipeline '" + this.pipelineMeta.getName() + "' failed", e);
        }
    }

    public boolean hasHaltedComponents() {
        return this.hasHaltedComponents;
    }

    public void pauseExecution() {
    }

    public void resumeExecution() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionStartedListener(IExecutionStartedListener executionStartedListener) {
        IExecutionStartedListener iExecutionStartedListener = executionStartedListener;
        synchronized (iExecutionStartedListener) {
            this.executionStartedListeners.add((IExecutionStartedListener<IPipelineEngine<PipelineMeta>>)executionStartedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionFinishedListener(IExecutionFinishedListener executionFinishedListener) {
        IExecutionFinishedListener iExecutionFinishedListener = executionFinishedListener;
        synchronized (iExecutionFinishedListener) {
            this.executionFinishedListeners.add((IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>)executionFinishedListener);
        }
    }

    public String getComponentLogText(String componentName, int copyNr) {
        return "";
    }

    public List<IEngineComponent> getComponents() {
        return this.engineMetrics.getComponents();
    }

    public List<IEngineComponent> getComponentCopies(String name) {
        ArrayList<IEngineComponent> copies = new ArrayList<IEngineComponent>();
        for (IEngineComponent component : this.engineMetrics.getComponents()) {
            if (!component.getName().equalsIgnoreCase(name)) continue;
            copies.add(component);
        }
        return copies;
    }

    public IEngineComponent findComponent(String name, int copyNr) {
        for (IEngineComponent component : this.engineMetrics.getComponents()) {
            if (!component.getName().equalsIgnoreCase(name)) continue;
            return component;
        }
        return null;
    }

    public Result getResult() {
        Result result = new Result();
        result.setNrErrors((long)this.errors);
        result.setResult(this.errors == 0);
        for (IEngineComponent component : this.engineMetrics.getComponents()) {
            result.setNrErrors(result.getNrErrors() + component.getErrors());
            Long read = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_READ);
            result.setNrLinesRead(Math.max(result.getNrLinesRead(), read == null ? 0L : read));
            Long written = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_WRITTEN);
            result.setNrLinesWritten(Math.max(result.getNrLinesWritten(), written == null ? 0L : written));
            Long input = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_INPUT);
            result.setNrLinesInput(Math.max(result.getNrLinesInput(), input == null ? 0L : input));
            Long output = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_OUTPUT);
            result.setNrLinesOutput(Math.max(result.getNrLinesOutput(), output == null ? 0L : output));
            Long updated = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_UPDATED);
            result.setNrLinesUpdated(Math.max(result.getNrLinesUpdated(), updated == null ? 0L : updated));
            Long rejected = this.engineMetrics.getComponentMetric(component, Pipeline.METRIC_REJECTED);
            result.setNrLinesRejected(Math.max(result.getNrLinesRejected(), rejected == null ? 0L : rejected));
        }
        result.setStopped(this.isStopped());
        result.setLogChannelId(this.getLogChannelId());
        return result;
    }

    public void retrieveComponentOutput(IVariables variables, String componentName, int copyNr, int nrRows, IPipelineComponentRowsReceived rowsReceived) throws HopException {
        throw new HopException("Retrieving component output is not supported by the Beam pipeline engine");
    }

    public boolean isSafeModeEnabled() {
        return false;
    }

    public IRowSet findRowSet(String fromTransformName, int fromTransformCopy, String toTransformName, int toTransformCopy) {
        return null;
    }

    public String getObjectName() {
        return this.pipelineMeta.getName();
    }

    public String getFilename() {
        return this.pipelineMeta.getFilename();
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.PIPELINE;
    }

    public String getObjectCopy() {
        return null;
    }

    public Date getRegistrationDate() {
        return null;
    }

    public boolean isGatheringMetrics() {
        return this.logChannel != null && this.logChannel.isGatheringMetrics();
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        if (this.logChannel != null) {
            this.logChannel.setGatheringMetrics(gatheringMetrics);
        }
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        if (this.logChannel != null) {
            this.logChannel.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }

    public boolean isForcingSeparateLogging() {
        return this.logChannel == null ? false : this.logChannel.isForcingSeparateLogging();
    }

    public String getLogChannelId() {
        return this.logChannel.getLogChannelId();
    }

    public void addActiveSubPipeline(String subPipelineName, IPipelineEngine subPipeline) {
        this.activeSubPipelines.put(subPipelineName, subPipeline);
    }

    public IPipelineEngine getActiveSubPipeline(String subPipelineName) {
        return this.activeSubPipelines.get(subPipelineName);
    }

    public void addActiveSubWorkflow(String subWorkflowName, IWorkflowEngine<WorkflowMeta> subWorkflow) {
        this.activeSubWorkflows.put(subWorkflowName, subWorkflow);
    }

    public IWorkflowEngine<WorkflowMeta> getActiveSubWorkflow(String subWorkflowName) {
        return this.activeSubWorkflows.get(subWorkflowName);
    }

    public void setInternalHopVariables(IVariables variables) {
        variables.setVariable("Internal.Pipeline.Name", Const.NVL((String)this.pipelineMeta.getName(), (String)""));
        variables.setVariable("Internal.Pipeline.ID", this.logChannel != null ? this.logChannel.getLogChannelId() : "");
    }

    public IPipelineEngine getParentPipeline() {
        return this.parentPipeline;
    }

    public void setParentPipeline(IPipelineEngine parentPipeline) {
        this.parentPipeline = parentPipeline;
    }

    public IWorkflowEngine<WorkflowMeta> getParentWorkflow() {
        return this.parentWorkflow;
    }

    public void setParentWorkflow(IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        this.parentWorkflow = parentWorkflow;
    }

    public List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> getExecutionStartedListeners() {
        return this.executionStartedListeners;
    }

    public void setExecutionStartedListeners(List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> executionStartedListeners) {
        this.executionStartedListeners = executionStartedListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireExecutionStartedListeners() throws HopException {
        List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            for (IExecutionStartedListener<IPipelineEngine<PipelineMeta>> listener : this.executionStartedListeners) {
                listener.started((Object)this);
            }
        }
    }

    public List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> getExecutionFinishedListeners() {
        return this.executionFinishedListeners;
    }

    public void setExecutionFinishedListeners(List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> executionFinishedListeners) {
        this.executionFinishedListeners = executionFinishedListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionStoppedListener(IExecutionStoppedListener<IPipelineEngine<PipelineMeta>> listener) throws HopException {
        List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            this.executionStoppedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePipelineExecutionStartedListeners() throws HopException {
        List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            for (IExecutionStartedListener<IPipelineEngine<PipelineMeta>> listener : this.executionStartedListeners) {
                listener.started((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePipelineExecutionFinishedListeners() throws HopException {
        List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> list = this.executionFinishedListeners;
        synchronized (list) {
            for (IExecutionFinishedListener<IPipelineEngine<PipelineMeta>> listener : this.executionFinishedListeners) {
                listener.finished((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePipelineExecutionStoppedListeners() throws HopException {
        List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            for (IExecutionStoppedListener<IPipelineEngine<PipelineMeta>> listener : this.executionStoppedListeners) {
                listener.stopped((Object)this);
            }
        }
    }

    public void registerPipelineExecutionInformation() throws HopException {
        if (this.executionInfoLocation != null) {
            this.executionInfoLocation.getExecutionInfoLocation().registerExecution(ExecutionBuilder.fromExecutor((IPipelineEngine)this).build());
        }
    }

    public void lookupExecutionInformationLocation() throws HopException {
        String locationName = this.resolve(this.pipelineRunConfiguration.getExecutionInfoLocationName());
        if (StringUtils.isNotEmpty((String)locationName)) {
            ExecutionInfoLocation location = (ExecutionInfoLocation)this.metadataProvider.getSerializer(ExecutionInfoLocation.class).load(locationName);
            if (location != null) {
                this.executionInfoLocation = location;
                IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
                iLocation.initialize((IVariables)this, this.metadataProvider);
                this.addExecutionFinishedListener(l -> iLocation.close());
            } else {
                this.logChannel.logError("Execution information location '" + locationName + "' could not be found in the metadata");
            }
        }
    }

    public void startExecutionInfoTimer() throws HopException {
        if (this.executionInfoLocation == null) {
            return;
        }
        long delay = Const.toLong((String)this.resolve(this.executionInfoLocation.getDataLoggingDelay()), (long)2000L);
        long interval = Const.toLong((String)this.resolve(this.executionInfoLocation.getDataLoggingInterval()), (long)5000L);
        final IExecutionInfoLocation iLocation = this.executionInfoLocation.getExecutionInfoLocation();
        TimerTask sampleTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ExecutionState executionState = ExecutionStateBuilder.fromExecutor((IPipelineEngine)BeamPipelineEngine.this, (Integer)-1).build();
                    iLocation.updateExecutionState(executionState);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error registering execution info (data and state) at location " + BeamPipelineEngine.this.executionInfoLocation.getName(), e);
                }
            }
        };
        this.executionInfoTimer = new Timer();
        this.executionInfoTimer.schedule(sampleTask, delay, interval);
    }

    public void stopExecutionInfoTimer() throws HopException {
        if (this.executionInfoLocation == null) {
            return;
        }
        this.executionInfoTimer.cancel();
        ExecutionState executionState = ExecutionStateBuilder.fromExecutor((IPipelineEngine)this, (Integer)-1).build();
        this.executionInfoLocation.getExecutionInfoLocation().updateExecutionState(executionState);
        this.executionInfoLocation.getExecutionInfoLocation().close();
    }

    public List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> getExecutionStoppedListeners() {
        return this.executionStoppedListeners;
    }

    public void setExecutionStoppedListeners(List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> executionStoppedListeners) {
        this.executionStoppedListeners = executionStoppedListeners;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public PipelineRunConfiguration getPipelineRunConfiguration() {
        return this.pipelineRunConfiguration;
    }

    public void setPipelineRunConfiguration(PipelineRunConfiguration pipelineRunConfiguration) {
        this.pipelineRunConfiguration = pipelineRunConfiguration;
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public void setPipelineMeta(PipelineMeta subject) {
        this.pipelineMeta = subject;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public boolean isPreparing() {
        return this.preparing;
    }

    public void setPreparing(boolean preparing) {
        this.preparing = preparing;
    }

    public boolean isReadyToStart() {
        return this.readyToStart;
    }

    public void setReadyToStart(boolean readyToStart) {
        this.readyToStart = readyToStart;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public ILogChannel getLogChannel() {
        return this.logChannel;
    }

    public void setLogChannel(ILogChannel log) {
        this.logChannel = log;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public EngineMetrics getEngineMetrics() {
        return this.engineMetrics;
    }

    public void setEngineMetrics(EngineMetrics engineMetrics) {
        this.engineMetrics = engineMetrics;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public ILoggingObject getParent() {
        return this.parent;
    }

    public void setParent(ILoggingObject parent) {
        this.parent = parent;
        this.logChannel = new LogChannel((Object)this, parent);
        this.logLevel = this.logChannel.getLogLevel();
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public boolean isHasHaltedComponents() {
        return this.hasHaltedComponents;
    }

    public void setHasHaltedComponents(boolean hasHaltedComponents) {
        this.hasHaltedComponents = hasHaltedComponents;
    }

    public int getLastLogLineNr() {
        return this.lastLogLineNr;
    }

    public void setLastLogLineNr(int lastLogLineNr) {
        this.lastLogLineNr = lastLogLineNr;
    }

    public ILoggingObject getLoggingObject() {
        return this.loggingObject;
    }

    public void setLoggingObject(ILoggingObject loggingObject) {
        this.loggingObject = loggingObject;
    }

    public Result getPreviousResult() {
        return this.previousResult;
    }

    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    public Map<String, IPipelineEngine> getActiveSubPipelines() {
        return this.activeSubPipelines;
    }

    public void setActiveSubPipelines(Map<String, IPipelineEngine> activeSubPipelines) {
        this.activeSubPipelines = activeSubPipelines;
    }

    public Map<String, IWorkflowEngine<WorkflowMeta>> getActiveSubWorkflows() {
        return this.activeSubWorkflows;
    }

    public void setActiveSubWorkflows(Map<String, IWorkflowEngine<WorkflowMeta>> activeSubWorkflows) {
        this.activeSubWorkflows = activeSubWorkflows;
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void removeAllParameters() {
        this.namedParams.removeAllParameters();
    }

    public void clearParameterValues() {
        this.namedParams.clearParameterValues();
    }

    public void copyParametersFromDefinitions(INamedParameterDefinitions definitions) {
        this.namedParams.copyParametersFromDefinitions(definitions);
    }

    public void activateParameters(IVariables variables) {
        this.namedParams.activateParameters(variables);
    }

    public boolean isFeedbackShown() {
        return false;
    }

    public int getFeedbackSize() {
        return 0;
    }

    public <Store extends IExecutionDataSamplerStore, Sampler extends IExecutionDataSampler<Store>> void addExecutionDataSampler(Sampler sampler) throws HopException {
        this.dataSamplers.add(sampler);
    }

    public PipelineEngineCapabilities getEngineCapabilities() {
        return this.engineCapabilities;
    }

    public INamedParameters getNamedParams() {
        return this.namedParams;
    }

    public void setNamedParams(INamedParameters namedParams) {
        this.namedParams = namedParams;
    }

    public EngineComponent.ComponentExecutionStatus getStatus() {
        return this.status;
    }

    public Map<String, Object> getExtensionDataMap() {
        return this.extensionDataMap;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public void setStatus(EngineComponent.ComponentExecutionStatus status) {
        this.status = status;
    }

    public void setExtensionDataMap(Map<String, Object> extensionDataMap) {
        this.extensionDataMap = extensionDataMap;
    }

    public Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    public void setExecutionStartDate(Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    public Date getExecutionEndDate() {
        return this.executionEndDate;
    }

    public void setExecutionEndDate(Date executionEndDate) {
        this.executionEndDate = executionEndDate;
    }

    public HopPipelineMetaToBeamPipelineConverter getConverter() {
        return this.converter;
    }

    public void setConverter(HopPipelineMetaToBeamPipelineConverter converter) {
        this.converter = converter;
    }

    public org.apache.beam.sdk.Pipeline getBeamPipeline() {
        return this.beamPipeline;
    }

    public void setBeamPipeline(org.apache.beam.sdk.Pipeline beamPipeline) {
        this.beamPipeline = beamPipeline;
    }

    public Thread getBeamThread() {
        return this.beamThread;
    }

    public void setBeamThread(Thread beamThread) {
        this.beamThread = beamThread;
    }

    public PipelineResult getBeamPipelineResults() {
        return this.beamPipelineResults;
    }

    public void setBeamPipelineResults(PipelineResult beamPipelineResults) {
        this.beamPipelineResults = beamPipelineResults;
    }

    public IBeamPipelineEngineRunConfiguration getBeamEngineRunConfiguration() {
        return this.beamEngineRunConfiguration;
    }

    public void setBeamEngineRunConfiguration(IBeamPipelineEngineRunConfiguration beamEngineRunConfiguration) {
        this.beamEngineRunConfiguration = beamEngineRunConfiguration;
    }

    private <R> R safelyCall(ThrowingSupplier<R> supplier) {
        return this.safelyCall(supplier, null);
    }

    private <R> R safelyCall(ThrowingSupplier<R> supplier, R defaultValue) {
        try {
            return (R)supplier.get();
        }
        catch (UnsupportedOperationException e) {
            this.logChannel.logBasic(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return defaultValue;
    }
}

