/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.pipeline.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.joinlibrary.Join;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.HopKeyValueFn;
import org.apache.hop.beam.core.fn.MergeJoinAssemblerFn;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.pipeline.handler.BeamBaseTransformHandler;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.mergejoin.MergeJoinMeta;

public class BeamMergeJoinTransformHandler
extends BeamBaseTransformHandler
implements IBeamPipelineTransformHandler {
    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        int assemblerJoinType;
        PCollection kvpCollection;
        MergeJoinMeta meta = new MergeJoinMeta();
        this.loadTransformMetadata((ITransformMeta)meta, transformMeta, metadataProvider, pipelineMeta);
        String joinType = meta.getJoinType();
        String[] leftKeys = meta.getKeyFields1().toArray(new String[0]);
        String[] rightKeys = meta.getKeyFields2().toArray(new String[0]);
        TransformMeta leftInfoTransform = ((IStream)meta.getTransformIOMeta().getInfoStreams().get(0)).getTransformMeta();
        if (leftInfoTransform == null) {
            throw new HopException("The left source transform isn't defined in the Merge Join transform called '" + transformMeta.getName() + "'");
        }
        PCollection<HopRow> leftPCollection = transformCollectionMap.get(leftInfoTransform.getName());
        if (leftPCollection == null) {
            throw new HopException("The left source collection in the pipeline couldn't be found (probably a programming error)");
        }
        IRowMeta leftRowMeta = pipelineMeta.getTransformFields(variables, leftInfoTransform);
        TransformMeta rightInfoTransform = ((IStream)meta.getTransformIOMeta().getInfoStreams().get(1)).getTransformMeta();
        if (rightInfoTransform == null) {
            throw new HopException("The right source transform isn't defined in the Merge Join transform called '" + transformMeta.getName() + "'");
        }
        PCollection<HopRow> rightPCollection = transformCollectionMap.get(rightInfoTransform.getName());
        if (rightPCollection == null) {
            throw new HopException("The right source collection in the pipeline couldn't be found (probably a programming error)");
        }
        IRowMeta rightRowMeta = pipelineMeta.getTransformFields(variables, rightInfoTransform);
        ArrayList<String> leftK = new ArrayList<String>(Arrays.asList(leftKeys));
        RowMeta leftKRowMeta = new RowMeta();
        ArrayList<String> leftV = new ArrayList<String>();
        RowMeta leftVRowMeta = new RowMeta();
        for (String leftKey : leftKeys) {
            leftKRowMeta.addValueMeta(leftRowMeta.searchValueMeta(leftKey).clone());
        }
        for (IValueMeta valueMeta : leftRowMeta.getValueMetaList()) {
            String valueName = valueMeta.getName();
            if (Const.indexOfString((String)valueName, (String[])leftKeys) >= 0) continue;
            leftV.add(valueName);
            leftVRowMeta.addValueMeta(valueMeta.clone());
        }
        HopKeyValueFn leftKVFn = new HopKeyValueFn(JsonRowMeta.toJson((IRowMeta)leftRowMeta), transformPluginClasses, xpPluginClasses, leftK.toArray(new String[0]), leftV.toArray(new String[0]), transformMeta.getName());
        PCollection leftKVPCollection = (PCollection)leftPCollection.apply((PTransform)ParDo.of((DoFn)leftKVFn));
        ArrayList<String> rightK = new ArrayList<String>(Arrays.asList(rightKeys));
        RowMeta rightKRowMeta = new RowMeta();
        ArrayList<String> rightV = new ArrayList<String>();
        RowMeta rightVRowMeta = new RowMeta();
        for (String rightKey : rightKeys) {
            rightKRowMeta.addValueMeta(rightRowMeta.searchValueMeta(rightKey).clone());
        }
        for (IValueMeta valueMeta : rightRowMeta.getValueMetaList()) {
            String valueName = valueMeta.getName();
            if (Const.indexOfString((String)valueName, (String[])rightKeys) >= 0) continue;
            rightV.add(valueName);
            rightVRowMeta.addValueMeta(valueMeta.clone());
        }
        HopKeyValueFn rightKVFn = new HopKeyValueFn(JsonRowMeta.toJson((IRowMeta)rightRowMeta), transformPluginClasses, xpPluginClasses, rightK.toArray(new String[0]), rightV.toArray(new String[0]), transformMeta.getName());
        PCollection rightKVPCollection = (PCollection)rightPCollection.apply((PTransform)ParDo.of((DoFn)rightKVFn));
        Object[] leftNull = new Object[]{};
        Object[] rightNull = new Object[]{};
        if (MergeJoinMeta.joinTypes[0].equals(joinType)) {
            kvpCollection = Join.innerJoin((PCollection)leftKVPCollection, (PCollection)rightKVPCollection);
            assemblerJoinType = MergeJoinAssemblerFn.JOIN_TYPE_INNER;
        } else if (MergeJoinMeta.joinTypes[1].equals(joinType)) {
            kvpCollection = Join.leftOuterJoin((PCollection)leftKVPCollection, (PCollection)rightKVPCollection, (Object)new HopRow(rightNull));
            assemblerJoinType = MergeJoinAssemblerFn.JOIN_TYPE_LEFT_OUTER;
        } else if (MergeJoinMeta.joinTypes[2].equals(joinType)) {
            kvpCollection = Join.rightOuterJoin((PCollection)leftKVPCollection, (PCollection)rightKVPCollection, (Object)new HopRow(leftNull));
            assemblerJoinType = MergeJoinAssemblerFn.JOIN_TYPE_RIGHT_OUTER;
        } else if (MergeJoinMeta.joinTypes[3].equals(joinType)) {
            kvpCollection = Join.fullOuterJoin((PCollection)leftKVPCollection, (PCollection)rightKVPCollection, (Object)new HopRow(leftNull), (Object)new HopRow(rightNull));
            assemblerJoinType = MergeJoinAssemblerFn.JOIN_TYPE_FULL_OUTER;
        } else {
            throw new HopException("Join type '" + joinType + "' is not recognized or supported");
        }
        IRowMeta outputRowMeta = leftRowMeta.clone();
        outputRowMeta.addRowMeta(rightRowMeta.clone());
        MergeJoinAssemblerFn assemblerFn = new MergeJoinAssemblerFn(assemblerJoinType, JsonRowMeta.toJson((IRowMeta)leftRowMeta), JsonRowMeta.toJson((IRowMeta)rightRowMeta), JsonRowMeta.toJson((IRowMeta)leftKRowMeta), JsonRowMeta.toJson((IRowMeta)leftVRowMeta), JsonRowMeta.toJson((IRowMeta)rightKRowMeta), JsonRowMeta.toJson((IRowMeta)rightVRowMeta), transformMeta.getName(), transformPluginClasses, xpPluginClasses);
        PCollection transformPCollection = (PCollection)kvpCollection.apply((PTransform)ParDo.of((DoFn)assemblerFn));
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)transformPCollection);
        log.logBasic("Handled Merge Join (TRANSFORM) : " + transformMeta.getName());
    }
}

